#include <QtGui/QMainWindow>
#include <QPushButton>
#include <QRadioButton>
#include <QGridLayout>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>

#include "settings.h" 
#include "misc.h" 

MiscSettingsWindow::MiscSettingsWindow(QMainWindow* parent) : SettingsWindow(parent),ICONPATH("/opt/showtime/icons/")
{
	setWindowTitle("MISC SETTINGS");

	loadSettings();

	QWidget *_mainwidget = new QWidget;

	QGroupBox *orientBox = new QGroupBox("Orientation");
	QGroupBox *remindBox = new QGroupBox("Remind Type");
	QGroupBox *iconBox = new QGroupBox("Icon Style");
	QGroupBox *previewBox = new QGroupBox("Icon Preview");

	QRadioButton *radio1 = new QRadioButton("LANDSCAPE");
	QRadioButton *radio2 = new QRadioButton("PORTRAIT");
	QRadioButton *radio3 = new QRadioButton("AUTO");
	QRadioButton *radio4 = new QRadioButton("EVENT");
	QRadioButton *radio5 = new QRadioButton("ALARM");
	QRadioButton *radio6 = new QRadioButton("SET1");
	QRadioButton *radio7 = new QRadioButton("SET2");
	QRadioButton *radio8 = new QRadioButton("SET3");

	QHBoxLayout *box1 = new QHBoxLayout;
	QHBoxLayout *box2 = new QHBoxLayout;
	QHBoxLayout *box3 = new QHBoxLayout;
	QHBoxLayout *box4 = new QHBoxLayout;

	box1->addWidget(radio1);
	box1->addWidget(radio2);
	box1->addWidget(radio3);
	box1->addStretch(1);
	orientBox->setLayout(box1);

	box2->addWidget(radio4);
	box2->addWidget(radio5);
	box2->addStretch(1);
	remindBox->setLayout(box2);

	box3->addWidget(radio6);
	box3->addWidget(radio7);
	box3->addWidget(radio8);
	box3->addStretch(1);
	iconBox->setLayout(box3);

	preview1 = new QLabel;
	preview2 = new QLabel;
	preview3 = new QLabel;
	box4->addWidget(preview1);
	box4->addWidget(preview2);
	box4->addWidget(preview3);
	previewBox->setLayout(box4);

	QPushButton *cancelButton = new QPushButton("CANCEL");
	QPushButton *saveButton = new QPushButton("SAVE");

	QGridLayout *grid = new QGridLayout;
	grid->addWidget(orientBox, 0, 0);
	grid->addWidget(remindBox, 0, 1);
	grid->addWidget(iconBox, 1, 0);
	grid->addWidget(previewBox, 1, 1);
	grid->addWidget(cancelButton, 2, 0);
	grid->addWidget(saveButton, 2, 1);
	_mainwidget->setLayout(grid);

	setCentralWidget(_mainwidget);

	connect(radio1, SIGNAL(clicked()), this, SLOT(setLandscape()));
	connect(radio2, SIGNAL(clicked()), this, SLOT(setPortrait()));
	connect(radio3, SIGNAL(clicked()), this, SLOT(setAuto()));
	connect(radio4, SIGNAL(clicked()), this, SLOT(setEventOnly()));
	connect(radio5, SIGNAL(clicked()), this, SLOT(setEventAndAlarm()));
	connect(radio6, SIGNAL(clicked()), this, SLOT(setIconSet1()));
	connect(radio7, SIGNAL(clicked()), this, SLOT(setIconSet2()));
	connect(radio8, SIGNAL(clicked()), this, SLOT(setIconSet3()));
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancel()));
	connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));

	// set the existing values
	if(getOrientation() == "PORTRAIT") radio2->setChecked(true);
	else if(getOrientation() == "AUTO") radio3->setChecked(true);
	else 
	{
		radio1->setChecked(true);  // default is landscape
		setOrientation("LANDSCAPE");
	}

	if(getRemindType() == "EVENT") radio4->setChecked(true);
	else 
	{
		radio5->setChecked(true);  // default is alarm
		setRemindType("ALARM");
	}

	if(getIconType() == "SET2") 
	{
		setIconSet2();
		radio7->setChecked(true);
	}
	else if(getIconType() == "SET3") 
	{
		setIconSet3();
		radio8->setChecked(true);
	}
	else 
	{
		setIconSet1();
		radio6->setChecked(true);  // default is set1
	}
}

void MiscSettingsWindow::setLandscape() { setOrientation("LANDSCAPE"); }
void MiscSettingsWindow::setPortrait() { setOrientation("PORTRAIT"); }
void MiscSettingsWindow::setAuto() { setOrientation("AUTO"); }
void MiscSettingsWindow::setEventOnly() { setRemindType("EVENT"); }
void MiscSettingsWindow::setEventAndAlarm() { setRemindType("ALARM"); }
void MiscSettingsWindow::setIconSet1() { setIconSet("SET1"); }
void MiscSettingsWindow::setIconSet2() { setIconSet("SET2"); }
void MiscSettingsWindow::setIconSet3() { setIconSet("SET3"); }

void MiscSettingsWindow::setIconSet(QString iconset) 
{ 
	SettingsWindow::setIconType(iconset); 
	preview1->setPixmap(QString(ICONPATH)+iconset+"/"+"go.png"); 
	preview2->setPixmap(QString(ICONPATH)+iconset+"/"+"remind.png"); 
	preview3->setPixmap(QString(ICONPATH)+iconset+"/"+"record.png"); 
}

void MiscSettingsWindow::cancel() { emit clicked(); }
void MiscSettingsWindow::save() { updateSettings(); emit clicked(); }

MiscSettingsWindow::~MiscSettingsWindow() { }
