#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QStringList>
#include <QSet>
#include <QProcess>

#include <infoaccess.h>
#include <channeldatawindow.h>

class QWidget;
class QStandardItemModel;
class QVBoxLayout;
class QHBoxLayout;
class QPushButton;
class QMenu;
class QAction;
class QMaemo5ValueButton;
class QMaemo5ListPickSelector;
class QTextBrowser;
class QTableWidget;
class QTableWidgetItem;
class QListWidget;
class QListWidgetItem;
class QLabel;
class Reminder;
class SettingsWindow;
class RegionWindow;
class FavouriteWindow;
class MiscSettingsWindow;

class MainWindow : public QMainWindow 
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

public slots:

private slots:
	void go();
	void selectDate(QString date);
	void selectChannel(QString);
	void loadFavourites();
	void orientationChanged(const QString &newOrientation);
	void clearAll();
	void clearProg();
	void finished(bool ok = true);
	void showProgrammeListWidget(bool dataRequested = false);
	void showProgrammeListWidgetButtons();
	void showProgrammeDetailWidget();
	void showNextChannel();
	void showPrevChannel();
	void addProgrammeActionList(QListWidgetItem* programme);
	void showRecordMessage();
	void showRemindMessage();
	void loadXMLTV();
	void showDonate();
	void showRegion();
	void showFavourite();
	void showSettings();
	void showHelp();
	void reInitFavouriteSettings();
	void reInitInfoAccess();
	void reInitMiscSettings();

private: // functions
	void initAppSettings();
	void initCalendar();
	void initListModels();
	void showNextPrevChannelButtons();
	void showInfoLabel(QString label);
	void enableDateSelector();
	void disableDateSelector();
	void createMenus();
	void initOrientation();
	void setPortrait();
	void setLandscape();
	void initPortrait();
	void initLandscape();
	void toggleBusy(bool isBusy);

private:
    // downloads/reads the smltv data into memory
	InfoAccess *_infoapi;

    // orientation specific widgets
	QWidget *	  _portraitMainWidget;
	QWidget *	  _landscapeMainWidget;

    // interface to the calendar backend to set alarms/events
	Reminder*	_reminderManager;

    // hold the app settings in memory
	SettingsWindow	*_settingsWindow;

	// this is the window used to display the favourite selection
	FavouriteWindow *_favouriteWindow;

	// this is the window used to display the region selection
	RegionWindow *_regionWindow;

	// this is the window used to display the region selection
	MiscSettingsWindow *_miscWindow;

    // MENU stuff
	QMenu *menu;
	QAction *regionAct;
	QAction *favAct;
	QAction *setAct;
	QAction *helpAct;
	QAction *donateAct;

    // Widgets used
	QMaemo5ValueButton	*_dateSelector;
	QMaemo5ListPickSelector *_dateSelectorList;
	QStandardItemModel *_dateListModel;
	QMaemo5ValueButton *_channelSelector;
	QMaemo5ListPickSelector *_channelSelectorList;
	QStandardItemModel *_channelListModel;
    QPushButton* _weeklyModeButton;
    QPushButton* _goButton;
    QPushButton* _programmeDetailButton;
    QPushButton* _recordButton;
    QPushButton* _remindButton;
    QPushButton* _nextChannelButton;
    QPushButton* _prevChannelButton;
    QPushButton* _backToProgrammeListButton;
    QPushButton* _clearButton;
    QPushButton* _clearProgButton;

	QListWidget *_programmeList;
	QListWidgetItem *_programmeItem;
	QLabel *_programmeItemLabel;
	QTextBrowser *_programmeDetail;
	QLabel *_programmeDetailLabel;
	QLabel *_infoLabel;

	// LANDSCAPE MODE LAYOUTS
	QHBoxLayout *_lh1layout;
	QVBoxLayout *_lv1layout;
	QVBoxLayout *_lv2layout;
	QHBoxLayout *_landscapeLayout;

	// PORTRAIT MODE LAYOUTS
	QHBoxLayout *_ph1layout;
	QHBoxLayout *_ph2layout;
	QHBoxLayout *_ph3layout;
	QHBoxLayout *_ph4layout;
	QVBoxLayout *_pv1layout;
	QHBoxLayout *_portraitLayout;

    // Map to hold the xmltv data in memory
    QMap<QString, ChannelData> _channelDataMap;

	// list of selected channels
	QStringList _channelsSelected;

	// current selected channel
    QString	_currentChannel;

	// current selected date
    QDate	_currentDate;

    // chosen programme list
    QSet<QString> _programmeSetForAction;

    // index to keep track of the current channel
	int	_channelIndex;

	/////////////// APP SETTINGS //////////////
	QStringList	_favourites;
	///////////////////////////////////////////

    // bool to indicate we are in landscape mode
	bool _landscapeOrientation;	
};

#endif // MAINWINDOW_H
