#ifndef ESFILES_H
#define ESFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QMap>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class ESFiles : public DataDownloader
{
    Q_OBJECT

public:
    ESFiles( QObject *parent );
    virtual ~ESFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void updateSettingsFile();
	virtual void checkDataStatus();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList();
	void sendRecordMsg(QStringList data);

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;

	// ES channels names are different from the channel code we need during a network download request url
	// hence we maintain this mapping as the codes dont mean much to the user while displaying the list :)
	QMap<QString , QString> _channelCodeMap;
};

#endif // ESFILES_H
