#ifndef DATADOWNLOADER_H
#define DATADOWNLOADER_H

#include <QObject>
#include <QStringList>
#include <QUrl>
#include <QDate>
#include <QMap>

class QFile;
class QIODevice;

struct DownloadInput
{
	QString requestChannel;
	bool	downloadIndicator;
	QDate requestDate;
};

class DataDownloader : public QObject
{
    Q_OBJECT

public:
    DataDownloader( QObject *parent );
    DataDownloader( QObject *parent , const char* datapath);
	virtual void initSettings();
    virtual ~DataDownloader();
	virtual QUrl getUrl() = 0;
	virtual void updateSettingsFile() = 0;
	virtual void checkDataStatus() = 0;
	virtual QString saveFile(QString channel, QIODevice *source);
	virtual QString saveZipFile(QString channel, QIODevice *source);
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList() = 0;
	virtual QStringList getFilelist(QString channel);
	virtual void sendRecordMsg(QStringList input) = 0;

signals:

public slots:

private slots:

protected:
	QMap<QString, QList<QString> > _channelDateMap;
	QFile *_settingsFile;
	// input to download
	QString _requestChannel;
	// to indicate data available in files is current or not
	bool _useLocal;
	// to indicate if user has selected the requestCHannel for downloading weekly data
	bool _downloadIndicator;
	// to indicate a date for which download was requested
	QDate _requestDate;

	int _downloadStartIndex;
	int _downloadEndIndex;

	// path to the regional settings file, init'ed by child classes
	const char* DATAPATH;

private:
};

#endif // DATADOWNLOADER_H
