#ifndef AUFILES_H
#define AUFILES_H

#include <QObject>
#include <QStringList>
#include <QSet>
#include <QUrl>
#include <QProcess>

class QIODevice;

#include "datadownloader.h"

class AUFiles : public DataDownloader
{
    Q_OBJECT

public:
    AUFiles( QObject *parent );
    virtual ~AUFiles();
	virtual QUrl getUrl();
	void initSettings();
	virtual void updateSettingsFile();
	virtual void checkDataStatus();
	virtual void setInput(DownloadInput d);
	virtual QString finishedDownload(QString channel, QIODevice *source);
	virtual QStringList getChannelList();
	void sendRecordMsg(QStringList data);

signals:

public slots:

private slots:
	void sentRecordMsg(int exitCode, QProcess::ExitStatus exitStatus);

protected:
	void updateDownloadIndexes();

private:
	const char* HELPERPATH;
};

#endif // AUFILES_H
