/*
 * This file is part of mysocials sharing plugin
 *
 */

#include <stdio.h>
#include <glib.h>
#include <osso-log.h>
#include <conicconnection.h>
#include "validate.h"
#include "libmsa_interface.h"

/**
 * test:
 * @account: #SharingAccount to be tested
 * @con: Connection used
 * @dead_mans_switch: Turn to %FALSE at least every 30 seconds.
 *
 * Test if #SharingAccount is valid.
 *
 * Returns: #SharingPluginInterfaceTestAccountResult
 */
SharingPluginInterfaceAccountValidateResult validate (SharingAccount* account,
    ConIcConnection* con, gboolean *cont, gboolean* dead_mans_switch)
{
    SharingPluginInterfaceAccountValidateResult ret =
        SHARING_ACCOUNT_VALIDATE_SUCCESS;
    
    gchar* account_name = sharing_account_get_username (account);

    if(!libvk_init(con, account_name)) {
        ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
    } else {
        if(!libvk_testConnection(account)) {
           ret = SHARING_ACCOUNT_VALIDATE_ERROR_UNKNOWN;
        }
        libvk_uninit (account_name);
    }

    return ret;
}
