/*
 * This file is part of sharing-plugin-blipfoto
 *
 * Copyright (C) 2010 Dave Elcock. All rights reserved.
 *
 * This code is licensed under a MIT-style license, that can be
 * found in the file called "COPYING" in the root directory.
 *
 */

#ifndef __BLIP_ENTRY_H__
#define __BLIP_ENTRY_H__

#include <glib.h>

#include "blip_connection.h"

G_BEGIN_DECLS

        struct BlipEntry_s;
typedef struct BlipEntry_s* BlipEntry;

BlipEntry blip_entry_create();

/**
 * @brief Frees up resources used by the BlipEntry.
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 */
void blip_entry_free(BlipEntry entry);

/**
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 * @param [in] fullPath
 *   Absolute path to file to upload.
 */
void blip_entry_set_image_full_path(BlipEntry entry,
                                    const gchar* fullPath);
/**
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 */
void blip_entry_set_title(BlipEntry entry,
                          const gchar* title);
/**
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 */
void blip_entry_set_description(BlipEntry entry,
                                const gchar* description);
/**
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 * @param [in] tags
 *   Comma-separated list of tags to assign to the entry.
 */
void blip_entry_set_tags(BlipEntry entry,
                         const gchar* tags);
/**
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 */
void blip_entry_set_date(BlipEntry entry,
                         guint year,
                         guint month,
                         guint day);

/**
 * @brief Sets the connection up to post the data for this entry.
 * @param [in] entry
 *   A valid BlipEntry created with blip_entry_create().
 * @param [in,modified]
 *   A valid BlipConnection created with blip_connection_create().
 */
void blip_entry_set_connection_options(BlipEntry entry,
                                       BlipConnection connection);

G_END_DECLS

#endif // ! __BLIP_ENTRY_H__
