/*
 * This file is part of sharing-plugin-blipfoto
 *
 * Copyright (C) 2010 Dave Elcock. All rights reserved.
 *
 * This code is licensed under a MIT-style license, that can be
 * found in the file called "COPYING" in the root directory.
 *
 */

#ifndef __BLIP_DEFINES_H__
#define __BLIP_DEFINES_H__

#define BLIP_API_BASE "http://api.blipfoto.com"

#define BLIP_RESOURCE_GET_DATEVALIDATION "get/datevalidation/"
#define BLIP_RESOURCE_GET_TIME           "get/time/"
#define BLIP_RESOURCE_GET_TOKEN          "get/token/"
#define BLIP_RESOURCE_POST_ENTRY         "post/entry/"
#define BLIP_RESOURCE_POST_IMAGE         "post/image/"
#define BLIP_RESOURCE_TESTPOST_ENTRY     "testpost/entry/"

#define BLIP_ARG_API_KEY    "api_key"
#define BLIP_ARG_ENTRY_DATE "entry_date"
#define BLIP_ARG_TEMP_TOKEN "temp_token"
#define BLIP_ARGS_DONE      NULL

#define BLIP_ERROR_NO_CONTEXT                -1
#define BLIP_ERROR_NONE                       0

// NOT an actual error. Used to terminate list of arguments to blip_error_match().
// Sorry, it's a bit hacky-looking.
#define BLIP_ERROR_MATCH_END         1234567890

#define BLIP_API_ERROR_API_SERVICE_UNAVAILABLE            1 // "The API service is currently unavailable for a short period."

#define BLIP_API_ERROR_NO_AUTHENTICATION_TOKEN          500 // "You have not specified an authentication token."
#define BLIP_API_ERROR_INVALID_AUTHENTICATION_TOKEN     501 // "The specified authentication token is invalid."
#define BLIP_API_ERROR_MISSING_NONCE                    502 // "You have not specified an authentication nonce."
#define BLIP_API_ERROR_MISSING_AUTHENTICATION_SIGNATURE 503 // "You have not specified an authentication signature."
#define BLIP_API_ERROR_MISSING_AUTHENTICATION_TOKEN     504 // "You have not specified an authentication token."
#define BLIP_API_ERROR_MISSING_AUTHENTICATION_TIMESTAMP 505 // "You have not specified an authentication timestamp."
#define BLIP_API_ERROR_AUTHENTICATION_WINDOW_ELAPSED    506 // "The authentication window has elapsed."
#define BLIP_API_ERROR_DUPLICATE_AUTHENTICATION_NONCE   507 // "The supplied authentication nonce has already been used."
#define BLIP_API_ERROR_AUTHENTICATION_FAILED            508 // "Authentication failed."
#define BLIP_API_ERROR_RESOURCE_UNAVAILABLE_FOR_API_KEY 509 // "The resource is not available with your API key."
#define BLIP_API_ERROR_MISSING_EMAIL_ADDRESS            510 // "No email address provided."
#define BLIP_API_ERROR_MISSING_PASSWORD                 511 // "No password provided."
#define BLIP_API_ERROR_ENTRY_DOES_NOT_EXIST             512 // "The requested entry does not exist."
#define BLIP_API_ERROR_USER_DOES_NOT_EXIST              513 // "The requested user does not exist."
#define BLIP_API_ERROR_MISSING_COMMENT                  514 // "No comment provided."
#define BLIP_API_ERROR_COMMENTS_DISABLED_FOR_THIS_ENTRY 515 // "Comments are disabled for this entry."

#define BLIP_API_ERROR_IMAGE_DATA_MISSING               600 // "Request did not include image data."
#define BLIP_API_ERROR_IMAGE_FORMAT_NOT_SUPPORTED       601 // "The image format is not supported, or the image did not upload successfully."
#define BLIP_API_ERROR_IMAGE_FILESIZE_EXCEEDED          602 // "The image filesize exceeds the allowed limit."
#define BLIP_API_ERROR_IMAGE_DIMENSIONS_TOO_SMALL       603 // "The image dimensions are too small."
#define BLIP_API_ERROR_IMAGE_INTERNAL_ERROR             604 // "An internal error occured which prevented the file from uploading."
#define BLIP_API_ERROR_IMAGE_NOT_PREVIOUSLY_UPLOADED    605 // "There is no previously uploaded image available."
#define BLIP_API_ERROR_DATE_MISSING                     606 // "Request did not include a date, or the image EXIF date was not set."
#define BLIP_API_ERROR_DATE_INVALID                     607 // "The entry date was invalid."
#define BLIP_API_ERROR_DATE_IN_FUTURE                   608 // "The entry date is a date in the future."
#define BLIP_API_ERROR_DATE_BEFORE_SIGNUP_DATE          609 // "The entry date is before your signup date."
#define BLIP_API_ERROR_DATE_USED_ALREADY                610 // "There is an existing journal entry for the entry date."
#define BLIP_API_ERROR_DATE_BEFORE_DATE_OF_BIRTH        611 // "The entry date is before your date of birth."
#define BLIP_API_ERROR_DATE_MALFORMED                   612 // "The specified journal entry date does not correspond to a day of the year."

#define BLIP_API_ERROR_INTERNAL_ERROR                  1000 // "An internal error occured and your request could not be processed."

#endif // __BLIP_DEFINES_H__
