/*
 * This file is part of sharing-plugin-blipfoto
 *
 * Copyright (C) 2010 Dave Elcock. All rights reserved.
 *
 * This code is licensed under a MIT-style license, that can be
 * found in the file called "COPYING" in the root directory.
 *
 */

#include "blip_response.h"

struct BlipResponse_s
{
    gchar* data;
    gsize  size;
    gsize  capacity;
};

BlipResponse blip_response_create()
{
    BlipResponse response= (BlipResponse) g_try_malloc0(sizeof(struct BlipResponse_s));
    response->size= 0;
    response->capacity= 512;
    response->data= g_malloc(response->capacity);
    response->data[0]= '\0';
    return response;
}

void blip_response_free(BlipResponse response)
{
    if (response)
    {
        g_free(response->data);
        g_free(response);
    }
}

gchar* blip_response_get_text(BlipResponse response)
{
    if (response)
    {
        return g_strdup(response->data);
    }
    return NULL;
}

size_t blip_response_append(BlipResponse response,
                            const gchar* text,
                            size_t size)
{
    if (response)
    {
        size_t required= response->size + size + 1;
        if (required > response->capacity)
        {
            size_t newsize= response->capacity*2;
            while (newsize < required)
            {
                newsize *= 2;
            }
            response->data= g_realloc(response->data,
                                      newsize);
            response->capacity= newsize;
        }
        g_strlcat(response->data, text, response->capacity);
        return size;
    }
    return 0;
}
