/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef MAIN_H
#define	MAIN_H
#include <SDL.h>
#include "Ball.h"

#define SMIDGE 0.0001

void* callback_param;
SDL_Surface* LoadImage(char* file);

void DrawScene();
void DrawTBPanel();
void DrawLine(Ball *s1, Ball *s2);

void Init();

// timer callbacks
Uint32 TimerCallback(Uint32 interval, void *param);
Uint32 DevCallback(Uint32 interval, void *param);

void PrintTTF(SDL_Surface* sDest,
              char* message,
              const char* font,
              int size,
              SDL_Color color,
              SDL_Rect dest);
void ShowInfo();

SDL_Surface* LoadImageAlpha(const char *file);
SDL_Surface* LoadImage(const char *file);

// move functions
void MoveBall();
void AccMoveBall();
void MoveCrazyBalls();
void MoveTailBalls();
void MoveStars();

void CountLinks();
void CountScore(int num_links);
void FindFreePosition(Ball *b);

void LocateBalls();
void SolveLink(Ball* linked_ball);
int sign(int v);

void GameOver();
void NewGame();

void Collision();
void CollisionBalls(Ball* a, Ball* b);
void Bounce();

int DisplayState();

// magic function o_0
static inline float fconstrain(float f, float max) {
    max -= SMIDGE;
    if (f > max) {
        return max;
    }
    if (f < SMIDGE) {
        return SMIDGE;
    }
    return f;
}

#endif	/* MAIN_H */

