/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef CONFIG_H
#define	CONFIG_H

/* Screen settings */
#define SCREEN_WIDTH  800
#define SCREEN_HEIGHT 480
#define SCREEN_BPP    16
#define BORDER_WIDTH  16

/* Physics settings */
// this constant used as value of acceleration for keyboard control of player's ball
#define THRUSTER_STRENGTH 1.5
#define G 9.8

// this coefficient used for collisions balls with border
#define BOUNCINESS 0.50

/* Amount of balls */
#define N_CRAZYBALLS 2
#define N_STARS 2
#define N_TAILBALLS 7

#define LIVES 2

/* Timers settings */
#define CRAZY_DELAY 20000
#define INTERVAL 1000
#define ACC_DELAY 40
#define LINK_DELAY 1500
#define WK_DELAY 2200

/* Balls settings */
// mass
#define B_MASS  40
#define CB_MASS 60
#define TB_MASS 5
#define STAR_MASS 40

// radius
#define B_RADIUS  24
#define CB_RADIUS 28
#define TB_RADIUS 16
#define STAR_RADIUS 24

#define NORMAL 1   // acceleration of crazy ball in normal mode
#define CRAZY  2.2 // and for crazy mode

/* Links (Ball-TailBalls) settings */
#define SPRING_MAX_LENGTH 120 // max length of rope
#define SPRING_REST_LENGTH 50 // at this length force equals zero

// a coefficient of damping
#define SPRING_DAMPING 0.7

// a Constant to represent the stiffness of the spring
#define SPRING_STRENGTH 0.05

#define ONE_BALL_COST 20      // score for single linked ball

// barrier for accelerometer shaking detection
// then value of acceleration bigger than it, shaking will be detected
#define SHAKING_BARRIER 8

#endif	/* CONFIG_H */
