/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef UI_H
#define	UI_H

#include <SDL.h>
#include <SDL_image.h>
#include <SDL_ttf.h>
#include <string.h>
#include <sstream>
#include "ScoreSystem.h"

#define R_BARRIER 495 // left border of "Scores" column
#define L_BARRIER 237 // left border of "Name" column
#define BEGIN 145	  // first lines coordinates(y)
#define DISTANCE 25   // distance between lines
#define MENU 0
#define NEW_GAME 1
#define HIGHSCORE 2
#define HELP 3
#define EXIT 4
#define FIRST 0
#define LAST 3

class Ui {
 public:
    Ui();
    ~Ui(){ };

    int help_var;
    int flag_m;
    bool flag;
    bool menu;

    ScoreSystem* score_system;

    std::string str;

    void Init(SDL_Surface *screen);            // Init Menu
    void Highscore(SDL_Surface *screen);       // Init Highscore
    void Help(SDL_Surface *screen);
    int HandleInput(SDL_Surface *screen, SDL_Event event);
    int HandleInputName(SDL_Surface *screen, SDL_Event event, int SCORE);
    void NewHighscore(SDL_Surface *screen, int SCORE);

 private:
    void PrintTTF(SDL_Surface* sDest, char* message, const char* font, int size, SDL_Color color, SDL_Rect dest);
    SDL_Surface* LoadImageAlpha(const char *file);
};

#endif	/* UI_H */
