/* Shariks
 *
 * Copyright (C) 2010 Dmitriev V.V.     <vdmitrie@cs.karelia.ru>
 * Copyright (C) 2010 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2010 Sotnikov A.A.     <sotnikov@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef TBLIST_H
#define TBLIST_H
#include "Ball.h"

// describes element of list
// Ball - TailBall object
// next - pointer to next element of list
struct element {
    Ball* ball;
    element *next;
};

class TBList
{
    public:
        element *p_head;  // pointer to head of list
        element *p_tail;  // pointer to tail of list
        int count_elem;   // amount of elements
        int count_linked; // amount of linked tail balls

        TBList();
        void AddToList(Ball *b);
        void DelFromList(element* prev, element *del);
        void DelList();
        void DelLinks();
        virtual ~TBList();
    protected:
    private:
};

#endif // TBLIST_H
