#!/bin/sh
# cd /usr/lib/hildon-desktop
# python2.5 /usr/lib/hildon-desktop/shaketowake2.py
#
# Widget to activate/deactivate shake to wake up/rest
# Enable/Disable wake on by shaking
# Realized by m750 at maemomeego.net
# Original source code for shaking code by Niklas Tanskanen
# Original source code for widget by Tom Waelti
# I optimized the shaking code especially to reduce CPU
# consuption and I have adapted the widget code to my needs


APP_TITLE = "stow2"
APP_VERSION = "2.2.3-x"

import gobject
import gtk
import hildondesktop
import hildon
import os
import cairo
import osso
import string
import time 
import dbus

APP_NAME = APP_TITLE.lower()
PERCORSO = '/home/user/shaketowake2/'
LOGO = PERCORSO + '%son.png' % APP_NAME



class stow2homedesktop(hildondesktop.HomePluginItem):

  global attivo
  attivo = 0
    
  def __init__(self):
    hildondesktop.HomePluginItem.__init__(self)
    self.set_settings(True)
    self.connect("show-settings", self.show_options)

    self.isStopped = True 
    self.update_info()
    self.transparency = 0.0

  

  def update_info(self, widget=None):

    #self.osso_context = osso.Context("com.tomch.bluezwitch", str(APP_VERSION), False)
    #self.osso_rpc = osso.Rpc(self.osso_context)
   
    self.hbox = gtk.HBox()
    self.vbox = gtk.VBox()
    self.e_eventbox = gtk.EventBox()
    self.e_eventbox.set_size_request(64, 72)           
    self.e_eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
    self.e_eventbox.connect("button-release-event", self.on_toggle)
    self.hbox.pack_start(self.e_eventbox, True, True, 10)
    self.hbox.show_all()
    self.add(self.hbox)
    
  def do_expose_event(self, event):
    cr = self.window.cairo_create()
    cr.set_source_rgba(1.0, 1.0, 1.0, self.transparency) # Transparent
    cr.set_operator(cairo.OPERATOR_SOURCE)
    cr.paint()   

    # Paint icon for eventbox
    self.draw_e("stow2off.png")

    # draw rounded rect
    width, height = self.allocation[2], self.allocation[3]
    
    x0 = 0
    y0 = 0
    radius = min(15, width/2, height/2)  #/*< and an approximate curvature radius */
    x1 = x0 + width
    y1 = y0 + height 
    
    cr.move_to  (x0, y0 + radius)
    cr.arc (x0 + radius, y0 + radius, radius, 3.14, 1.5 * 3.14)
    cr.line_to (x1 - radius, y0)
    cr.arc (x1 - radius, y0 + radius, radius, 1.5 * 3.14, 0.0)
    cr.line_to (x1 , y1 - radius)
    cr.arc (x1 - radius, y1 - radius, radius, 0.0, 0.5 * 3.14)
    cr.line_to (x0 + radius, y1)
    cr.arc (x0 + radius, y1 - radius, radius, 0.5 * 3.14, 3.14)
    cr.close_path ()

    cr.set_source_rgba (0.0, 0.0, 0.0, self.transparency)
    cr.fill_preserve ()
    return False

  def draw_e(self,icon):
    cr_e = self.e_eventbox.window.cairo_create()
    cr_e.set_source_rgba(0.0, 0.0, 0.0, self.transparency) # Transparent
    cr_e.set_operator(cairo.OPERATOR_SOURCE)
    cr_e.paint()
    
    cr_e.set_operator(cairo.OPERATOR_OVER)
    image = cairo.ImageSurface.create_from_png(PERCORSO + icon)
    cr_e.set_source_surface(image, 0, 7)
    cr_e.paint()
    self.cr_e = cr_e
    while gtk.events_pending():
      gtk.main_iteration()
          
  def do_realize(self):
    screen = self.get_screen()
    colormap = screen.get_rgba_colormap()
    self.set_colormap(colormap)
    hildondesktop.HomePluginItem.do_realize(self) 

  def get_rotation(self, widget=None):
	f=os.popen('cat /sys/class/i2c-adapter/i2c-3/3-001d/coord').read()
	coords = [int(w) for w in f.split()]
	return coords

  def get_proximity(self, widget=None):
	f = open("/sys/devices/platform/gpio-switch/proximity/state", 'r' )
	state = f.readline()
	state = state.rstrip()
	return state

  def attiva(self,widget=None):
     global attivo
     time.sleep(1)
     while attivo==1:

       # permette interazione con altri eventi
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)

	time.sleep(0.05)
	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)

	while gtk.events_pending():
		gtk.main_iteration(False)
	time.sleep(0.05)



	coor = self.get_rotation()

	#x = coor[0]
	y = coor[1]
	#z = coor[2]

	#print x, y, z
	if y<-1300 or y>1300 :
				state = self.get_proximity()
				if state == "open" :
					s_status = os.popen('dbus-send --system --type=method_call --dest="com.nokia.mce" --print-reply "/com/nokia/mce/request" com.nokia.mce.request.get_tklock_mode | awk \'/string/ {print $2}\'').read()
					s_status1 = s_status[1]
					if s_status1=="l":
						print "screen open"
						bus = dbus.SystemBus()
						tklock = bus.get_object('com.nokia.mce','/com/nokia/mce/request')
						tklock.req_tklock_mode_change(dbus.String("unlocked"))
						while gtk.events_pending():
							gtk.main_iteration(False)


						time.sleep(0.3)
					else:
						print "screen close"
						bus = dbus.SystemBus()
						tklock = bus.get_object('com.nokia.mce','/com/nokia/mce/request')
						tklock.req_tklock_mode_change(dbus.String("locked"))
						while gtk.events_pending():
							gtk.main_iteration(False)

						time.sleep(0.3)


				elif state == "closed" :
					#print "not going to open screen, i'm in a pocket :("
					time.sleep(3)
				


  def on_toggle(self, button, data=None):
    global attivo

    if attivo == 0:
       attivo = 1
       self.draw_e("stow2on.png")
       time.sleep(0.3) 
       banner = hildon.hildon_banner_show_information(self, '', "ShakeToWake2 ativated")
       banner.set_timeout(2000)
       time.sleep(0.2) 
       self.attiva()

    else:
       attivo = 0
       self.draw_e("stow2off.png")
       time.sleep(0.3)
       banner = hildon.hildon_banner_show_information(self, '', "ShakeToWake2 deativated")
       banner.set_timeout(2000)

    #print attivo


   

  
  #Setup the main options/settings dialogue (the one accessible through the tool icon when in Hildon Desktop Edit mode)
  def show_options(self, widget):
      dialog = gtk.Dialog("%s Options" % APP_TITLE, None, gtk.DIALOG_DESTROY_WITH_PARENT)

     
      
      about_button = hildon.Button(gtk.HILDON_SIZE_HALFSCREEN_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
      about_button.set_text("About", "Information")
      about_button.set_alignment(0,0,0,0)
      about_button.connect("clicked", self.show_about)

      line1 = gtk.HBox()
      line2 = gtk.HBox()        
      line2.pack_start(about_button, True, True, 0)
      dialog.vbox.pack_start(line1, True, True, 0)  
      dialog.vbox.pack_start(line2, True, True, 0)  
       
      dialog.show_all()
      dialog.run()
      dialog.destroy()
  
 
  
  #Show the about dialog    
  def show_about(self, widget):
      dialog = gtk.AboutDialog()


      dialog.set_title("About")
      dialog.set_name("ShakeToWake2")
      dialog.set_version(APP_VERSION)
      dialog.set_copyright("2011 by M750")
      dialog.set_logo(gtk.gdk.pixbuf_new_from_file(LOGO))
      dialog.set_comments("Enable/Disable wake on/off by shaking")
 
      dialog.set_authors(["Widget to activate/deactivate shake to wake up/rest","Realized by m750 at maemomeego.net","",
       "Initial source code for shaking by Niklas Tanskanen.",
       "Initial source code for widget by Tom Waelti.","",
	"I optimized the shaking code especially to reduce CPU",
       "consuption and I have adapted the widget code","to this needs."])

      dialog.set_license("This is free software")
      dialog.set_wrap_license(True)

      dialog.show_all()
      dialog.run()
      dialog.destroy() 
  
hd_plugin_type = stow2homedesktop

if __name__ == "__main__":
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()
