/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

/* Detection tables for (The Bizarre Adventures of) Woodruff and the Schnibble (of Azimuth). */

#ifndef GOB_DETECTION_TABLES_WOODRUFF_H
#define GOB_DETECTION_TABLES_WOODRUFF_H

// -- Windows CD --

{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		EN_GRB,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		FR_FRA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		IT_ITA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "dccf9d31cb720b34d75487408821b77e", 20296390),
		ES_ESP,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		EN_GRB,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		FR_FRA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		IT_ITA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "b50fee012a5abcd0ac2963e1b4b56bec", 20298108),
		ES_ESP,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "5f5f4e0a72c33391e67a47674b120cc6", 20296422),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		ES_ESP,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		EN_GRB,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		FR_FRA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by jvprat on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "270529d9b8cce770b1575908a3800b52", 20296452),
		IT_ITA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by Hkz on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "f4c344023b073782d2fddd9d8b515318", 7069736),
		IT_ITA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by Hkz on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "f4c344023b073782d2fddd9d8b515318", 7069736),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by Hkz on #scummvm
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "f4c344023b073782d2fddd9d8b515318", 7069736),
		FR_FRA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #1971294
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		EN_GRB,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #1971294
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		DE_DEU,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #1971294
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		FR_FRA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #1971294
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		IT_ITA,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by DjDiabolik in bug report #1971294
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "60348a87651f92e8492ee070556a96d8", 7069736),
		ES_ESP,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},
{ // Supplied by goodoldgeorg in bug report #2098838
	{
		"woodruff",
		"",
		AD_ENTRY1s("intro.stk", "08a96bf061af1fa4f75c6a7cc56b60a4", 20734979),
		PL_POL,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO2(GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480,
	0, 0, 0
},

// -- Demos --

{
	{
		"woodruff",
		"Non-Interactive Demo",
		{
			{"demo.scn", 0, "16bb85fc5f8e519147b60475dbf33962", 89},
			{"wooddem3.vmd", 0, "a1700596172c2d4e264760030c3a3d47", 8994250},
			{0, 0, 0, 0}
		},
		EN_ANY,
		kPlatformPC,
		ADGF_NO_FLAGS,
		GUIO3(GUIO_NOSUBTITLES, GUIO_NOSPEECH, GUIO_NOASPECT)
	},
	kGameTypeWoodruff,
	kFeatures640x480 | kFeaturesSCNDemo,
	0, 0, 1
},

#endif // GOB_DETECTION_TABLES_WOODRUFF_H
