# -*- coding: utf-8 -*-
"""
 @file: SysPT.py
  File is a part of Scribo Project
  Module implements group and friends test scenariouses
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 9.03.2010
"""


from ldm.Message import Message
from ldm.Profile import main_prof
from ldm.Account import Account
from services.LivejAccount import LivejAccount
from services.Dispatcher import dispatcher







__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysFT:
    """
    Class with test method for friends modules
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        service = dispatcher.get_services()[0]
        acc = Account.register(service, "scribo_rpc")
        acc.passwd = "test123"

        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)


    def get_friends_list(self):
        """
        test of getting list of friends
        """
        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking Get Friends List Scenario with LiveJournal: ')
        print '\nChecking Get Friends List Scenario with LiveJournal: '
        try:
            main_prof.def_account.refresh_friends_list()
            list1 = main_prof.def_account.get_option('friends')
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        out = open('./data/friends.txt', 'w')

        for mess in list1:
            #print mess
            out.write('\n%s\n' % (mess))

        out.close()
        f1_.close()


    def get_readers_list(self):
        """
        test of getting list of readers of our blog
        """

        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking Get Readers List Scenario with LiveJournal: ')
        print '\nChecking Get Readers List Scenario with LiveJournal: '
        try:
            main_prof.def_account.refresh_friends_list()
            list1 = main_prof.def_account.get_readers()
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        out = open('./data/readers.txt', 'w')

        for mess1 in list1:
            #print mess1
            out.write('\n%s\n' % (mess1))
        f1_.close()
        out.close()

    def add_my_friend(self):
        """
        adding a new fri(e)nd
        """

        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking Add Friend Scenario with LiveJournal: ')
        print '\nChecking Add Friend Scenario with LiveJournal: '

        service = dispatcher.get_services()[0]
        aco = Account.register(service, "maemoblogs")
        try:
            main_prof.def_account.add_friend(aco)
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        print "added\n"
        f1_.close()


    def kill_friend(self):
        """
        testing killing a friend
        """

        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking Delete Friend Scenario with LiveJournal: ')
        print '\nChecking Delete Friend Scenario with LiveJournal: '
        service = dispatcher.get_services()[0]
        aco = Account.register(service, "maemoblogs")
        try:
            main_prof.def_account.remove_friend(aco)
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        f1_.close()

    def refreshko(self):
        """
        trying to get friends posts
        """
        fp_ = []
        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking get friends posts Scenario with LiveJournal: ')
        print '\nChecking get friends posts Scenario with LiveJournal: '

        #try:
        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                acc.refresh_friends_page(self.callback)
            except:
                print "cant get " + acc.get_service_id() + "'s friend's posts"
        try:
            fp_ = main_prof.get_friends_posts(20)
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        f2_ = open('./data/friendsPostS', 'w')
        for mess in fp_:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()

            f2_.write('\n%s\n%s\n' % (title.encode("utf-8"),
                                      text.encode("utf-8")))
        f1_.close()
        f2_.close()


    def inbox(self):
        """
        testing experimental inbox
        """

        f1_ = open('./data/TestRes.txt', 'a+')
        f1_.write('\nChecking inbox Scenarios with LiveJournal:\n')
        print '\nChecking inbox Scenarios with LiveJournal:\n'

        msgg = Message()
        msgg.title = unicode("hallou")
        msgg.text = unicode("tyu ")

        service = dispatcher.get_services()[0]
        aco = Account.register(service, "maemoblogs")
        msgg.poster = aco

        f1_.write(' -add message to inbox ')
        print ' -add message to inbox ' + "hallou " + "tyu "
        try:
            main_prof.def_account.add_inbox(msgg)
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        f1_.write(' -add message to outbox ')
        print ' -add message to outbox '
        try:
            main_prof.def_account.add_outbox(msgg)
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"

        out = open('./data/inbox_data.txt', 'w')

        f1_.write(' -get message from inbox ')
        print ' -get message from inbox '
        try:
            inba = main_prof.def_account.get_inbox()
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"


        for mess in inba:
            print mess.title + '\n' + mess.text
            out.write('\n%s\n' % (mess.text))

        f1_.write(' -get message from outbox ')
        print ' -get message from outbox '


        try:
            inba = main_prof.def_account.get_outbox()
        except:
            f1_.write('ERROR\n')
            print "ERROR\n"
        else:
            f1_.write('OK\n')
            print "OK\n"
        for mess in inba:
            print mess.title + '\n' + mess.text
            out.write('\n%s\n' % (mess.text))

        out.close()

        f1_.close()

    def callback(self):
        """
        callback where it is needed
        """
        print "callback!"



A_ = SysFT()

#testing methods, that had been described above
#stress test quoted, unquote to run

#for i in range(1, 1000):
#    a.get_friends_list()
#    a.add_my_friend()
#    a.kill_friend()

A_.get_friends_list()
A_.get_readers_list()
A_.add_my_friend()
A_.kill_friend()
A_.refreshko()
A_.inbox()
print "!!!"
