#!/usr/bin/env python
"""
===============================================================
    Contains test module for Account, Message and Profile 
    in Local Data Manager (LDM)
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 3 $"
__date__ = "$Date: 2010/02/06 $"
__copyright__ = ""
__license__ = "GPLv2"


import unittest

import sys


#from Structure import *
from ldm.Profile import *
from test.FakeAccount import *
from ldm.Message import *
from ldm.SqlDriver import *
from ScriboExc import *

print "ldm test"
class LdmTest(unittest.TestCase):
    """
        Class LdmTest is test class for modules Account, Message and Profile. 
    """

    def test_create_structures(self):
        """
        Create structures in database
    
        @return None
        """

        acc1 = FakeAccount()
        acc2 = FakeAccount()
        real = FakeAccount()

        real.nick = "Maemo-Blogs"
        acc2.nick = "nick_2"
        acc1.nick = "nick_1"

        real.username = "maemoblogs"
        acc1.username = "username_1"
        acc2.username = "username_2"

        real.passwd = "maemo100500"

        real.city = "City17"
        acc1.city = "city 1"
        acc2.city = "city 2"

        real.date_of_birth = "9 sptember 1999"
        acc1.date_of_birth = "date_of_birth 1"
        acc2.date_of_birth = "date_of_birth 2"

        real.path_to_ava = "data/no_photo.jpg"
        acc1.path_to_ava = "data/no_photo.jpg"
        acc2.path_to_ava = "data/no_photo.jpg"

        m1 = Message()
        m2 = Message()
        m3 = Message()
        m4 = Message()
        m5 = Message()
        m6 = Message()
        m7 = Message()
        m8 = Message()
        m9 = Message()
        m10 = Message()
        m11 = Message()
        m12 = Message()

        m1.title = "title_1"
        m2.title = "title_2"
        m3.title = "title_3"
        m4.title = "title_4"
        m5.title = "title_5"
        m6.title = "title_6"
        m7.title = "title_7"
        m8.title = "title_8"
        m9.title = "title_9"
        m10.title = "title_10"
        m11.title = "title_11"
        m12.title = "title_12"

        m1.text = "text_1"
        m2.text = "text_2"
        m3.text = "text_3"
        m4.text = "text_4"
        m5.text = "text_5"
        m6.text = "text_6"
        m7.text = "text_7"
        m8.text = "text_8"
        m9.text = "text_9"
        m10.text = "text_10"
        m11.text = "text_11"
        m12.text = "text_12"

        m1.date = "0000-00-00 00:01"
        m2.date = "0000-00-00 00:02"
        m3.date = "0000-00-00 00:03"
        m4.date = "0000-00-00 00:04"
        m5.date = "0000-00-00 00:05"
        m6.date = "0000-00-00 00:06"
        m7.date = "0000-00-00 00:07"
        m8.date = "0000-00-00 00:08"
        m9.date = "0000-00-00 00:09"
        m10.date = "0000-00-00 00:10"
        m11.date = "0000-00-00 00:11"
        m12.date = "0000-00-00 00:12"

        acc1.add_post(m1)
        acc1.add_post(m2)
        acc1.add_post(m3)
        acc2.add_post(m7)
        acc2.add_post(m8)
        acc2.add_post(m9)

        m2.add_comment(m4)
        m2.add_comment(m6)
        m4.add_comment(m5, m2)

        m8.add_comment(m10)
        m8.add_comment(m11)
        m8.add_comment(m12, m8)

        self.assertRaises(WarningExc, real.set_default)


if __name__ == '__main__':
    unittest.main()

