#!/usr/bin/env python
#@file: build.py
#This script install Scribo project 
#@author: Alexander Sannikov <sannikov@cs.karelia.ru>
#@date: 5.12.2009

import glob
from distutils.core import setup

from src.About import __version__ as v
version = v

build = "822"

sh = ['scribo']
desktop_file = ['scribo.desktop']
pixmaps = glob.glob('data/*.png')+ glob.glob('data/*.ico')
pixmapen = glob.glob('data/en/*.png')
srcs = glob.glob('src/*.py')+glob.glob('src/*.qm')+glob.glob('src/*.ts')  
uisrcs =  glob.glob('src/ui/*.py') 
bugsrcs =  glob.glob('src/bugz/*.py') 
ldmsrcs = glob.glob('src/ldm/*.py') 
servsrcs = glob.glob('src/services/*.py')
inst_dbus = ['scribo.service']
inst_icon = ['data/Scribo.png']
inst_icon_sca = ['data/Scribo.png']
run_file = ['scribo']

cf = (
            "Development Status :: 5 - Production/Stable",
            "Environment :: X11 Applications :: Qt",
            "Intended Audience :: End Users/Desktop",
            "License :: OSI Approved :: GNU General Public License (GPL)",
            "Natural Language :: English",
            "Operating System :: POSIX :: Other:",
            "Programming Language :: Python :: 2",
            "Topic :: Internet :: WWW/HTTP",
            )
docs_files = ["README", "copying", "NEWS", "TODO", "INSTALL",]

data_files = [
  ('/usr/share/applications/hildon', desktop_file),
  ('/usr/share/icons/hicolor/scalable/hildon',['data/icons/64x64/scribo.png']),
  ('/usr/share/icons/hicolor/26x26/hildon',['data/icons/26x26/scribo.png']),
  ('/usr/share/icons/hicolor/40x40/hildon',['data/icons/40x40/scribo.png']),
  ('/usr/share/icons/hicolor/64x64/hildon',['data/icons/64x64/scribo.png']),
  ('/usr/share/icons/hicolor/26x26/apps',['data/icons/26x26/scribo.png']),
  ('/usr/share/icons/hicolor/40x40/apps',['data/icons/40x40/scribo.png']),
  ('/usr/share/icons/hicolor/64x64/apps',['data/icons/64x64/scribo.png']),
  ('/usr/share/pixmap',['data/icons/pixmap/scribo.xpm']),
  ('/opt/scribo/src', srcs),
  ('/opt/scribo/src/ui', uisrcs),
  ('/opt/scribo/src/bug', bugsrcs),
  ('/opt/scribo/src/ldm', ldmsrcs),
  ('/opt/scribo/src/services', servsrcs),
  ('/opt/scribo/data', pixmaps),
  ('/opt/scribo/data/en', pixmapen),
  ('/usr/share/dbus-1/services', inst_dbus),
  ('/usr/share/icons/hicolor/26x26/hildon/', inst_icon),
  ('/usr/share/icons/hicolor/scalable/hildon/', inst_icon_sca),
  ('/usr/bin/', ['scribo',]),
  ('/usr/share/docs/scribo/', docs_files),
]


setup(
  name='scribo',
  version=version,
  description='Blogging client for Maemo',
  long_description="""
Cross-Blog Client.
This version is alpha; it is oriented to developers, not regular users.
You can help the Scribo project if you try our application.
Please send your comments to maemo-scribo@cs.karelia.ru
and bugs to http://oss.fruct.org/bugzilla/.
Note that the Scribo local cache can be changed in further releases.
You MUST remove all application data from ~/.scribo before installing,
e.g. with "rm -rf ~/.scribo".
Thank you
""",
  author="Zaiceva Dyana, Mezhenyn Artyom, Sannikov Alexander, Germanov Kyrill",
  author_email='<maemo-scribo@cs.karelia.ru>',
  url='http://oss.fruct.org/',
  license='GPL v2',
  platforms='Maemo',
  data_files=data_files,
  classifiers=cf,
)
