#!/usr/bin/env python
"""
 @file: ListMyPosts.py
  File is a part of Scribo Project
  Module implements viewing list of post from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""


from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ldm.Profile import main_prof
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"

class ListMyPosts(QtGui.QWidget):
    """
    class for draw list of posts window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent):
        """ 
        initialization "list of posts" window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.create_actions()
        toolbar = self.create_toolbar()
        self.hbox = QtGui.QHBoxLayout()
        self.mes_list = self.list_posts()
        self.hbox.addWidget(toolbar)
        self.hbox.addSpacing(10)
        self.hbox.addWidget(self.mes_list)
        self.setLayout(self.hbox)


    def list_posts(self):
        """
        fill list of posts
        @param
        @return
        """
        list_widget = QtGui.QListWidget(self)
        self.list = self.get_messages()
        #upic = QtGui.QImage("../data/faviconLJ.ico")
        index = 0

        if len(self.list) == 0:
            from ConfigDriver import config
            c = config.get_bool('UI', 'warning_press_refresh')
            if not c:
                msg = QtGui.QMessageBox()
                msg.setWindowTitle(self.tr("Refresh message"))
                show_button = QtGui.QCheckBox(self.tr("Don't show this message again"), msg)
                title_label = QtGui.QLabel(self.tr("Press \"Refresh\" to update post"), msg)
                msg.layout().addWidget(title_label, 0, 0)
                msg.layout().addWidget(show_button, 1, 0)
                cancel_button = msg.addButton(QtGui.QMessageBox.Close)
                msg.exec_()

                if msg.clickedButton() == cancel_button:
                    if show_button.isChecked():
                        config.set('UI', 'warning_press_refresh', True)


        for mes in self.list:
            date = mes.date
            import time
            datetime = time.strptime(date, "%Y-%m-%d %H:%M:%S")
            date = time.strftime("%a, %d %b %Y %H:%M", datetime)
            if not mes.title:
                title = unicode(self.tr("no subject"))
            else:
                title = unicode(mes.title)
            text = date.decode('utf8') + "  " + title

            #if not mes.read:
                #text =text + "  <font color=\"green\">  NEW!!! </font>"
            author = mes.poster
            if author:
                icon = author.get_icon()
                if not icon:
                    icon = ""
            else:
                icon = ""
            new_item = QtGui.QListWidgetItem(QtGui.QIcon(QtCore.QString(icon)),
                                             text,
                                             list_widget)
            new_item.setData(1, QtCore.QVariant(index))
            index = index + 1
            del text
            del title
            del date
        self.connect(list_widget, QtCore.SIGNAL("itemDoubleClicked(QListWidgetItem*)"),
                     self.view_message)
        return list_widget

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=main_window.centralWidget())
        file_tool_bar.addAction(self.refresh_act)
        file_tool_bar.addAction(self.del_act)
        return file_tool_bar


    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        self.refresh_act = QtGui.QAction(self)
        self.refresh_act.setText(self.tr("Refresh"))
        self.refresh_act.setIcon(QtGui.QIcon(self.tr("../data/en/refresh.png")))
        self.connect(self.refresh_act, QtCore.SIGNAL("triggered()"),
                     self.reload_window)

        self.del_act = QtGui.QAction(self)
        self.del_act.setText(self.tr("Delete"))
        self.del_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_delete.png")))
        self.connect(self.del_act, QtCore.SIGNAL("triggered()"),
                     self.delete_message)


    def view_message(self, item):
        """        
        view choosing post
        @param
        @return       
        """
        index = item.data(1).toString().toInt()[0]
        mes = self.list[index]
        view_widg = ViewMessage(main_window, self.get_messages(), mes)
        main_window.push_window(view_widg)

    def delete_message(self):
        """        
        delete choosing post
        @param
        @return       
        """
        ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Do you really want to delete post?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
            return
        list = self.mes_list.selectedItems()
        if list:
            for item in list:
                index = item.data(1).toString().toInt()[0]
                mes = self.list[index]
                try:
                    mes.poster.del_post(mes)
                except WarningExc, exc:
                    main_window.show_warning(exc)
                else:
                    self.mes_list.removeItemWidget(item)
                    item.setHidden(True)
                    item.setSelected(False)

        else:
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, choose messages to delete!"),
                               QtGui.QMessageBox.Yes)




    def reload_window(self):
        """
        refresh list of posts 
        @param          
        @return
        """
        self.progress = QtGui.QProgressDialog(self.tr("Operation is in progress."),
                                              self.tr("Cancel"), 0, 100, self)
        self.progress.setWindowTitle(self.tr("Receiving data..."))
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.value_progress = 1
        self.progress.setValue(self.value_progress)

        self.progress.forceShow()

        self.refresh_messages()
            #acc.get_posts(self.callback)
        self.progress.setValue(self.progress.maximum())
        self.hbox.removeWidget(self.mes_list)
        self.mes_list.deleteLater()
        self.mes_list = self.list_posts()
        self.hbox.addWidget(self.mes_list)

    def callback(self):
        #20 = BASE
        self.progress.setValue(100 * (self.value_progress / (self.value_progress + 20)))
        self.value_progress = self.value_progress + 1
        print "!!!"


    def refresh_messages(self):

        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                acc.refresh_posts(self.callback)
            except WarningExc, exc:
                main_window.show_warning(exc)


    def get_messages(self):
        return main_prof.get_posts()


from ViewMessage import *

