#!/usr/bin/env python

"""
===============================================================
Base class for windows in Scribo
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 20 $"
__date__ = "$Date: 2010/02/07 $"
__copyright__ = ""
__license__ = "GPLv2"

from PyQt4 import QtGui
from PyQt4 import QtCore

from MainWindow import main_window

class ToolbarWindow(QtGui.QWidget):

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        self.back_act = QtGui.QAction(self)
        #self.back_act.setStatusTip(self.tr("On previous page"))
        self.back_act.setIcon(QtGui.QIcon(main_window.tr('../data/en/back.png')))
        self.connect(self.back_act, QtCore.SIGNAL("triggered()"),
                     main_window.back_window)

        self.home_act = QtGui.QAction(self)
        #self.home_act.setStatusTip(self.tr("Home page"))
        self.home_act.setIcon(QtGui.QIcon(main_window.tr('../data/en/home.png')))
        self.connect(self.home_act, QtCore.SIGNAL("triggered()"),
                     main_window.home_window)

    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        #file_tool_bar = QtGui.QToolBar("", self)
        centr_widg = main_window.centralWidget()
        file_tool_bar = QtGui.QToolBar(centr_widg)
        file_tool_bar.setOrientation(QtCore.Qt.Vertical)
        file_tool_bar.setAllowedAreas(QtCore.Qt.LeftToolBarArea)
        file_tool_bar.setMovable(True)
        file_tool_bar.setIconSize(QtCore.QSize(64, 64))
        file_tool_bar.addAction(self.back_act)
        file_tool_bar.addAction(self.home_act)
        return file_tool_bar

    def create_toolbar_second(self):
        """
        create profile for "add profile" window
        @return
        """
        second_tool_bar = QtGui.QToolBar("", self)
        second_tool_bar.setOrientation(QtCore.Qt.Vertical)
        second_tool_bar.setAllowedAreas(QtCore.Qt.RightToolBarArea)
        second_tool_bar.setIconSize(QtCore.QSize(64, 64))
        second_tool_bar.setMovable(True)
        return second_tool_bar
