#!/usr/bin/env python
"""
 @file: AddPost.py
  File is a part of Scribo Project
  Module implements add post window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""


from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow
from ldm.Profile import *
from ldm.Account import *
from services.LivejAccount import *

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"

class AddPostWindow(ToolbarWindow):
    """
    class for draw add post window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  duplication
    """
    def __init__(self, parent=None, msg=None):
        """ 
        initialization "add post" window
        @return
        """

        self.tags = None
        self.msg = msg
        self.is_change = False
        self.start_text = ""
        QtGui.QWidget.__init__(self, parent.centralWidget())

        self.vbox_add = QtGui.QVBoxLayout()
        self.hbox_all = QtGui.QHBoxLayout()

        self.create_actions()
        first_toolbar = self.create_toolbar()
        second_toolbar = self.create_toolbar_second()

        title_label = QtGui.QLabel(self.tr("Subject"), self)
        title_label.setAlignment(QtCore.Qt.AlignLeft)
        
        self.text_edit = QtGui.QTextEdit(self)
        self.title_edit = QtGui.QLineEdit(self)
        self.title_edit.setMaxLength(100)
        if msg:
            self.text_edit.insertPlainText(msg.text)
            self.start_text = msg.text
            title = msg.title
            if not msg.title:
                title = ""
            self.title_edit.setText(title)
        self.title_edit.setFocus()

        self.hbox_all.addWidget(first_toolbar)
        self.hbox_all.addSpacing(5)
        self.vbox_add.addWidget(title_label)
        self.vbox_add.addWidget(self.title_edit)
        self.vbox_add.addWidget(self.text_edit)

        self.hbox_all.addLayout(self.vbox_add)
        self.hbox_all.addSpacing(5)
        self.hbox_all.addWidget(second_toolbar)
        self.setLayout(self.hbox_all)


    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = super(AddPostWindow, self).create_toolbar()
        file_tool_bar.addAction(self.send_act)
        return file_tool_bar

    def create_toolbar_second(self):
        """
        create profile for "add profile" window
        @return
        """
        second_tool_bar = super(AddPostWindow, self).create_toolbar_second()
        second_tool_bar.addAction(self.pict_act)
        second_tool_bar.addAction(self.link_act)
        second_tool_bar.addAction(self.other_act)
        second_tool_bar.addAction(self.option_act)
        return second_tool_bar

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """

        self.pict_act = QtGui.QAction(self)
        self.pict_act.setIcon(QtGui.QIcon(self.tr("../data/en/image.png")))
        #self.pict_act.setIconText(self.tr("Add image"))
        self.connect(self.pict_act, QtCore.SIGNAL("triggered()"),
                     self.pict_post)

        self.link_act = QtGui.QAction(self)
        #self.link_act.setStatusTip(self.tr("Add link"))
        self.link_act.setIcon(QtGui.QIcon(self.tr("../data/en/add_link.png")))
        self.connect(self.link_act, QtCore.SIGNAL("triggered()"),
                     self.link_post)

        self.other_act = QtGui.QAction(self)
        #self.other_act.setStatusTip(self.tr("Other HTML tags"))
        self.other_act.setIcon(QtGui.QIcon(self.tr("../data/en/add_html.png")))
        self.connect(self.other_act, QtCore.SIGNAL("triggered()"),
                     self.other_post)

        self.option_act = QtGui.QAction(self)
        #self.option_act.setStatusTip(self.tr("Adding option"))
        self.option_act.setIcon(QtGui.QIcon(self.tr("../data/en/options.png")))
        self.connect(self.option_act, QtCore.SIGNAL("triggered()"),
                     self.option_post)


        self.send_act = QtGui.QAction(self)
        #self.send_act.setStatusTip(self.tr("Send post"))
        
        if not self.msg:
            self.send_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_send_to.png")))
            self.connect(self.send_act, QtCore.SIGNAL("triggered()"),
                         self.send_post)
        else:
            self.send_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_send.png")))
            self.connect(self.send_act, QtCore.SIGNAL("triggered()"),
                         self.edit_post)

        super(AddPostWindow, self).create_actions()
        self.disconnect(self.back_act, QtCore.SIGNAL("triggered()"),
                     main_window.back_window)
        self.connect(self.back_act, QtCore.SIGNAL("triggered()"),
                     self.back_window)
        self.disconnect(self.home_act, QtCore.SIGNAL("triggered()"),
                     main_window.home_window)
        self.connect(self.home_act, QtCore.SIGNAL("triggered()"),
                     self.home_window)

    def send_post(self):
        """ 
        handler for button OK
        @return
        """
        text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()
        if (text_post == ""):
            ret = QtGui.QMessageBox.critical(self, self.tr("Scribo"),
                               self.tr("The post is empty!"),
                               QtGui.QMessageBox.Ok)
            return

        if (self.title_edit.text() == ""):
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Do you want to send post"\
                                       " with empty subject?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return

        mes = Message()
        mes.title = unicode(self.title_edit.text())
        mes.text = unicode(text_post)
        if self.tags:
            mes.tags = unicode(self.tags)

        from ui.RepeatPost import RepeatPost
        rep_post = RepeatPost(main_window, mes)
        main_window.push_window(rep_post)


    def edit_post(self):
        """ 
        handler for button OK
        @return
        """
        text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()
        if text_post == "":
            ret = QtGui.QMessageBox.critical(self, self.tr("Scribo"),
                               self.tr("The post is empty!"),
                               QtGui.QMessageBox.Ok)
            return

        if (self.title_edit.text() == ""):
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Do you want to send post"\
                                       " with empty subject?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return

        mes = self.msg.copy()
        mes.title = unicode(self.title_edit.text())
        mes_text = unicode(text_post)
        if self.tags:
            mes.tags = unicode(self.tags)
        #else:
        #    mes.tags = self.msg.tags
        author = self.msg.poster
        try:
            res = author.edit_post(mes)
        except WarningExc, exc:
            main_window.show_warning(exc)
        else:
            ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Post is edit"),
                                                QtGui.QMessageBox.Yes)
        mes.del_msg_tree()
        main_window.home_window()


    def pict_post(self):
        """
        insert picture in the post
        @param 
        @return
        """


        msg = QtGui.QMessageBox()
        uri_edit = QtGui.QLineEdit(msg)
        msg.setWindowTitle(self.tr("Add picture"))
        title_label = QtGui.QLabel(self.tr("Link to the image (URL)"), msg)
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(uri_edit, 1, 0)
        link_button = msg.addButton(self.tr("Add"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()
        if msg.clickedButton() == cancel_button:
            return

        if msg.clickedButton() == link_button:
            link = uri_edit.text()
            if QtCore.QString(link).contains("http://", QtCore.Qt.CaseInsensitive):
                self.text_edit.insertPlainText("<img src=\"" + link + "\"/>")
            else:
                self.text_edit.insertPlainText("<img src=\"http://" + link + "\"/>")


    def link_post(self):
        """
        insert link in the post
        @param
        @return 
        """


        msg = QtGui.QMessageBox()
        msg.setWindowTitle(self.tr("Add link"))
        uri_edit = QtGui.QLineEdit(msg)
        uri_edit.setFocus()

        title_label = QtGui.QLabel(self.tr("Link"), msg)
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(uri_edit, 1, 0)

        link_button = msg.addButton(self.tr("Add"),
                                     QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()

        if msg.clickedButton() == cancel_button:
            return
        if msg.clickedButton() == link_button:
            link = uri_edit.text()
            if QtCore.QString(link).contains("http://", QtCore.Qt.CaseInsensitive):
                self.text_edit.insertPlainText("<a href=\"" + link + "\"></a>")
            else:
                self.text_edit.insertPlainText("<a href=\"http://" + link + "\"></a>")

    def other_post(self):
        '''
        marked text insert between tags
        '''
        #start = self.text_edit.selectionStart()
        #if start <> -1:
            #text = self.text_edit.selectedText()
        self.dial = QtGui.QMessageBox()

        but_box = QtGui.QDialogButtonBox()
        but_box2 = QtGui.QDialogButtonBox()

        but_box.setOrientation(QtCore.Qt.Horizontal)
        but_box2.setOrientation(QtCore.Qt.Horizontal)

        self.dial.setWindowTitle(self.tr("Add html tags"))
        self.dial.setOrientation(QtCore.Qt.Horizontal)

        self.bold_button = but_box.addButton(self.tr("Bold"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.italic_button = but_box.addButton(self.tr("Italic"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.center_button = but_box2.addButton(self.tr("Center"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.right_button = but_box2.addButton(self.tr("Right"),
                                      QtGui.QDialogButtonBox.ActionRole)
        self.left_button = but_box2.addButton(self.tr("Left"),
                                    QtGui.QDialogButtonBox.ActionRole)
        self.just_button = but_box.addButton(self.tr("Justify"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.color_button = but_box.addButton(self.tr("Color"),
                                      QtGui.QDialogButtonBox.ActionRole)
        cancel_button = self.dial.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        but_box.adjustSize()
        but_box2.adjustSize()

        self.dial.layout().addWidget(but_box, 0, 0, 1, 3, QtCore.Qt.AlignCenter)
        self.dial.layout().addWidget(but_box2, 1, 0, 1, 3, QtCore.Qt.AlignCenter)

        self.connect(but_box, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.html_click)
        self.connect(but_box2, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.html_click)

        self.dial.exec_()
        if self.dial.clickedButton() == QtGui.QMessageBox.Abort:
            pass
        else:
            return
    
    def html_click(self, button):
        text = ""

        if button == self.bold_button:
            self.text_edit.insertPlainText("<b>" + text + "</b>")
        elif button == self.italic_button:
            self.text_edit.insertPlainText("<i>" + text + "</i>")
        elif button == self.center_button:
            self.text_edit.insertPlainText("<div style=\"text-align:center\">"
                                      + text + "</div>")
        elif button == self.right_button:
            self.text_edit.insertPlainText("<div style=\"text-align:right\">"
                                      + text + "</div>")
        elif button == self.left_button:
            self.text_edit.insertPlainText("<div style=\"text-align:left\">"
                                      + text + "</div>")
        elif button == self.just_button:
            self.text_edit.insertPlainText("<div style=\"text-align:justify\">"
                                      + text + "</div>")
        elif button == self.color_button:
            color_edit = QtGui.QLineEdit()

            msg2 = QtGui.QMessageBox()
            title = QtGui.QLabel(self.tr("Color text"), msg2)
            msg2.layout().addWidget(title, 0, 0)
            msg2.layout().addWidget(color_edit, 1, 0)
            color_dial_but = msg2.addButton(self.tr("Choose color"),
                                            QtGui.QMessageBox.RejectRole)
            msg2.exec_()

            if msg2.clickedButton() == color_dial_but:
                link = color_edit.text()
                col = QtGui.QColorDialog.getColor()
                if col.isValid():
                    red = QtCore.QString().number(col.red(), 16).toUpper()
                    green = QtCore.QString().number(col.green(), 16).toUpper()
                    blue = QtCore.QString().number(col.blue(), 16).toUpper()
                    color = red + green + blue
                    self.text_edit.insertPlainText("<font color=\"#"
                                               + color + "\">"
                                               + link + "</font>")
        else:
    	    return
        self.dial.reject()


    def option_post(self):
        """
        add tags in the post
        @param 
        @return
        """

        msg = QtGui.QMessageBox()
        msg.setWindowTitle(self.tr("Add option"))
        tag_edit = QtGui.QTextEdit(msg)
        tags = None
        if self.msg:
            tags = self.msg.tags
        elif self.tags:
            tags = self.tags
        if not tags:
            tags = ""
        tag_edit.setText(tags)
        title_label = QtGui.QLabel(self.tr("Tags (comma separated)"))
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(tag_edit, 1, 0)
        link_button = msg.addButton(self.tr("Add"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()
        if msg.clickedButton() == cancel_button:
            return
        if msg.clickedButton() == link_button:
	        self.tags = tag_edit.toPlainText()
            #self.text_edit.deselect()

    def text_changed(self):
        """
        catch changes text edit and title
        """
        text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()
        res = QtGui.QMessageBox.No
        if self.title_edit.isModified() or self.start_text != text_post:
            res = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Post will be lost! "\
                                   "Continue? "),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        else:
            res = QtGui.QMessageBox.Yes
        return res

    def back_window(self):
        """
        check post on changing event
        """
        ret = self.text_changed()
        if (ret == QtGui.QMessageBox.No):
                return
        main_window.back_window()

    def home_window(self):
        """
        check post on changing event
        """
        ret = self.text_changed()
        if (ret == QtGui.QMessageBox.No):
                return
        main_window.back_window()
