#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
 @file: SysTest.py
  File is a part of Scribo Project
  Module implements add post from file
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 14.02.2010
"""

import sys
"""
sys.path.append("..")
sys.path.append("../ldm")
sys.path.append("../ui")
sys.path.append("../services")
"""
from ldm.Message import Message
from ldm.Profile import *
from ldm.Account import *
from services.LivejAccount import *
from services.BlurtyAccount import *
from time import *
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysBugs:
    """
    Class with test method for SendPost module
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        acc = LivejAccount()
        acc.username = "scribo_rpc"
        acc.passwd = "test123"

        try:
            main_prof.add_account(acc)
        except:
            acc = Account.find(type(acc), acc.username)
        try:
            main_prof.set_def_account(acc)
        except:
            print "no such acc"


    def bug107(self):
        """
        duble of added acounts 
        """

        acc = LivejAccount()
        acc.username = "maemoblogs"
        acc.passwd = "maemo100500"

        try:
            main_prof.add_account(acc)
        except:
            print "already added"

        print "\nbug 107: "

        try:
            main_prof.add_account(acc)
        except:
            print "fixed"
        else:
            print "ERROR!"

    def bug92(self):
        """
        adding post with non-unicode coding
        """
        mes = Message()
        mes.title = unicode("header")
        mes.text = unicode("Hello, moony")
        mes.tags = "magic tag"

        print "\nbug 92: "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print "ERROR!!!1"
        else:
            print "fixed"

    def bug87(self):
        """
        test of getting posts without title
        """
        mes = Message()
        mes.title = ""
        mes.text = unicode("Hello, moonSpIRiT")
        main_prof.def_account.add_post(mes)
        res = main_prof.def_account.send_post(mes)


        print "\nbug 87: "
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def bug78(self):
        """
        BD fail after second posts refresh
        """
        print "\nbug 78: "
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def bug152(self):
        """
        BD fail after second posts refresh
        """
        acc = BlurtyAccount()
        acc.username = "sscribo"
        acc.passwd = "test123"
        try:
            main_prof.add_account(acc)
        except:
            acc = Account.find(type(acc), acc.username)

        mes = Message()
        mes.title = "test bug 152"
        mes.text = "<br>"


        main_prof.set_def_account(acc)
        print "\nbug 152: "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print 'ERROR'
        else:
            print 'fixed'

        acca = LivejAccount()
        acca.username = "scribo_rpc"
        same_acc = Account.find(type(acca), acca.username)

        main_prof.set_def_account(same_acc)


    def bug214(self):
        """
        too long title of the post
        """
        mes = Message()
        mes.title = "test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 test bug 214 "
        mes.text = "<br>"

        print "\nbug 214 post(<br>): "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def bug117(self):
        """
        test of getting posts without title
        added check from UI
        """
        mes = Message()
        mes.title = "trolollo"
        mes.text = ""

        print "\nbug 117 post(empty): "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            if (mes.text == ""):
                print 'fixed'
            else:
                print 'ERROR'
        else:
            print 'fixed'

        mes.title = "trolollo"
        mes.text = "<br>"

        print "\nbug 117 post(<br>): "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print 'ERROR'
        else:
            print 'fixed'

        mes.title = "trolollo"
        mes.text = "            "

        print "\nbug 117 post("               "): "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print 'ERROR'
        else:
            print 'fixed'

        print "\ngetting those posts"
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def callback(self):
        """
        just a callback
        """
        print "call me!"


a = SysBugs()
a.bug107()
a.bug92()
a.bug87()
a.bug117()
a.bug214()
a.bug152()

print "Loppu!"






