# -*- coding: utf-8 -*-
"""
 @file: BDTest.py
  File is a part of Scribo Project
  Module implements group and friends test scenariouses
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 9.03.2010
"""

import sys
"""
sys.path.append("..")
sys.path.append("../ldm")
sys.path.append("../ui")
sys.path.append("../services")
"""
from ldm.Message import Message
from ldm.Profile import *
from ldm.Account import *
from services.LivejAccount import *
from time import *
from ldm.SqlDriver import *
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class BDTest:
    """
    Class with test method for DB testing
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        acc = LivejAccount()
        acc.username = "scribo_rpc"
        acc.passwd = "test123"
        try:
            main_prof.add_account(acc)
        except:
            print "already have"
            acc = Account.find(type(acc), acc.username)
        main_prof.set_def_account(acc)
        f = open('./test/data/DBTest_info.txt', 'w')
        f.close()


    def GetBD_def_acc(self):
        """
        test if account become default after init
        """
        f1 = open('./test/data/TestRes.txt', 'a')
        f1.write('\nChecking Set defoult account scenario ')
        print '\nChecking Set defoult account scenario '

        f = open('./test/data/DBTest_info.txt', 'a')
        cmd = "SELECT def_account FROM Profiles;"
        args = sql_driver.select_mcmd(cmd)
        f.write("default account = %s\n\n" % (args))
        f.close()
        print "\ndef_acc = "
        print args
        if(args[0] == 0):
            f1.write('ERROR\n')
            print 'ERROR\n'
        else:
            f1.write('OK\n')
            print 'OK\n'
        f1.close()


    def GetBD_acc(self):
        """
        get acc from db
        @return
        """

        f1 = open('./test/data/TestRes.txt', 'a')
        f1.write('\nChecking Delete account from DB: ')
        print '\nChecking Delete account from DB: '

        f = open('./test/data/DBTest_info.txt', 'a')
        cmd = "SELECT username FROM Accounts;"
        args = sql_driver.select_mcmd(cmd)
        f.write("accounts = %s\n\n" % (args))
        print "\nacc-s = "
        print args

        main_prof.def_account.del_account()

        args1 = sql_driver.select_mcmd(cmd)
        f.write("acc-s after delete = %s\n\n" % (args1))
        f.close()
        print "\nacc-s after delete= "
        print args1
        if(len(args) <= len(args1)):
            f1.write('ERROR\n')
            print "ERROR\n"
        else:
            f1.write('OK\n')
            print "OK\n"
        f1.close()



    def GetBD_posts(self):
        """
        test if post added to db
        """

        f2 = open('./test/data/TestRes.txt', 'a')
        f2.write('\nChecking Add post to DB: ')
        print '\nChecking Add post to DB: '
        f1 = open('./test/data/DBTest_info.txt', 'a')
        cmd = "SELECT date FROM Messages;"
        args = sql_driver.select_mcmd(cmd)
        f1.write("dates of all posts = %s\n\n" % (args))
        print "\ndates of all posts = "
        print args

        f = open('./test/data/bigPOST', 'r')

        all_lines = f.readlines()

        tm = localtime(time())
        date = "%s-%s-%s %s:%s" % (tm.tm_year,
            tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min)


        header = all_lines[0]
        body = all_lines[1]
        f.close()
        f = open('./test/data/bigPOST', 'r')

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.title += unicode(" - ", errors='replace') + unicode(body, errors='replace')
        mesa.date = date

        all_lines = f.read()
        mesa.text = unicode(all_lines, errors='replace')
        f.close()
        main_prof.def_account.add_post(mesa)
        res = main_prof.def_account.send_post(mesa)

        args1 = sql_driver.select_mcmd(cmd)
        f1.write("dates of all posts after adding a post = %s\n\n" % (args))
        print "\ndates of all posts after adding a post = "
        f1.close()
        print args1
        if(len(args) >= len(args1)):
            f2.write('ERROR\n')
            print 'ERROR\n'
        else:
            f2.write('OK\n')
            print 'OK\n'
        f2.close()


    def GetBD_accs(self):
        """
        addin' different acounts
        """
        f2 = open('./test/data/TestRes.txt', 'a')
        f2.write('\nChecking Add Accounts to DB: ')
        print '\nChecking Add Accounts to DB: '
        f = open('./test/data/DBTest_info.txt', 'a')
        acc = LivejAccount()
        acc.username = "scribo_rpc"
        acc.passwd = "test123"

        cmd = "SELECT username, passwd FROM Accounts;"
        args = sql_driver.select_mcmd(cmd)
        try:
            main_prof.add_account(acc)
        except:
            print "already have"

        ac = LivejAccount()
        ac.username = "maemoblogs"
        try:
            main_prof.add_account(ac)
        except:
            print "already have"

        acc1 = LivejAccount()
        acc1.passwd = "maemo100500"
        try:
            main_prof.add_account(acc1)
        except:
            print "already have"


        acc2 = LivejAccount()
        acc2.friends = ["maemo100500"]
        try:
            main_prof.add_account(acc2)
        except:
            print "already have"

        acc3 = LivejAccount()
        try:
            main_prof.add_account(acc3)
        except:
            print "already have"
        main_prof.set_def_account(acc3)

        cmd = "SELECT username, passwd FROM Accounts;"
        args1 = sql_driver.select_mcmd(cmd)
        f.write("acc-s after adding new ones = %s\n\n" % (args1))
        f.close()
        print "\nacc-s after adding new ones= "
        print args1

        if(len(args) >= len(args1)):
            f2.write('ERROR\n')
            print "error\n"
        else:
            f2.write('OK\n')
            print "OK\n"
        f2.close()


omg = BDTest()
omg.GetBD_def_acc()
omg.GetBD_posts()
omg.GetBD_acc()
omg.GetBD_accs()
print "ReAdY!"



