#!/usr/bin/env python
"""
 @file: ListMyPosts.py
  File is a part of Scribo Project
  Module implements viewing list of post from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""
import sys
#sys.path.append("./src/services")
#sys.path.append("./src/ldm")


from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"

class ListMyPosts(ToolbarWindow):
    """
    class for draw list of posts window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent=None):
        """ 
        initialization "list of posts" window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.create_actions()
        toolbar = self.create_toolbar()
        self.vbox = QtGui.QVBoxLayout()
        self.mes_list = self.list_posts()
        self.vbox.addWidget(toolbar)
        self.vbox.addWidget(self.mes_list)
        self.setLayout(self.vbox)


    def list_posts(self):
        """
        fill list of posts
        @param
        @return
        """
        list_widget = QtGui.QListWidget(self)
        self.list = self.get_user_posts()
        upic = QtGui.QImage("../data/faviconLJ.ico")
        index = 0

        if len(self.list) == 0:
            from ConfigDriver import config
            c = config.get_bool('UI', 'warning_press_refresh')
            if not c:
                msg = QtGui.QMessageBox()
                show_button = QtGui.QCheckBox("Don't show this message again", msg)
                title_label = QtGui.QLabel("Press refresh button for getting posts from services", msg)
                msg.layout().addWidget(title_label, 0, 0, 1, 3, QtCore.Qt.AlignLeft)
                msg.layout().addWidget(show_button, 1, 0, 1, 2, QtCore.Qt.AlignLeft)
                cancel_button = msg.addButton(QtGui.QMessageBox.Close)
                msg.exec_()

                if msg.clickedButton() == cancel_button:
                    if show_button.isChecked():
                        config.set('UI', 'warning_press_refresh', True)
                        print "Checked"


        for mes in self.list:
            date = unicode(mes.date)
            title = unicode(mes.title)
            if not mes.title:
                title = "no subject"
            text = unicode(date + "  " + title)
            #if not mes.read:
                #text =text + "  <font color=\"green\">  NEW!!! </font>"
            new_item = QtGui.QListWidgetItem(QtGui.QIcon("../data/faviconLJ.ico"),
                                             text,
                                             list_widget)
            new_item.setData(1, QtCore.QVariant(index))
            index = index + 1
            del text
            del title
            del date
        self.connect(list_widget, QtCore.SIGNAL("itemActivated(QListWidgetItem*)"),
                     self.view_message)
        return list_widget

    def get_user_posts(self):
        return main_prof.get_posts()

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = QtGui.QToolBar("", self)
        file_tool_bar.setIconSize(QtCore.QSize(64, 64))
        file_tool_bar.addAction(self.back_act)
        file_tool_bar.addAction(self.home_act)
        file_tool_bar.addAction(self.refresh_act)
        file_tool_bar.addAction(self.del_act)
        return file_tool_bar


    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        self.refresh_act = QtGui.QAction(self.tr("&Refresh"), self)
        #self.refresh_act.setStatusTip(self.tr("Refresh"))
        self.refresh_act.setIcon(QtGui.QIcon("../data/refresh.png"))
        self.connect(self.refresh_act, QtCore.SIGNAL("triggered()"),
                     self.reload_window)

        self.del_act = QtGui.QAction(self.tr("&Delete"), self)
        #self.del_act.setStatusTip(self.tr("Delete"))
        self.del_act.setIcon(QtGui.QIcon("../data/del.png"))
        self.connect(self.del_act, QtCore.SIGNAL("triggered()"),
                     self.delete_message)

        super(ListMyPosts, self).create_actions()

    def view_message(self, item):
        """        
        view choosing post
        @param
        @return       
        """
        index = item.data(1).toString().toInt()[0]
        mes = self.list[index]
        view_widg = ViewMessage(main_window, mes)
        main_window.push_window(view_widg)

    def delete_message(self):
        """        
        delete choosing post
        @param
        @return       
        """
        ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Do you really want delete post?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
            return
        list = self.mes_list.selectedItems()
        if list:
            for item in list:
                index = item.data(1).toString().toInt()[0]
                mes = self.list[index]
                try:
                    mes.poster.del_post(mes)
                except WarningExc, exc:
                    main_window.show_warning(exc)
                else:
                    self.mes_list.removeItemWidget(item)
                    item.setHidden(True)
                    item.setSelected(False)

        else:
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, choose deleting messages!"),
                               QtGui.QMessageBox.Yes)




    def reload_window(self):
        """
        refresh list of posts 
        @param          
        @return
        """
        list_acc = main_prof.accounts
        self.progress = QtGui.QProgressDialog("Operation in progress.",
                                              "Cancel", 0, 10, self)
        self.progress.setWindowModality(QtCore.Qt.WindowModal)
        self.value_progress = 1
        self.progress.setValue(self.value_progress)

        self.progress.forceShow()
        for acc in list_acc:
            try:
                acc.refresh_posts(self.callback)
            except WarningExc, exc:
                main_window.show_warning(exc)
            #acc.get_posts(self.callback)
        self.progress.setValue(self.progress.maximum())
        self.vbox.removeWidget(self.mes_list)
        self.mes_list.deleteLater()
        self.mes_list = self.list_posts()
        self.vbox.addWidget(self.mes_list)

    def callback(self):
        self.progress.setValue(self.value_progress)
        self.value_progress = self.value_progress + 1
        print "!!!"


from ViewMessage import *
from ldm.Profile import *
