#!/usr/bin/env python
"""
 @file: StartPage.py
  File is a part of Scribo Project
  Module implements start window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""

import sys
from PyQt4 import QtCore
from PyQt4 import QtGui



from ldm.Profile import main_prof
from services.Dispatcher import dispatcher
from ScriboExc import WarningExc

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"


class StartPage(QtGui.QWidget):
    """
    class for draw start window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  auth_check
    """

    def __init__(self, parent=None):
        """
        initialization start window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())

        login_label = QtGui.QLabel(self.tr("Login"), self)
        login_label.setAlignment(QtCore.Qt.AlignLeft)
        pasw_label = QtGui.QLabel(self.tr("Password"), self)
        pasw_label.setAlignment(QtCore.Qt.AlignLeft)

        #from MainWindow import main_window
        parent.new_act.setDisabled(True)
        parent.manage_act.setDisabled(True)

        self.login_edit = QtGui.QLineEdit(self)
        self.pasw_edit = QtGui.QLineEdit(self)
        self.pasw_edit.setEchoMode(QtGui.QLineEdit.Password)
        self.login_edit.setFocus()
        self.serv_combo = self.fill_combo()

        start_button = QtGui.QPushButton(self.tr("Go"), self)
        start_button.setIcon(QtGui.QIcon("../data/key.png"))
        self.connect(start_button, QtCore.SIGNAL("clicked()"), self.add_account)

        grid = QtGui.QGridLayout()
        grid.addWidget(login_label, 0, 0)
        grid.addWidget(self.login_edit, 0, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.addWidget(pasw_label, 1, 0)
        grid.addWidget(self.pasw_edit, 1, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.addWidget(self.serv_combo, 2, 0)
        grid.addWidget(start_button, 2, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.setColumnStretch(0, 1)
        grid.setColumnStretch(1, 2)
        self.setLayout(self.create_start(grid))

    def fill_combo(self):
        """
        fill combo_box 
        @param
        @return
        """

        serv_combo = QtGui.QComboBox(self)

        serv = dispatcher.get_services()
        for i in serv:
            icon = QtGui.QIcon(i.get_icon())
            name = i.get_name()
            serv_combo.addItem(icon, name)

        return serv_combo


    def add_account(self):
        """
        handler fo buttons Go(authentification)
        @return
        """

        if (self.login_edit.text() == "") or (self.pasw_edit.text() == ""):
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, fill all  lines!"),
                               QtGui.QMessageBox.Yes)
            return

        if self._add_new_account():

            from MainWindow import main_window

            main_window.new_act.setDisabled(False)
            main_window.manage_act.setDisabled(False)
            main_window.home_window()


    def _add_new_account(self):

        from MainWindow import main_window

        index = self.serv_combo.currentIndex()
        acc = dispatcher.get_services()[index]()

        acc.username = str(self.login_edit.text())
        acc.passwd = str(self.pasw_edit.text())

        try:
            main_prof.add_account(acc, True)
        except WarningExc, exc:
            acc.del_account()
            main_window.show_warning(exc)
            return False

        try:
            acc.check_login()
        except WarningExc, exc:
            acc.del_account()
            main_window.show_warning(exc)
            return False


        try:
            acc.refresh_user_info()
        except WarningExc, exc:
            main_window.show_warning(exc)

        acc.set_default()

        return True


    def create_start(self, grid):
        """
        creating containers
        @param grid - grid with lines for login and password
        @return
        """
        hbox = QtGui.QHBoxLayout()
        vbox1 = QtGui.QVBoxLayout()
        vbox2 = QtGui.QVBoxLayout()
        image_label = QtGui.QLabel(self)
        image_label.setAlignment(QtCore.Qt.AlignCenter)
        start_label = QtGui.QLabel(self.tr("<i>Welcome to Scribo!</i>"), self)
        start_label.setAlignment(QtCore.Qt.AlignCenter)
        upic = QtGui.QImage(self.tr("../data/Scribo.png"))
        image_label.setPixmap(QtGui.QPixmap.fromImage(upic))
        vbox1.addWidget(start_label, 0, QtCore.Qt.AlignTop)
        vbox1.addWidget(image_label, 1, QtCore.Qt.AlignCenter)
        vbox2.addLayout(grid, 1)

        hbox.addLayout(vbox1, 1)
        hbox.addLayout(vbox2, 1)
        hbox.insertSpacing(-1, 30)
        return hbox




