#!/usr/bin/env python
"""
 @file: SysTest.py
  File is a part of Scribo Project
  Module implements add post from file
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 14.02.2010
"""

import sys
sys.path.append("..")
sys.path.append("../ldm")
sys.path.append("../ui")
sys.path.append("../services")

from Message import Message
from Profile import *
from Account import *
from LivejAccount import *
from BlurtyAccount import *
from time import *
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysTest:
    """
    Class with test method for SendPost module
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        acc = LivejAccount()
        ac1 = BlurtyAccount()
        acc.set_option('proxy', '172.20.3.1:81')

        acc.username = "scribo_rpc"
        acc.passwd = "test123"

        ac1.username = "sscribo"
        ac1.passwd = "test123"

        tm = localtime(time())
        date = "%s-%s-%s %s:%s:%s" % (tm.tm_year,
            tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec)

        f = open('./data/TestRes.txt', 'a')
        f.write('\n=====System testing at time %s=====\n' % (date))

        """
        acc.username = "maemoblogs"
        acc.passwd = "maemo100500"
        """
        f.write('\nChecking Add Account Scenario ')
        try:
            main_prof.add_account(ac1)
        except:
            print "we have Blurty )"
        try:
            main_prof.add_account(acc)
        except:
            print "already have"
            acc = Account.find(type(acc), acc.username)
        try:
            main_prof.set_def_account(acc)
        except:
            f.write('ERROR\n')
        else:
            f.write('OK\n')
        f.close()

    mes1 = Message()
    mes2 = Message()
    alf = "QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm0123456789"



    def send_post(self):
        """ 
        method 4 testing send post scenario 
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Send post Scenario with LiveJournal:\n')

        f = open('./data/testMes.txt', 'r')

        all_lines = f.readlines()
        tm = localtime(time())
        date = "%s-%s-%s %s:%s" % (tm.tm_year,
            tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min)
        header = all_lines[0] + date
        body = all_lines[1]

        f.close()

        mes = Message()
        mes.title = unicode(header, errors='replace')
        mes.text = unicode("\"><script>alert()</script> " + body, errors='replace')
        mes.tags = unicode("'; DROP TABLE Messages;'", errors='replace')

        f1.write(' -normal post ')

        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')


        self.mes1.title = ''
        self.mes1.text = all_lines[2]

        f1.write(' -post without title ')

        try:
            main_prof.def_account.add_post(self.mes1)
            res = main_prof.def_account.send_post(self.mes1)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')
        f.close()
        f1.close()

    def send_random_post(self):
        """ 
        testing send post scenario with random values
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write(' -random generated post ')

        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += self.random_str(100) + "<br>"

        mesr = Message()
        mesr.title = unicode(header, errors='replace')
        mesr.text = unicode("\"><script>alert()</script> " + body, errors='replace')
        mesr.tags = unicode(self.random_str(5), errors='replace')
        try:
            main_prof.def_account.add_post(mesr)
            res = main_prof.def_account.send_post(mesr)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')
            f1.close()

    def send_blurty_post(self):
        """ 
        testing send post scenario with random values
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Send post Scenario with Blurty: ')

        acc = BlurtyAccount()
        acc.username = "sscribo"
        same_acc = Account.find(type(acc), acc.username)

        main_prof.set_def_account(same_acc)

        print main_prof.def_account.passwd

        header = self.random_str(50)
        body = ""
        for i in range(1, 100):
            body += self.random_str(100) + "<br>"

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.text = unicode("\"><script>alert()</script> " + body, errors='replace')
        mesa.tags = unicode(self.random_str(5), errors='replace')
        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
        except:
            print "can't add post"
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        acca = LivejAccount()
        acca.username = "scribo_rpc"
        same_acc = Account.find(type(acca), acca.username)

        main_prof.set_def_account(same_acc)
        f1.close()


    def send_big_post(self):
        """ 
        method 4 testing send post scenario with BIG post
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write(' -big post ')

        f = open('./data/bigPOST', 'r')

        all_lines = f.readlines()

        header = all_lines[0]
        body = all_lines[1]
        f.close()
        f = open('./data/bigPOST', 'r')

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.title += unicode(" - ", errors='replace') + unicode(body, errors='replace')

        all_lines = f.read()
        mesa.text = unicode(all_lines, errors='replace')
        f.close()
        try:
            main_prof.def_account.add_post(mesa)
            res = main_prof.def_account.send_post(mesa)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

    def get_posts(self):
        """ 
        method 4 testing get posts from LiveJournal scenario 
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Get Posts Scenario: ')
        list = []
        out = open('./data/posts.txt', 'w')

        """
        uncomment to start stress testing
        """
        #for i in range(1, 1000):
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        if len(list) == 0:
            print 'There are no posts - look for bug!'

        for mess in list:
            if not mess.title:
                title = "no subject"
            else:
                title = mess.get_title()

            text = mess.get_text()


            out.write('\n%s\n%s\n' % (title.encode("utf-8"), text.encode("utf-8")))
            if (mess == list[0]):
                self.mes1.custom_id = mess.get_custom_id()
            if (mess == list[1]):
                self.mes2.custom_id = mess.get_custom_id()
        out.close()
        f1.close()


    def del_posted(self):
        """
        deleting our post from LJ
        """
        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Delete Post Scenario: ')
        try:
            main_prof.def_account.del_post(self.mes1)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')

        print "deleted"
        f1.close()

    def random_str(self, len=20):
        """
        generating random symbol combination
        """
        if len:return random.choice(self.alf) + self.random_str(len - 1)
        else:return ""

    def edit_your_post(self):
        """
        trying to edit last post has been sent
        """

        f1 = open('./data/TestRes.txt', 'a')
        f1.write('\nChecking Edit Post Scenario: ')

        f = open('./data/testMes.txt', 'r')
        all_lines = f.readlines()

        tm = localtime(time())
        date = "%s-%s-%s %s:%s:%s" % (tm.tm_year,
            tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec)

        pwd = self.random_str(20)

        self.mes2.title = unicode(all_lines[3], errors='replace')
        self.mes2.text = unicode(all_lines[4] + "<br><br>", errors='replace')
        self.mes2.text += unicode("Your New password is " + pwd, errors='replace')
        self.mes2.tags = unicode("deleted", errors='replace')
        self.mes2.date = unicode(date, errors='replace')

        try:
            main_prof.def_account.edit_post(self.mes2)
        except:
            f1.write('ERROR\n')
        else:
            f1.write('OK\n')
        f1.close()


    def callback(self):
        """ 
        callback 4 get_posts method 
        """
        print "getting posts..."

""" 
creating class instance & calling its methods
"""
testing = SysTest()
#testing.send_post()
#testing.send_random_post()
#testing.send_big_post()
#testing.send_blurty_post()
testing.get_posts()
testing.del_posted()
testing.edit_your_post()
print "FINISH!"
