#!/usr/bin/env python

"""
===============================================================
   This file contains functions to work with InsaneJournal 
(clone of LiveJournal.com)
    
    http://www.insanejournal.com/
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/03/28 $"
__copyright__ = ""
__license__ = "GPLv2"

from LivejAccount import LivejAccount

INSANE_SERVER = "http://www.insanejournal.com/interface/xmlrpc:80"
INSANE_USERPICS = 'http://www.insanejournal.com/userpic/'


class InsanejAccount(LivejAccount):

    def __init__(self, id=None):
        super(InsanejAccount, self).__init__(id, INSANE_SERVER, INSANE_USERPICS)


    @staticmethod
    def get_name():
        """
        Get name of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) name of this service
        """

        return 'InsaneJournal'


    @staticmethod
    def get_icon():
        """
        Get path to icon of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) path to icon of this service
        """

        return '../data/insanej.gif'

