#ifndef _SCOUT_WINDOW_H_
#define _SCOUT_WINDOW_H_

#include <hildon/hildon.h>
#include <libosso.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define SCOUT_TYPE_WINDOW (scout_window_get_type())
#define SCOUT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCOUT_TYPE_WINDOW, ScoutWindow))
#define SCOUT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCOUT_TYPE_WINDOW, ScoutWindowClass))
#define IS_SCOUT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCOUT_TYPE_WINDOW))
#define IS_SCOUT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), SCOUT_TYPE_WINDOW))
#define SCOUT_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCOUT_TYPE_WINDOW, ScoutWindowClass))

typedef struct _ScoutWindow ScoutWindow;
typedef struct _ScoutWindowClass ScoutWindowClass;
typedef struct _ScoutWindowPrivate ScoutWindowPrivate;

struct _ScoutWindowClass
{
  HildonStackableWindowClass parent_class;
};

struct _ScoutWindow
{
  HildonStackableWindow parent;
  
  ScoutWindowPrivate *priv;
};

GType scout_window_get_type(void);

ScoutWindow* scout_window_new(osso_context_t* osso);
void scout_window_set_abook(ScoutWindow* window, 
			    OssoABookAggregator* abook); 

void scout_window_set_account_manager(ScoutWindow* window, 
				      OssoABookAccountManager* acc_manger); 
G_END_DECLS
#endif
