/** @file scim_pphanpin_imengine.h
 * definition of PPHanpin related classes.
 */

/* 
 * Smart Common Input Method
 * 
 * Copyright (c) 2006	Yang Hong <hongyang@redflag-linux.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_pphanpin_imengine.h,v 1.2 2005/02/02 15:25:34 yangh Exp $
 */

#if !defined (__SCIM_PPHANPIN_SERVER_H)
#define __SCIM_PPHANPIN_SERVER_H

using namespace scim;

class PPHanpinFactory : public IMEngineFactoryBase
{
    friend class PPHanpinInstance;

public:
    PPHanpinFactory ();
    virtual ~PPHanpinFactory ();

    virtual WideString  get_name () const;
    virtual WideString  get_authors () const;
    virtual WideString  get_credits () const;
    virtual WideString  get_help () const;
    virtual String      get_uuid () const;
    virtual String      get_icon_file () const;
    virtual String      get_language () const;

    virtual IMEngineInstancePointer create_instance (const String& encoding, int id = -1);
};

class PPHanpinInstance : public IMEngineInstanceBase
{
    bool m_helper_started;
    bool m_focused;
    bool m_work;
    bool m_show;

    Transaction m_trans;
    CommonLookupTable m_lookup_table;
    WideString        m_preedit_string;
    IConvert m_iconv;

public:
    PPHanpinInstance (PPHanpinFactory *factory,
                     const String& encoding,
                     int id = -1);
    virtual ~PPHanpinInstance ();

    virtual bool process_key_event (const KeyEvent& key);
    virtual void process_helper_event (const String &helper_uuid, const Transaction &trans);
    virtual void move_preedit_caret (unsigned int pos);
    virtual void select_candidate (unsigned int item);
    virtual void update_lookup_table_page_size(unsigned int page_size);
    virtual void lookup_table_page_up ();
    virtual void lookup_table_page_down ();
    virtual void reset ();
    virtual void focus_in ();
    virtual void focus_out ();
private:
	int create_lookup_table (int start = 0);
	void process_preedit_string ();
	bool clear_preedit_string();
	bool CimConfigure(wchar_t *pRootChar);
	void WOutputDebugMessage(wchar_t * pstr);
	void direct_send_word (wchar_t word);
	
	String get_multibyte_string (const WideString& preedit);
	ucs4_t get_unicode_value (const WideString& preedit);
};

#endif
/*
vi:ts=4:nowrap:ai:expandtab
*/

