/** @file scim_pphanpin_imengine.cpp
 * implementation of class PPHanpinInstance.
 */

/*
 * Smart Common Input Method
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id $
 *
 */

#include <gdk/gdkx.h>
#include <string.h>
/* FIXME: use scim-gtkutils? */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/keysym.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define Uses_SCIM_IMENGINE
#define Uses_SCIM_ICONV
#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_TRANS_COMMANDS
#define Uses_STL_MAP

#define SCIM_HANPIN_ICON_FILE "/usr/share/scim/icons/penpower_pinyinlogo.png"

#include <gtk/gtk.h>
/* FIXME: use scim-gtkutils? */
#include <glib/gi18n-lib.h>

#include "scim.h"
#include "scim_pphanpin.h"
#include "scim_pphanpin_imengine.h"
#include "scim_hanpin.h"

#include "Definitions.h"
#include "CommonInputMethod.h"

#define scim_module_init pphanpin_imengine_LTX_scim_module_init
#define scim_module_exit pphanpin_imengine_LTX_scim_module_exit
#define scim_imengine_module_init pphanpin_imengine_LTX_scim_imengine_module_init
#define scim_imengine_module_create_factory pphanpin_imengine_LTX_scim_imengine_module_create_factory

//#define __ENABLE_HELPER_MODULE_
//#define __DUMP_HANPIN_DEBUG_MESSAGE__

namespace hanpin
{
    class PPKeyMap
    {
	public:
		int m_keyid;
		wchar_t m_keywchar1[2];
		wchar_t m_keywchar2[2];
		guint m_keycode1;
		guint m_keycode2;
    };
};

using namespace hanpin;
PPKeyMap hanpin_keymap[128];
using namespace scim;

static Pointer <PPHanpinFactory> _scim_pphanpin_factory;
static ConfigPointer _scim_config;

wchar_t* pRootString;
CCandidateIndex* gbl_pCI = NULL;
struct CandidateWordBuffer* gbl_pCWBuffer = NULL;
int init_hanpinkeymap(PPKeyMap* keymap);
int key_number = 0;
WideString gbl_CandicateString;
WideString gbl_PreeditString;
int start_index = 0;
static CCommonInputMethod cim;
int Candidate_count = 0;
bool m_show_string = false;
wchar_t gbl_preedit_wstring[10] = L"";
bool g_writedebug(char * pFilename, char *OutputString);
bool g_writedebug(char * pFilename, wchar_t *OutputString);
bool checkhardware(void);
bool gbl_passcheck = false;
bool CimConfigure(wchar_t *pRootChar);

static const char * _DEFAULT_LANGUAGES = N_(
    "zh_CN,zh_TW,zh_HK,zh_SG,ja_JP,ko_KR,en_US,en_GB,es_ES,it_CH,it_IT");

extern "C" {
    void scim_module_init (void)
    {
        bindtextdomain (GETTEXT_PACKAGE, SCIM_PPHANPIN_LOCALEDIR);
        bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    }

    void scim_module_exit (void)
    {
        _scim_pphanpin_factory.reset ();
        _scim_config.reset ();
    }

    unsigned int scim_imengine_module_init (const ConfigPointer &config)
    {
        _scim_config = config;
        return 1;
    }

    IMEngineFactoryPointer scim_imengine_module_create_factory (unsigned int factory)
    {
        String languages;

        if (factory != 0) return NULL;

        if (_scim_pphanpin_factory.null ()) {
            _scim_pphanpin_factory =
                new PPHanpinFactory ();
        }
        return _scim_pphanpin_factory;
    }
}

// implementation of PPHanpin
PPHanpinFactory::PPHanpinFactory ()
{
    set_languages (String (_(_DEFAULT_LANGUAGES)));
}

PPHanpinFactory::~PPHanpinFactory ()
{
}

WideString
PPHanpinFactory::get_name () const
{
    return utf8_mbstowcs (_("PINYIN Pad"));
}

WideString
PPHanpinFactory::get_authors () const
{
    return utf8_mbstowcs (String (_("(C) 2009 Vincent Lu <vincent@penpower.com.tw>")));
}

WideString
PPHanpinFactory::get_credits () const
{
    return WideString ();
}

WideString
PPHanpinFactory::get_help () const
{
    return WideString ();
}

String
PPHanpinFactory::get_uuid () const
{
    return String (SCIM_PPHANPIN_IMENGINE_UUID);
}

String
PPHanpinFactory::get_icon_file () const
{
    return String (SCIM_HANPIN_ICON_FILE);
}

String
PPHanpinFactory::get_language () const
{
    return scim_validate_language ("zh_TW");
}

IMEngineInstancePointer
PPHanpinFactory::create_instance (const String& encoding, int id)
{
    return new PPHanpinInstance (this, encoding, id);
}

// implementation of PPHanpinInstance
PPHanpinInstance::PPHanpinInstance (PPHanpinFactory *factory,
                            const String& encoding,
                            int id)
    : IMEngineInstanceBase (factory, encoding, id),
      m_helper_started (false),
      m_focused (false),
      m_work (false),
      m_show (false)
{	
	key_number = init_hanpinkeymap(hanpin_keymap);
	gbl_CandicateString.clear();
	gbl_PreeditString.clear();
	Candidate_count = 0;
	memset(gbl_preedit_wstring, 0, 10 * sizeof(wchar_t));
    gbl_passcheck = checkhardware();
}

PPHanpinInstance::~PPHanpinInstance ()
{
	char destring[512] = "";
    	sprintf(destring, "hanpin imengine %s\n", __func__);
    	g_writedebug("/home/debug.txt", destring);
	if (m_helper_started) 
    {

    	memset(destring, 0, 512); 
        sprintf(destring, "hanpin imengine %s send_helper_event(), send SCIM_TRANS_CMD_FOCUS_OUT\n", __func__);
        g_writedebug("/home/debug.txt", destring);
		m_trans.clear ();
        m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
        m_trans.put_command (SCIM_TRANS_CMD_FOCUS_OUT);
#ifdef __ENABLE_HELPER_MODULE_
        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
		stop_helper (SCIM_PPHANPIN_HELPER_UUID);
#endif
		//g_writedebug("./home/engine_exit.txt", "exit");
		if(pRootString != NULL)
		{
			delete [] pRootString;
			pRootString = NULL;
		}
		//cim.Dispose();
		m_helper_started = false;
    }
	memset(destring, 0, 512);
	sprintf(destring, "hanpin imengine %s\n", __func__);
    g_writedebug("/home/debug.txt", destring);
}

inline static int ascii_to_hex (int ascii)
{
	if (ascii >= '0' && ascii <= '9')
		return ascii - '0';
	else if (ascii >= 'a' && ascii <= 'f')
		return ascii - 'a' + 10;
	else if (ascii >= 'A' && ascii <= 'F')
		return ascii - 'A' + 10;
	return 0;
}
inline static int hex_to_ascii (int hex)
{
	hex %= 16;

	if (hex >= 0 && hex <= 9)
		return hex + '0';

	return hex - 10 + 'a';
}

bool checkhardware(void)
{

	time_t tval;
	struct tm *now;  
	time(&tval);
	now = localtime(&tval);
	const int year = now->tm_year + 1900; //年
	const int month = now->tm_mon + 1; //月
	//const int& day = now->tm_mday; //日
	if( (year > 2010) || ((year == 2010) && (month > 7)))
	{
		//g_message("program expire \n");
		return 0;	
	}
	else
	{

	}
	///////////////////////檢查時間結束//////////////////////
	return 1;
}


bool g_writedebug(char * pFilename, wchar_t *OutputString)
{
	FILE* stream = NULL;
	if(pFilename == NULL) return false;
	if(OutputString == NULL) return false;

	if ((stream = fopen(pFilename, "a+")) != NULL)
	{
		if(OutputString != NULL)
		{
			fwrite(OutputString, wcslen(OutputString), 1, stream);
			fclose(stream);
			return true;
		}
		else
			return false;
	}
}


bool g_writedebug(char * pFilename, char *OutputString)
{
#ifdef __DUMP_HANPIN_DEBUG_MESSAGE__
    FILE* stream = NULL;
    if(pFilename == NULL) return false;
    if(OutputString == NULL) return false;

    if ((stream = fopen(pFilename, "a+")) != NULL)
    {
        if(OutputString != NULL)
        {
            fwrite(OutputString, strlen(OutputString)*sizeof(char), 1, stream);
            fclose(stream);
            return true;
        }
        else
            return false;
    }

#else
    if(OutputString != NULL)
        g_message(OutputString);
#endif
    return true;
}

int init_hanpinkeymap(PPKeyMap *keymap)
{
	int i = 0;
	keymap[i].m_keyid = BUTTON_Q_ID;
	keymap[i].m_keycode1 = SCIM_KEY_q;
	keymap[i].m_keycode2 = SCIM_KEY_Q;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"q");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Q");		
	i++;
	keymap[i].m_keyid = BUTTON_W_ID;
	keymap[i].m_keycode1 = SCIM_KEY_w;
	keymap[i].m_keycode2 = SCIM_KEY_W;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"w");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"w");
	i++;
	keymap[i].m_keyid = BUTTON_E_ID;
	keymap[i].m_keycode1 = SCIM_KEY_e;
	keymap[i].m_keycode2 = SCIM_KEY_E;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"e");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"E");
	i++;
	keymap[i].m_keyid = BUTTON_R_ID;
	keymap[i].m_keycode1 = SCIM_KEY_r;
	keymap[i].m_keycode2 = SCIM_KEY_R;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"r");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"R");
	i++;
	keymap[i].m_keyid = BUTTON_T_ID;
	keymap[i].m_keycode1 = SCIM_KEY_t;
	keymap[i].m_keycode2 = SCIM_KEY_T;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"t");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"T");
	i++;
	keymap[i].m_keyid = BUTTON_Y_ID;
	keymap[i].m_keycode1 = SCIM_KEY_y;
	keymap[i].m_keycode2 = SCIM_KEY_Y;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"y");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Y");
	i++;
	keymap[i].m_keyid = BUTTON_U_ID;
	keymap[i].m_keycode1 = SCIM_KEY_u;
	keymap[i].m_keycode2 = SCIM_KEY_U;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"u");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"U");
	i++;
	keymap[i].m_keyid = BUTTON_I_ID;
	keymap[i].m_keycode1 = SCIM_KEY_i;
	keymap[i].m_keycode2 = SCIM_KEY_I;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"i");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"I");
	i++;
	keymap[i].m_keyid = BUTTON_O_ID;
	keymap[i].m_keycode1 = SCIM_KEY_o;
	keymap[i].m_keycode2 = SCIM_KEY_O;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"o");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"O");
	i++;
	keymap[i].m_keyid = BUTTON_P_ID;
	keymap[i].m_keycode1 = SCIM_KEY_p;
	keymap[i].m_keycode2 = SCIM_KEY_P;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"p");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"P");
	i++;
	keymap[i].m_keyid = BUTTON_BK_ID;
	keymap[i].m_keycode1 = SCIM_KEY_BackSpace;
	keymap[i].m_keycode2 = SCIM_KEY_BackSpace;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;	
	keymap[i].m_keyid = BUTTON_BOARD_ID;
	keymap[i].m_keycode1 = 0;
	keymap[i].m_keycode2 = 0;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_TAB_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Tab;
	keymap[i].m_keycode2 = SCIM_KEY_Tab;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_A_ID;
	keymap[i].m_keycode1 = SCIM_KEY_a;
	keymap[i].m_keycode2 = SCIM_KEY_A;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"a");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"A");
	i++;
	keymap[i].m_keyid = BUTTON_S_ID;
	keymap[i].m_keycode1 = SCIM_KEY_s;
	keymap[i].m_keycode2 = SCIM_KEY_S;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"s");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"S");
	i++;
	keymap[i].m_keyid = BUTTON_D_ID;
	keymap[i].m_keycode1 = SCIM_KEY_d;
	keymap[i].m_keycode2 = SCIM_KEY_D;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"d");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"D");
	i++;
	keymap[i].m_keyid = BUTTON_F_ID;
	keymap[i].m_keycode1 = SCIM_KEY_f;
	keymap[i].m_keycode2 = SCIM_KEY_F;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"f");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"F");
	i++;
	keymap[i].m_keyid = BUTTON_G_ID;
	keymap[i].m_keycode1 = SCIM_KEY_g;
	keymap[i].m_keycode2 = SCIM_KEY_G;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"g");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"G");
	i++;
	keymap[i].m_keyid = BUTTON_H_ID;
	keymap[i].m_keycode1 = SCIM_KEY_h;
	keymap[i].m_keycode2 = SCIM_KEY_H;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"h");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"H");
	i++;
	keymap[i].m_keyid = BUTTON_J_ID;
	keymap[i].m_keycode1 = SCIM_KEY_j;
	keymap[i].m_keycode2 = SCIM_KEY_J;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"j");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"J");
	i++;
	keymap[i].m_keyid = BUTTON_K_ID;
	keymap[i].m_keycode1 = SCIM_KEY_k;
	keymap[i].m_keycode2 = SCIM_KEY_K;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"k");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"K");
	i++;
	keymap[i].m_keyid = BUTTON_L_ID;
	keymap[i].m_keycode1 = SCIM_KEY_l;
	keymap[i].m_keycode2 = SCIM_KEY_L;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"l");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"L");
	i++;
	keymap[i].m_keyid = BUTTON_ENTER_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Return;
	keymap[i].m_keycode2 = SCIM_KEY_Return;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_CAPS_ID;
	keymap[i].m_keycode1 = SCIM_KEY_Caps_Lock;
	keymap[i].m_keycode2 = SCIM_KEY_Caps_Lock;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_Z_ID;
	keymap[i].m_keycode1 = SCIM_KEY_z;
	keymap[i].m_keycode2 = SCIM_KEY_Z;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"z");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"Z");
	i++;
	keymap[i].m_keyid = BUTTON_X_ID;
	keymap[i].m_keycode1 = SCIM_KEY_x;
	keymap[i].m_keycode2 = SCIM_KEY_X;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"x");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"X");
	i++;
	keymap[i].m_keyid = BUTTON_C_ID;
	keymap[i].m_keycode1 = SCIM_KEY_c;
	keymap[i].m_keycode2 = SCIM_KEY_C;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"c");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"C");
	i++;
	keymap[i].m_keyid = BUTTON_V_ID;
	keymap[i].m_keycode1 = SCIM_KEY_v;
	keymap[i].m_keycode2 = SCIM_KEY_V;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"v");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"V");
	i++;
	keymap[i].m_keyid = BUTTON_B_ID;
	keymap[i].m_keycode1 = SCIM_KEY_b;
	keymap[i].m_keycode2 = SCIM_KEY_B;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"b");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"B");
	i++;
	keymap[i].m_keyid = BUTTON_N_ID;
	keymap[i].m_keycode1 = SCIM_KEY_n;
	keymap[i].m_keycode2 = SCIM_KEY_N;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"n");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"N");
	i++;
	keymap[i].m_keyid = BUTTON_M_ID;
	keymap[i].m_keycode1 = SCIM_KEY_m;
	keymap[i].m_keycode2 = SCIM_KEY_M;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar1, L"m");
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	wcscpy(keymap[i].m_keywchar2, L"M");
	i++;
	keymap[i].m_keyid = BUTTON_SEMI_ID;
	keymap[i].m_keycode1 = SCIM_KEY_semicolon;
	keymap[i].m_keycode2 = SCIM_KEY_colon;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_QUOTE_ID;
	keymap[i].m_keycode1 = SCIM_KEY_quoteright;
	keymap[i].m_keycode2 = SCIM_KEY_quotedbl;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_CTRL_ID;
	keymap[i].m_keycode1 = SCIM_KEY_ControlMask;
	keymap[i].m_keycode2 = SCIM_KEY_ControlMask;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_EXCLAM_ID;
	keymap[i].m_keycode1 = SCIM_KEY_exclam;
	keymap[i].m_keycode2 = SCIM_KEY_asterisk;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_QUEST_ID;
	keymap[i].m_keycode1 = SCIM_KEY_question;	
	keymap[i].m_keycode2 = SCIM_KEY_at;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_SPACE_ID;
	keymap[i].m_keycode1 = SCIM_KEY_space;
	keymap[i].m_keycode2 = SCIM_KEY_space;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_COMMA_ID;
	keymap[i].m_keycode1 = SCIM_KEY_comma;
	keymap[i].m_keycode2 = SCIM_KEY_less;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_DOT_ID;
	keymap[i].m_keycode1 = SCIM_KEY_period;
	keymap[i].m_keycode2 = SCIM_KEY_greater;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_DASH_ID;
	keymap[i].m_keycode1 = SCIM_KEY_minus;
	keymap[i].m_keycode2 = SCIM_KEY_underscore;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;
	keymap[i].m_keyid = BUTTON_SLASH_ID;
	keymap[i].m_keycode1 = SCIM_KEY_slash;
	keymap[i].m_keycode2 = SCIM_KEY_bar;
	memset(keymap[i].m_keywchar1, 0, 2*sizeof(wchar_t));
	memset(keymap[i].m_keywchar2, 0, 2*sizeof(wchar_t));
	i++;		
	return i;
}


static inline int wchar2utf8(/*in*/const wchar_t* in,int in_len,
							 /*out*/char* out,int out_max)
{
	size_t result;
	iconv_t env;

	env = iconv_open("UTF8","WCHAR_T");
	result = iconv(env,(char**)&in,(size_t*)&in_len,(char**)&out,(size_t*)
		&out_max);    
	iconv_close(env);
	return (int) result;
}

static inline int utf8towchar(/*in*/const char* in,int in_len,
							 /*out*/wchar_t* out,int out_max)
{
	size_t result;
	iconv_t env;

	env = iconv_open("WCHAR_T", "UTF8");
	result = iconv(env,(char**)&in,(size_t*)&in_len,(char**)&out,(size_t*)
		&out_max);
	iconv_close(env);
	return (int) result;
}

int FindKeyMapIndex(guint keycode, PPKeyMap *KeyMap, bool *b_key)
{
	int re_index = -1;
	for(int i = 0; i < key_number; i++)
	{	
		if(KeyMap[i].m_keycode1 == keycode || KeyMap[i].m_keycode2 == keycode)
		{
			if(KeyMap[i].m_keycode1 == keycode)
				*b_key = false;
			else
				*b_key = true;
			re_index = i;
			break;
		}
	}
	return re_index;
}

bool
PPHanpinInstance::clear_preedit_string()
{						
	m_trans.clear();
	m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
	m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
	int strlen = 0;
	if(pRootString != NULL)
	{
		strlen = wcslen(pRootString);
	}
	gbl_PreeditString.clear();
	for(int i = 0;i < strlen; i++)
	{
		gbl_PreeditString.push_back(pRootString[i]);
	}
	m_trans.put_data (gbl_PreeditString);
#ifdef __ENABLE_HELPER_MODULE_
	send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
	return TRUE;
}

void PPHanpinInstance::WOutputDebugMessage(wchar_t * pstr)
{

#ifdef __DUMP_HANPIN_DEBUG_MESSAGE__

		if(pstr)
			commit_string(pstr);
#else

#endif
}


void
PPHanpinInstance::move_preedit_caret (unsigned int /*pos*/)
{
}

void
PPHanpinInstance::select_candidate (unsigned int item)
{	
	CandidateWordBuffer aCandidateWord;
	int cim_index = m_lookup_table.get_current_page_start() + item ;
	cim.SelectCandidateWord(gbl_pCI, gbl_pCWBuffer[cim_index].ID, &aCandidateWord);
	WideString wCandidate = m_lookup_table.get_candidate_in_current_page(item);	
	commit_string(wCandidate);	
	m_lookup_table.clear();
	m_preedit_string.clear();
	memset(gbl_preedit_wstring, 0, 10 * sizeof(wchar_t));
	CimConfigure(NULL);
	hide_lookup_table ();
	hide_preedit_string ();
	clear_preedit_string();
}

void
PPHanpinInstance::update_lookup_table_page_size (unsigned int page_size)
{
	//char buf_out[256] = "";
	//GdkWChar wbuf[256];	
	//sprintf(buf_out, "page down:%d", page_size);
	//gdk_mbstowcs(wbuf, buf_out, 128);
	//commit_string((wchar_t*)wbuf);
	if (page_size > 0)
		m_lookup_table.set_page_size (page_size);
}

void
PPHanpinInstance::lookup_table_page_up ()
{	
	if (m_preedit_string.length () && m_lookup_table.number_of_candidates ()) {				
		m_lookup_table.page_up ();
		update_lookup_table (m_lookup_table);
		show_lookup_table ();
	}
}

void
PPHanpinInstance::lookup_table_page_down ()
{	
	if (m_preedit_string.length () && m_lookup_table.number_of_candidates ()) {		
		m_lookup_table.page_down ();				
		update_lookup_table (m_lookup_table);
		show_lookup_table ();
	}
}

bool wCharUpper2Lower(wchar_t *in, int in_size, wchar_t *out, int out_size)
{
	int i = 0, clen = 0;
	int len = 0;
	if(in != NULL)
	{
		len = wcslen(in);
	}
	char *plowerstring = new char[len+1];
	bool b_ret = false;

	wchar2utf8(in, in_size, plowerstring, len);
	for(i = 0; i < len; i++)
	{
		if((int)plowerstring[i] >= 65 && (int)plowerstring[i] <= 90 )
		{
			plowerstring[i] = (char)((int)plowerstring[i] + 32);
			b_ret = true;
		}
	}
	plowerstring[len] = '\0';	
	clen = strlen(plowerstring);
	if(b_ret)
		utf8towchar(plowerstring, clen, out, out_size);
	delete [] plowerstring;	
	return b_ret;
}

bool wCharLower2Upper(wchar_t *in, int in_size, wchar_t *out, int out_size)
{
	int i = 0, clen = 0;
	int len = 0;
	if(in != NULL)
	{
		len = wcslen(in);
	}
	char *plowerstring = new char[len+1];
	bool b_ret = false;

	wchar2utf8(in, in_size, plowerstring, len);
	for(i = 0; i < len; i++)
	{
		if((int)plowerstring[i] >= 97 && (int)plowerstring[i] <= 122 )
		{
			plowerstring[i] = (char)((int)plowerstring[i] - 32);
			b_ret = true;
		}
	}
	plowerstring[len] = '\0';
	g_writedebug("//home//user//pphanpindebug.txt", plowerstring);
	clen = strlen(plowerstring);
	if(b_ret)
		utf8towchar(plowerstring, clen, out, out_size);
	delete [] plowerstring;	
	return b_ret;
}


bool 
PPHanpinInstance::CimConfigure(wchar_t *pRootChar)
{
	CUnicodeStringList StringList;
	size_t n = 0;	
	bool b_ret = false;


	// 1. get available roots.
	//g_writedebug("//home//user//pphanpindebug.txt", pRootChar, 4*10);
	//g_writedebug("//home//user//pphanpindebug.txt", L"hou", 4*4);
	cim.GetAvailableRoots(pRootChar, true, &StringList);
	
	// 2. get number of available roots.
	n = cim.GetCountOfAvailableRoots(&StringList);

	
	if(pRootString != NULL)
	{
		delete [] pRootString;
		pRootString = NULL;
	}
	
		
	if(n > 0)
	{
		pRootString = new wchar_t[n+1];	// zero ending string.
		// 3. get wide character array. 		
		cim.GetAvailableRootsArray(&StringList, pRootString, n+1);

	}

	WOutputDebugMessage(L"(CimConfigure:");
	WOutputDebugMessage(pRootString);
	WOutputDebugMessage(L")");

 	cim.GetCandidateWordsByRoot(pRootChar, true, &gbl_pCI);
	size_t count = cim.GetCountOfCandidateWords(gbl_pCI);		

	if(count > 0)
	{//有候選字
		gbl_pCWBuffer = new CandidateWordBuffer[count];
		if(gbl_pCWBuffer)
		{
			cim.SortCandidateWords(gbl_pCI, DES_BY_PRIORITY);
			cim.GetCandidateWordsArray(gbl_pCI, gbl_pCWBuffer, count);
		}
		if(gbl_pCWBuffer != NULL)
		{
			gbl_CandicateString.clear();
			for(int i=0; i<count; i++)
			{				
				gbl_CandicateString.push_back(gbl_pCWBuffer[i].CandidateWord[0]);
			}
		}
		
		b_ret = true;
	}
	else
	{
		gbl_CandicateString.clear();
	}	
	StringList.Clear();
	return b_ret;
}


static GTimeVal F11_time;
static GTimeVal BackSpace_time;

bool
PPHanpinInstance::process_key_event (const KeyEvent& key)
{	
	//if(gbl_passcheck != true)
	//    return false;

	int stringlen = 0;
	char utf8_char[32] = "";
	WideString tempstring;
	gunichar *ucs4string = NULL;
	gunichar dest_ucs4;
	int keyindex = -1;
	GError *gerror;
	int i = 0;
	wchar_t *pwString;
	bool b_keycase = false;
	GTimeVal time;
    	GTimeVal bk_temp_time;
	char destring[512] = "";
/*
    if(key.code == SCIM_KEY_F11 && key.is_key_press())
        return false;
    if(key.code == SCIM_KEY_F11 && key.is_key_release()) 
	{
        g_get_current_time(&time);
		memset(destring, 0, 512);
		sprintf(destring, "hanpin imengine %s F11 release, get currentime:%d:,%d \n", __func__, time.tv_sec, time.tv_usec);
		g_writedebug("//home//user//pphanpindebug.txt", destring);
        if ((0==F11_time.tv_sec) && (0==F11_time.tv_usec))
        {
            g_get_current_time(&F11_time);
			memset(destring, 0, 512);
			sprintf(destring, "hanpin imengine %s F11 release, get F11 initial time:%d:,%d \n", __func__, F11_time.tv_sec, F11_time.tv_usec);
			g_writedebug("/home/debug.txt", destring);
        }
		else if(time.tv_sec-F11_time.tv_sec > 1)
		{
		}
        else if ((((time.tv_sec-F11_time.tv_sec)*1000000)+(time.tv_usec-F11_time.tv_usec)) < 200000) 
        {
            memset(destring, 0, 512);
            sprintf(destring, "hanpin imengine %s receive F11 release, too closer, drop, F11 time:%d:,%d\n", __func__,F11_time.tv_sec, F11_time.tv_usec);
            g_writedebug("//home//user//pphanpindebug.txt", destring);
            return false;
        }

        m_show = true;
        if(!m_helper_started)
        {
            memset(destring, 0, 512);
            sprintf(destring, "hanpin imengine %s receive F11, m_helper_started is false\n", __func__);
            g_writedebug("//home//user//pphanpindebug.txt", destring);
            m_focused = true;
            return false;
        }

		if(!m_show_string)
			m_show_string = true;
		else
			m_show_string = false;

		memset(destring, 0, 512);
		sprintf(destring, "hanpin imengine %s receive F11 send_helper_event SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER\n", __func__);
		g_writedebug("//home//user//pphanpindebug.txt", destring);

        g_get_current_time(&F11_time);
		memset(destring, 0, 512);
        sprintf(destring, "F11 time:%d:,%d \n", F11_time.tv_sec, F11_time.tv_usec);
        g_writedebug("//home//user//pphanpindebug.txt", destring);

        m_trans.clear ();
        m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
        m_trans.put_command (SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER);
        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
        m_focused = true;
        return false;
    }
*/
    if (!m_focused) return false;
    if (key.is_key_release ()) return false;

    KeyEvent newkey = key.map_to_layout (SCIM_KEYBOARD_Default);

    if(newkey.code == SCIM_KEY_BackSpace)
    {
		g_get_current_time(&bk_temp_time);
		memset(destring, 0, 512);
        sprintf(destring, "hanpin imengine %s receive BackSpace\n", __func__);
        g_writedebug("//home//user//pphanpindebug.txt", destring);
		if((0==BackSpace_time.tv_sec) && (0==BackSpace_time.tv_usec))
			g_get_current_time(&BackSpace_time);
		else if(bk_temp_time.tv_sec-BackSpace_time.tv_sec > 1)
		{
		}
		else if ((((bk_temp_time.tv_sec-BackSpace_time.tv_sec)*1000000)+(bk_temp_time.tv_usec-BackSpace_time.tv_usec)) < 110000)
		{
				memset(destring, 0, 512);
				sprintf(destring, "hanpin imengine %s receive BackSpace, too closer, drop\n", __func__);
				g_writedebug("//home//user//pphanpindebug.txt", destring);
				return true;
		}
		g_get_current_time(&BackSpace_time);
    }

    memset(destring, 0, 512);
    sprintf(destring, "hanpin imengine %s FindKeyMapIndex\n", __func__);
    g_writedebug("//home//user//pphanpindebug.txt", destring);
	
	keyindex = FindKeyMapIndex(key.code, hanpin_keymap, &b_keycase);
		
	if(key.mask == 0 || key.mask == SCIM_KEY_ShiftMask)
	{
	        //2010.4.21 vincent: modify space can send first word
		if(gbl_CandicateString.size()>0)
		{
		    if(key.code == SCIM_KEY_space)
		    {
			direct_send_word (gbl_CandicateString[0]);
			return true;
		    }
		}
		
		if(m_preedit_string.length () <= 0)
		{
			if(key.code == SCIM_KEY_Right || key.code == SCIM_KEY_Left || key.code == SCIM_KEY_Up || key.code == SCIM_KEY_Down ||
			key.code == SCIM_KEY_Page_Up || key.code == SCIM_KEY_Page_Down || key.code == SCIM_KEY_Home ||
			key.code == SCIM_KEY_End || key.code == SCIM_KEY_Insert || key.code == SCIM_KEY_space || key.code == SCIM_KEY_semicolon ||
			key.code == SCIM_KEY_quoteright || key.code ==SCIM_KEY_colon || key.code == SCIM_KEY_quotedbl || 
			key.code == SCIM_KEY_exclam || key.code == SCIM_KEY_asterisk || key.code == SCIM_KEY_question || key.code == SCIM_KEY_at ||
			key.code == SCIM_KEY_comma || key.code == SCIM_KEY_less || key.code == SCIM_KEY_period || key.code == SCIM_KEY_greater || 
			key.code == SCIM_KEY_minus || key.code == SCIM_KEY_underscore || key.code == SCIM_KEY_slash || key.code == SCIM_KEY_bar ||
			key.code == SCIM_KEY_Tab || key.code == SCIM_KEY_Return || key.code == SCIM_KEY_parenleft || key.code == SCIM_KEY_parenright || 
			key.code == SCIM_KEY_grave || key.code == SCIM_KEY_asciitilde ||  key.code == SCIM_KEY_backslash || key.code == SCIM_KEY_numbersign ||
			key.code == SCIM_KEY_1 || key.code == SCIM_KEY_2 || key.code == SCIM_KEY_3 || key.code == SCIM_KEY_4 || key.code == SCIM_KEY_5 ||
			key.code == SCIM_KEY_6 || key.code == SCIM_KEY_7 || key.code == SCIM_KEY_8 || key.code == SCIM_KEY_9 || key.code == SCIM_KEY_0 ||
			key.code == SCIM_KEY_Abelowdot || key.code == SCIM_KEY_percent || key.code == SCIM_KEY_asciicircum  || key.code == SCIM_KEY_ampersand ||
			key.code == SCIM_KEY_dollar || key.code == SCIM_KEY_EuroSign || key.code == SCIM_KEY_LiraSign || key.code == SCIM_KEY_bracketleft ||
			key.code == SCIM_KEY_bracketright || key.code == SCIM_KEY_braceleft || key.code == SCIM_KEY_braceright || key.code == SCIM_KEY_equal)
			{
				return false;
			}
			else if(key.code == SCIM_KEY_Control_L)
			{

				m_trans.clear();
				m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
				m_trans.put_command (SCIM_TRANS_CMD_FORWARD_KEY_EVENT);
#ifdef __ENABLE_HELPER_MODULE_
				send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
				return false;

			}
		}
		if (key.code == SCIM_KEY_BackSpace && key.mask == 0 && m_preedit_string.length () > 0) 
		{//刪除字根
			m_preedit_string.erase (m_preedit_string.length () - 1, 1);
			update_preedit_string (m_preedit_string);
			update_preedit_caret (m_preedit_string.length ());
			m_lookup_table.clear ();
			gbl_CandicateString.clear();
			hide_lookup_table ();
			memset(&gbl_preedit_wstring[m_preedit_string.length ()], 0, sizeof(wchar_t));
			if(m_preedit_string.length () == 0)
			{
				CimConfigure(NULL);
				//commit_string(pRootString);
			}
			else 
				CimConfigure(gbl_preedit_wstring);
			process_preedit_string ();
			if(pRootString != NULL)			
			{
				m_trans.clear();
				m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
				m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
			
				int strlen = wcslen(pRootString);
				gbl_PreeditString.clear();
				for(i = 0;i < strlen; i++)
				{
					gbl_PreeditString.push_back(pRootString[i]);
				}
				m_trans.put_data (gbl_PreeditString);
#ifdef __ENABLE_HELPER_MODULE_
				send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
			}
			return true;
		}
		else if(key.code == SCIM_KEY_BackSpace && m_preedit_string.length() == 0)
		{
			//commit_string(L"NULL");
			forward_key_event(key);
			return false;
		}
		
		if(pRootString != NULL)
		{
			if(keyindex >= 0 )
			{//在字根表內
				if(hanpin_keymap[keyindex].m_keywchar1 != NULL)
				{//有字根的
					//commit_string(L"\rkey:");
					wchar_t pwtemp;
					bool b_find = false;
					int root_strlen = wcslen(pRootString);
					
					for(int idx = 0; idx < root_strlen; idx++)
					{
						pwtemp = pRootString[idx];
						//g_writedebug("./home/compare.txt", &pwtemp, wcslen(&pwtemp));
						if(wcCompareTo(pwtemp, hanpin_keymap[keyindex].m_keywchar1[0], true) == 0)
						{
							b_find = true;
							break;
						}
					}
					if(!b_find)
					{
						return true;
					}

					//g_writedebug("./home/finish.txt", "finish");
					if (m_preedit_string.length () == 0 && m_lookup_table.number_of_candidates () <= 0)
						show_preedit_string ();
					//顯示字根
					if(b_keycase)
					{
						m_preedit_string.push_back((gunichar)hanpin_keymap[keyindex].m_keywchar2[0]);
						wcscat(gbl_preedit_wstring, hanpin_keymap[keyindex].m_keywchar2);
					}
					else
					{
						m_preedit_string.push_back((gunichar)hanpin_keymap[keyindex].m_keywchar1[0]);
						wcscat(gbl_preedit_wstring, hanpin_keymap[keyindex].m_keywchar1);
					}
					//g_writedebug("./home/update.txt", "finish");
					update_preedit_string (m_preedit_string);
					update_preedit_caret (m_preedit_string.length ());
					CimConfigure(gbl_preedit_wstring);
					process_preedit_string ();
					m_trans.clear();
					m_trans.put_command (SCIM_TRANS_CMD_REQUEST);

					if(pRootString != NULL)
					{
						m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
						int strlen = wcslen(pRootString);
						gbl_PreeditString.clear();
						for(i = 0;i < strlen; i++)
						{
							gbl_PreeditString.push_back(pRootString[i]);
						}
						m_trans.put_data (gbl_PreeditString);
					}
					else
					{
						m_trans.put_command (SCIM_TRANS_CMD_SHOW_LOOKUP_TABLE);
					}
#ifdef __ENABLE_HELPER_MODULE_
					send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
				}
			}
		}
		if(m_lookup_table.number_of_candidates() > 0)
		{
			switch(key.code)		
			{
			case SCIM_KEY_1:
				if(m_lookup_table.get_current_page_size () >= 1)
				select_candidate(0);
				break;
			case SCIM_KEY_2:
				if(m_lookup_table.get_current_page_size () >= 2)
				select_candidate(1);
				break;
			case SCIM_KEY_3:
				if(m_lookup_table.get_current_page_size () >= 3)
				select_candidate(2);
				break;
			case SCIM_KEY_4:
				if(m_lookup_table.get_current_page_size () >= 4)
				select_candidate(3);
				break;
			case SCIM_KEY_5:
				if(m_lookup_table.get_current_page_size () >= 5)
				select_candidate(4);
				break;
			case SCIM_KEY_Left:
				lookup_table_page_up();
				break;
			case SCIM_KEY_Right:
				lookup_table_page_down();
				break;
			}
			return true;
		}
	}
	else if(key.mask == SCIM_KEY_ControlMask)
	{
		if(key.code == SCIM_KEY_c)
			g_writedebug("//home//user//pphanpindebug.txt", "key.code = SCIM_KEY_c and key.mask = SCIM_KEY_ControlMask\n");
		if(key.code == SCIM_KEY_v)
			g_writedebug("//home//user//pphanpindebug.txt", "key.code = SCIM_KEY_v and key.mask = SCIM_KEY_ControlMask\n");
		CimConfigure(NULL);
		m_trans.clear();
		m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
		m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
		int strlen = 0;
		if(pRootString != 0)
		{
			strlen = wcslen(pRootString);
		}
		gbl_PreeditString.clear();
		for(i = 0;i < strlen; i++)
		{
			gbl_PreeditString.push_back(pRootString[i]);
		}
		m_trans.put_data (gbl_PreeditString);
#ifdef __ENABLE_HELPER_MODULE_		
		send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
		return false;
	}
return true;
}

/*		else if( keyindex > 0 && m_lookup_table.number_of_candidates () == 0 && m_preedit_string.length () == 0)
		{       
			//char buf_out[256] = "";
			//GdkWChar wbuf[256];
			//sprintf(buf_out, "page down:%d", m_preedit_string.length ());
			//gdk_mbstowcs(wbuf, buf_out, 128);
			//commit_string((wchar_t*)wbuf);
			//m_trans.clear ();
			//m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
			//m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
			//m_trans.put_data (key);
 
			//send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
			//commit_string(L"len = 0");
			return false;
		}
		else if(m_lookup_table.number_of_candidates () > 0)
		{			
			return true;
		}		
		*/ 

void
PPHanpinInstance::process_helper_event (const String &helper_uuid, const Transaction &trans)
{
    char destring[512] = "";
    sprintf(destring, "hanpin imengine %s\n", __func__);
    g_writedebug("//home//user//pphanpindebug.txt", destring);
    std::cerr << "PPHanpinInstance::process_helper_event ()\n";

    TransactionReader reader (trans);

    if (helper_uuid == SCIM_PPHANPIN_HELPER_UUID) 
	{
        int cmd;
        if (reader.get_command (cmd) && cmd == SCIM_TRANS_CMD_REQUEST && 
            reader.get_command (cmd)) 
		{
            if (cmd == SCIM_TRANS_CMD_START_HELPER) 
			{
				memset(destring, 0, 512);
                sprintf(destring, "hanpin imengine %s read SCIM_TRANS_CMD_START_HELPER, set m_helper_started to true\n", __func__);
                g_writedebug("//home//user//pphanpindebug.txt", destring);
                m_helper_started = true;
                if (m_focused) 
				{
					memset(destring, 0, 512);
                    sprintf(destring, "hanpin imengine %s send_helper_event SCIM_TRANS_CMD_FOCUS_IN\n", __func__);
                    g_writedebug("//home//user//pphanpindebug.txt", destring);
                    m_trans.clear ();
                    m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
                    m_trans.put_command (SCIM_TRANS_CMD_FOCUS_IN);
                    send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
					
					if(m_show)
                    {
                        memset(destring, 0, 512);
                        sprintf(destring, "hanpin imengine %s F11 send_helper_event SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER\n", __func__);
                        g_writedebug("//home//user//pphanpindebug.txt", destring);
                        m_trans.clear ();
                        m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
                        m_trans.put_command (SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER);
                        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
                    }
                }

				memset(destring, 0, 512);
                sprintf(destring, "hanpin imengine %s send_helper_event SCIM_TRANS_CMD_SET_CONFIG_STRING\n", __func__);
                g_writedebug("//home//user//pphanpindebug.txt", destring);
				m_trans.clear ();
                m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
                m_trans.put_command (SCIM_TRANS_CMD_SET_CONFIG_STRING);
                WideString wsdialog = utf8_mbstowcs (_("about.png"));
                m_trans.put_data(wsdialog);
                send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);

				//////////////////////////////////////////////////////////
				hide_preedit_string ();
				hide_lookup_table ();
				if(pRootString != NULL)
				{
					delete [] pRootString;
					pRootString = NULL;
				}
				m_lookup_table.clear();
				m_preedit_string.clear();
				memset(gbl_preedit_wstring, 0, sizeof(gbl_preedit_wstring));
				CimConfigure(NULL);
		/*		if(pRootString)
				{
					commit_string(pRootString);
					commit_string(L"bopomo imengine start configure\n");
				}*/
				hide_lookup_table ();
				hide_preedit_string ();
				clear_preedit_string();
				g_writedebug("//home//user//pphanpindebug.txt", "hanpin keyboard imengine process SCIM_TRANS_CMD_START_HELPER\n");
				m_trans.clear();
				m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
				m_trans.put_command (SCIM_TRANS_CMD_HIDE_LOOKUP_TABLE);
#ifdef __ENABLE_HELPER_MODULE_
				send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
            } 
			else if (cmd == SCIM_TRANS_CMD_DELETE_SURROUNDING_TEXT) 
			{
                delete_surrounding_text (-1,2);
                m_trans.clear ();
                m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
                WideString text;
                int cursor;
 
                get_surrounding_text (text, cursor);
                m_trans.put_command (SCIM_TRANS_CMD_GET_SURROUNDING_TEXT);
                m_trans.put_data (text);
#ifdef __ENABLE_HELPER_MODULE_
                send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
            }
			else if (cmd == SCIM_TRANS_CMD_FOCUS_OUT) 
			{
                memset(destring, 0, 512);
                sprintf(destring, "hanpin imengine %s read SCIM_TRANS_CMD_FOCUS_OUT, call focus_out\n", __func__);
                g_writedebug("//home//user//pphanpindebug.txt", destring);
                focus_out ();
            }
			/*else if (cmd == SCIM_TRANS_CMD_HIDE_PREEDIT_STRING) {
			if(pRootString != NULL)
			{
				delete [] pRootString;
				pRootString = NULL;
			}
			m_lookup_table.clear();
			m_preedit_string.clear();
			memset(gbl_preedit_wstring, 0, sizeof(gbl_preedit_wstring));
			CimConfigure(NULL);
			hide_lookup_table ();
			hide_preedit_string ();
			clear_preedit_string();
			g_writedebug("./home/debug.txt", "hanpin imengine receive SCIM_TRANS_CMD_HIDE_PREEDIT_STRING\n");
	    }*/
        }
    }
}

String
PPHanpinInstance::get_multibyte_string (const WideString & preedit)
{
	String str;
	char ch = 0;

	if (preedit.length () == 0)
		return str;

	for (unsigned int i=0; i<preedit.length (); ++i) {
		if (i % 2 == 0)
			ch = (char) ascii_to_hex ((int) preedit [i]) & 0x0f;
		else {
			ch = (ch << 4) | ((char) ascii_to_hex ((int) preedit [i]) & 0x0f);
			str.push_back (ch);
			ch = 0;
		}
	}

	if (ch != 0)
		str.push_back (ch);

	return str;
}

int
PPHanpinInstance::create_lookup_table (int start)
{
	std::vector<WideString> labels;	
	WideString trail;
	ucs4_t ucs_code;		

	gunichar *ucs4string = NULL;
	gunichar dest_ucs4;
	char utf8_char[32] = "";
	int iconvert= 0;
	GError *gerror;	
	//char buf_out[256] = "";
	int i = 0;
	//GdkWChar wbuf[256];
	int ilabel = 0;

	m_lookup_table.clear ();
	Candidate_count = gbl_CandicateString.size();
	trail.push_back (0);

	for (i=start; i< 100 && i < Candidate_count; ++i) 	
	{			
		ilabel = i % 6 ;
		ilabel = ilabel + 1;
		trail [0] = (ucs4_t) hex_to_ascii (ilabel);
		labels.push_back (trail);
		m_lookup_table.append_candidate (gbl_CandicateString[i]);
	}	

	//sprintf(buf_out, "labels size:%d", labels.size());
	//gdk_mbstowcs(wbuf, buf_out, 128);
	//commit_string((wchar_t*)wbuf);
	m_lookup_table.set_page_size (labels.size ());
	m_lookup_table.set_candidate_labels (labels);
	m_lookup_table.set_page_size(5);
	m_lookup_table.fix_page_size(true);

	return labels.size ();
}

void
PPHanpinInstance::process_preedit_string ()
{
	if (m_preedit_string.length () == 0) {
		hide_preedit_string ();
		hide_lookup_table ();
		return;
	}
	
	if (create_lookup_table (0) > 0) 	
	{		
		update_lookup_table (m_lookup_table);
	}	
	else if (m_lookup_table.number_of_candidates ())
	{
		m_lookup_table.clear ();
	}
	

	if (m_lookup_table.number_of_candidates () )
	{
		m_lookup_table.page_down ();
		update_lookup_table (m_lookup_table);
		show_lookup_table ();
		m_lookup_table.page_up ();
		update_lookup_table (m_lookup_table);
		show_lookup_table ();
	}
	else
		hide_lookup_table ();
}

ucs4_t
PPHanpinInstance::get_unicode_value (const WideString &preedit)
{
	ucs4_t code = 0;
	for (unsigned int i=0; i<preedit.length (); ++i) {
		code = (code << 4) | (ascii_to_hex ((int) preedit [i]) & 0x0f);
	}
	return code;
}


void PPHanpinInstance::direct_send_word (wchar_t word)
{
      WideString wstr;
      wstr.clear();
      wstr.push_back(word);
      commit_string(wstr);

      //clear imengine
      m_lookup_table.clear();
      m_preedit_string.clear();
      memset(gbl_preedit_wstring, 0, 10 * sizeof(wchar_t));
      gbl_CandicateString.clear();
      CimConfigure(NULL);
      hide_lookup_table ();
      hide_preedit_string ();
      clear_preedit_string();
      
/*	
      //clear helper
      WideString str;
      str.clear();
      m_trans.clear();
      m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
      m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
      m_trans.put_data (str);
      send_helper_event (SCIM_PPTSANGJEI_HELPER_UUID, m_trans);
      update_helper_preedit_string (m_preedit_string);
      update_helper_aux_string (str);      
*/
}

void
PPHanpinInstance::reset ()
{
}


static GTimeVal focus_in_time;

void
PPHanpinInstance::focus_in ()
{
    std::cerr << "PPHanpinInstance::focus_in\n";
    m_focused = true;
    GTimeVal time;

    g_get_current_time(&time);
    if ((0==focus_in_time.tv_sec) && (0==focus_in_time.tv_usec))
    {
         g_get_current_time(&focus_in_time);
    }
    else if(time.tv_sec-focus_in_time.tv_sec > 1)
    {
    }
    else if (((((time.tv_sec-focus_in_time.tv_sec)*1000000)+(time.tv_usec-focus_in_time.tv_usec)) < 500000) && !m_helper_started)
    {
        return;
    }
    g_get_current_time(&focus_in_time);
    if (m_helper_started) 
    {
        m_trans.clear ();
        m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
        m_trans.put_command (SCIM_TRANS_CMD_FOCUS_IN);
        std::cerr << "  send_helper_event (" << SCIM_PPHANPIN_HELPER_UUID ")\n";

#ifdef __ENABLE_HELPER_MODULE_
        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif

	    if (m_preedit_string.length () > 0) 
        {
		    update_preedit_string (m_preedit_string);
		    update_preedit_caret (m_preedit_string.length ());
		    show_preedit_string ();
		    if (m_lookup_table.number_of_candidates ()) 
            {
			    update_lookup_table (m_lookup_table);
			    show_lookup_table ();
		    }
		    memset(gbl_preedit_wstring, 0, sizeof(gbl_preedit_wstring));
		    int i = 0;
		    for(i=0; i<m_preedit_string.length (); i++)
		    {
			    gbl_preedit_wstring[i] = m_preedit_string[i];
		    }
		    CimConfigure(gbl_preedit_wstring);
		    m_trans.clear();
		    m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
		    m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
		    if(pRootString != NULL)
		    {
			    int string_len = wcslen(pRootString);
			    gbl_PreeditString.clear();
			    for(i = 0;i < string_len; i++)
			    {
				    gbl_PreeditString.push_back((ucs4_t)pRootString[i]);
			    }
			    m_trans.put_data (gbl_PreeditString);
#ifdef __ENABLE_HELPER_MODULE_
			    send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
		    }

		    g_writedebug("//home//user//pphanpindebug.txt", "hanpin imengine m_preedit_string.length > 0\n");
	    }
	    else
	    {
		    CimConfigure(NULL);
		    m_trans.clear();
		    m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
		    m_trans.put_command (SCIM_TRANS_CMD_PROCESS_KEY_EVENT);
		    int strlen = 0;
		    if(pRootString != NULL)
		    {
			    strlen = wcslen(pRootString);
		    }
		    gbl_PreeditString.clear();
		    for(int i = 0;i < strlen; i++)
		    {
			    gbl_PreeditString.push_back(pRootString[i]);
		    }
		    m_trans.put_data (gbl_PreeditString);
#ifdef __ENABLE_HELPER_MODULE_
		    send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
		    g_writedebug("//home//user//pphanpindebug.txt", "hanpin imengine m_preedit_string.length <= 0\n");
	    }
    	g_writedebug("//home//user//pphanpindebug.txt", "hanpin imengine started.\n");
    }
    else 
    {
        std::cerr << "  start_helper (" << SCIM_PPHANPIN_HELPER_UUID ")\n";
    	g_writedebug("//home//user//pphanpindebug.txt", "hanpin imengine call start_helper() start.\n");
#ifdef __ENABLE_HELPER_MODULE_
        start_helper (SCIM_PPHANPIN_HELPER_UUID);
#endif
        if(cim.LoadCTB("./usr/share/scim/pphanpin/cim/hanin.ctb") &&        
		cim.LoadPriorities("./usr/share/scim/pphanpin/cim/priority.ctp"))
		{
		//commit_string(L"load success");
		}
		else
		{
			commit_string(L"load failed");	
		}
		CimConfigure(NULL);
		gbl_CandicateString.clear();
		gbl_PreeditString.clear();
		Candidate_count = 0;
		memset(gbl_preedit_wstring, 0, 10 * sizeof(wchar_t));
		g_writedebug("//home//user//pphanpindebug.txt", "hanpin imengine start_helper() end.\n");
		m_trans.clear();
		m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
		m_trans.put_command (SCIM_TRANS_CMD_HIDE_LOOKUP_TABLE);

#ifdef __ENABLE_HELPER_MODULE_
        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
		
	}
}

void
PPHanpinInstance::focus_out ()
{
    char destring[512] = "";
    sprintf(destring, "hanpin imengine %s\n", __func__);
    g_writedebug("//home//user//pphanpindebug.txt", destring);

    std::cerr << "PPHanpinInstance::focus_out\n";

    m_focused = false;

    if (m_helper_started) 
	{
		memset(destring, 0, 512);
        sprintf(destring, "hanpin imengine %s send_helper_event SCIM_TRANS_CMD_FOCUS_OUT\n", __func__);
        g_writedebug("//home//user//pphanpindebug.txt", destring);
        m_trans.clear ();
        m_trans.put_command (SCIM_TRANS_CMD_REQUEST);
        m_trans.put_command (SCIM_TRANS_CMD_FOCUS_OUT);
        std::cerr << "  send_helper_event (" << SCIM_PPHANPIN_HELPER_UUID ")\n";
#ifdef __ENABLE_HELPER_MODULE_
        send_helper_event (SCIM_PPHANPIN_HELPER_UUID, m_trans);
#endif
		m_show = !m_show;

		hide_preedit_string ();
		hide_lookup_table ();
		if(pRootString != NULL)
		{
			delete [] pRootString;
			pRootString = NULL;
		}
		m_lookup_table.clear();
		m_preedit_string.clear();
		memset(gbl_preedit_wstring, 0, sizeof(gbl_preedit_wstring));
		CimConfigure(NULL);
		hide_lookup_table ();
		hide_preedit_string ();
		clear_preedit_string();
		cim.SavePriorities("./usr/share/scim/pphanpin/cim/priority.ctp");
    }
}

/*
vi:ts=4:nowrap:ai:expandtab
*/
