/** @file scim_pphanpin_helper.cpp
 * implementation of Shouxie Helper module.
 */

/*
 * 
 * Copyright (c) 2006 Yang Hong <yanghong@ccoss.com.cn> 
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: scim_pphanpin_helper.cpp,v 1.3 2005/01/15 11:34:03 suzhe Exp $
 */

#include <string.h>
#include <gdk/gdkx.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Xresource.h>
#include <X11/keysym.h>
#include <signal.h>
#include <sys/time.h>

/* Only matchbox support such window now */
#define SUPPORTED_WM "matchbox"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define Uses_SCIM_CONFIG_BASE
#define Uses_SCIM_CONFIG_PATH
#define Uses_SCIM_MODULE
#define Uses_SCIM_IMENGINE_MODULE
#define Uses_SCIM_HELPER
#define Uses_STL_MAP

#define L_TAIWAN	2000
#define L_CHINA		2001
#define L_ENGLISH	2002

#define PIC_INFO_ITALY_PATH    "./usr/share/scim/pphanpin/pic/about_it.png"
#define PIC_INFO_ENG_PATH    "./usr/share/scim/pphanpin/pic/about_eng.png"
#define PIC_INFO_CLOSE_PATH "./usr/share/scim/pphanpin/pic/about_close_over.png"

#include "scim.h"
#include "scim_pphanpin.h"
#include "scim_pphanpin_helper.h"
#include "scim_hanpin.h"
#include "libsnd.h"

#include "PPKeybd.h"
#include "PPCaption.h"
#include "PPInfownd.h"

#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>


#include "ppscim_ctrl_def.h"


#define scim_module_init pphanpin_helper_LTX_scim_module_init
#define scim_module_exit pphanpin_helper_LTX_scim_module_exit
#define scim_helper_module_number_of_helpers pphanpin_helper_LTX_scim_helper_module_number_of_helpers
#define scim_helper_module_get_helper_info pphanpin_helper_LTX_scim_helper_module_get_helper_info
#define scim_helper_module_run_helper pphanpin_helper_LTX_scim_helper_module_run_helper

//#define __DUMP_DEBUG_MESSAGE__

using namespace scim;
//gboolean b_visible;
//GtkWidget *gbl_areaP = 0;
GdkPixbuf *gbl_gdkPixImgP = 0;
GdkPixbuf *gbl_controlsImgP1 = 0;
GdkPixbuf *gbl_controlsImgP2 = 0;
GdkPixbuf *gbl_controlsImgP3 = 0;
GdkPixbuf *gbl_controlsImgP4 = 0;
GdkPixbuf *gbl_controlsDisImgP1 = 0;
GdkPixbuf *gbl_controlsDisImgP2 = 0;
GdkPixbuf *gbl_closeImgP = 0;
GdkPixbuf *gbl_delImgP = 0;
GdkPixbuf *gbl_enterImgP = 0;
GdkPixbuf *gbl_tabImgP = 0;
GdkPixbuf *gbl_ctrlImgPU = 0;
GdkPixbuf *gbl_ctrlImgPD = 0;
GdkPixbuf *gbl_capsImgPL = 0;
GdkPixbuf *gbl_capsImgPU = 0;
GdkPixbuf *gbl_spaceImgP = 0;
GdkPixbuf *gbl_abcImgPD = 0;
GdkPixbuf *gbl_pixbufImage = 0;
GtkWidget *gbl_popup = false;
GtkWidget *gbl_popareaP = 0;
GdkRegion* gbl_wndRegion = NULL;

extern GtkWidget *gbl_infoWindow;
//GtkWidget *gbl_infoDrawArea;
//GdkPixbuf *gbl_infowindowImg;
//GdkPixbuf *gbl_infoCloseImg;
GdkPixbuf *gbl_infoImgP = 0;
GdkPixbuf *gbl_press_infoImgP = 0;
GdkPixbuf *gbl_numImgPD = 0;

PPCtlInfo gbl_controls[128];
PPCtlInfo gbl_sym_controls[128];
//PPKeyMap gbl_hanpin_keymap[128];
//PPKeyMap gbl_sym_keymap[128];
int gbl_ctl_count = 0;
int gbl_symctl_count = 0;
int lastCPControl = -1;
int lastPSControl = -1;
gboolean gbl_hanpin_bCAPS = false;
gboolean gbl_hanpin_bCTRL = false;
gboolean gbl_bNUMBER = false;
int gbl_key_number = 0;
int gbl_symkey_number = 0;
int gbl_active_number = 0;
bool gbl_b_root = false;
bool gbl_b_focus = false;
gboolean gbl_bPress = false;
guint focus_timerid = 0;
guint backspace_timerid = 0;
//bool gbl_binfoshow = false;
bool gbl_bAttatch = false;
//int gbl_info_stat = PPOD_CTL_STATE_0;
extern int gbl_language;
int gbl_backspace_times = 0;
int gbl_window_x = 0;
int gbl_window_y = 0;
///////////////////////standard version////////////////////
#define PPSTATE_NONE			0
#define PPSTATE_CAPTION_AREA	1
#define PPSTATE_KEYBD_AREA		2
#define PPSTATE_EDITINFO_AREA	3

GdkPixbuf *gbl_KeybdPixMaps[10];
PPCaption gbl_PPCaption;
PPKeyboard gbl_PPKeyboard;
int gbl_State = PPSTATE_NONE;
bool gbl_bGrab = false;
bool g_minwindowmode = false; //O_b̤p

////////////////////////////////////////////////////////////

//wchar_t wRootChar[5] = L"";
WideString gbl_RootString;
wchar_t RootString[MAX_WORDROOT_LEN] = L"";


static HelperInfo __helper_info (String (SCIM_PPHANPIN_HELPER_UUID),
                                 String (_("PINYIN Pad")),
                                 String (""),
                                 String (_("A hanpin keyboard helper.")),
                                 SCIM_HELPER_AUTO_RESTART|SCIM_HELPER_NEED_SCREEN_INFO|SCIM_HELPER_NEED_SPOT_LOCATION_INFO);

static void run (const String &display);
void forward_key_button_clicked (GtkWidget *widget, gpointer data);
//static void set_window_as_input_pad (GtkWidget *widget);
//void ShowPopupWindow(char *str_path, int posX, int posY);
//void HidePopupWindow();
//gboolean CreatePopupWindow(char *str_path, int posX, int posY);
//void DestroyPopupWindow();
//void Timer_Response(int);
//void RePaintScreen(int iRpBackground,int iAutoXor);
//bool CimConfigure(wchar_t *pRootChar);

//extern GdkPixbuf* CaptureScreenEx(gint x, gint y, gint nWidth, gint nHeight);
//extern guchar* GetPixel (GdkPixbuf *pixbuf, int x, int y);

//extern int init_hanpinkeymap(PPKeyMap *keymap);
//extern int init_hanpin_controls();
//extern int init_sym_keymap();
//extern int init_sym_controls();

//void ConfigureKeyboard(wchar_t * pRootString, bool b_ctrl);

bool g_writedebug(char * pFilename, char *OutputString);
gboolean hide_keyboard(gpointer userdata);
//gboolean Send_Backspace_KeyEvent(gpointer userdata);
//void set_backspace_timer();
//void stop_backspace_timer();
//void ShowInfoWindow();
//gboolean FindInSenseXY(gdouble x,gdouble y);
///void DestroyInfoWindow();
gboolean on_button_release_event( GtkWidget *widget, GdkEventMotion *event );
//bool GrabMainPointer(GtkWidget *window);
//bool UnGrabMainPointer();
void send_focusout_to_imengine();
void OutputDebugMessage(char * pmsg);
void WOutputDebugMessage(wchar_t * pstr);
void UpdateRapaint();
//Module Interface
extern "C" {
    void scim_module_init (void)
    {
        bindtextdomain (GETTEXT_PACKAGE, SCIM_PPHANPIN_LOCALEDIR);
        bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    }

    void scim_module_exit (void)
    {
    }

    unsigned int scim_helper_module_number_of_helpers (void)
    {
        return 1;
    }

    bool scim_helper_module_get_helper_info (unsigned int idx, HelperInfo &info)
    {
        if (idx == 0) {
            info = __helper_info; 
            return true;
        }
        return false;
    }

    void scim_helper_module_run_helper (const String &uuid, const ConfigPointer &config, const String &display)
    {
        SCIM_DEBUG_MAIN(1) << "pphanpin_LTX_scim_helper_module_run_helper ()\n";

        if (uuid == SCIM_PPHANPIN_HELPER_UUID) {
            run (display);
        }

        SCIM_DEBUG_MAIN(1) << "exit pphanpin_LTX_scim_helper_module_run_helper ()\n";
    }
}

GtkWidget *gbl_win;

//GtkWidget *gbl_win = 0;
GtkWidget *gbl_areaP = 0;

static GtkWidget *cand_button [SCIM_PPHANPIN_CANDIDATE_NUM];
static gchar * char_converted [SCIM_PPHANPIN_CANDIDATE_NUM];
static guint	writing_done_timeout = 0;
static gboolean do_writing_done_timeout = FALSE;
static gboolean do_auto_select_first_cand = FALSE;

static int        cur_ic = -1;
static String     cur_uuid;
static HelperAgent  *m_agent;

// Shouxie Pane configure
static int	m_use_full_width_symbol = TRUE;
static int	scim_pphanpin_rec_engine_inited = 0;

/*
GtkWidget *input_pad_window_new (void)
{
	GtkWidget *window;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_accept_focus (GTK_WINDOW (window), FALSE);
	gtk_widget_realize (window);

	set_window_as_input_pad (window);
	
	return window;
}
*/
static void slot_exit (const HelperAgent *, int ic, const String &uuid)
{
	char destring[512] = "";
	sprintf(destring, "pphanpin helper %s begin, call m_agent->hide_pad\n", __func__);
    g_writedebug("//home//user//debug.txt", destring);

	std::cout << "slot_exit (" << ic << ", " << uuid << ")\n";
	gtk_widget_hide_all (gbl_win);
	//m_agent->hide_pad(SCIM_PPHANPIN_IMENGINE_UUID);
	//g_writedebug("./home/hanpin_exit.txt", "exit");
	//ConfigureKeyboard(NULL, false);
	/*
	if(focus_timerid != 0)
	{
		if(!g_source_remove(focus_timerid))
			g_message("hanpin g_source_remove() error");
		focus_timerid = 0;
	}

	if(backspace_timerid != 0)
    {
        	if(!g_source_remove(backspace_timerid))
            		g_message("hanpin helper slot_exit backspace_timerid g_source_remove() error");
        	backspace_timerid = 0;
    }
	*/
/*
	if(gbl_infoCloseImg != 0)
	{
		g_object_unref(gbl_infoCloseImg);
		gbl_infoCloseImg = 0;
	}
	if(gbl_infowindowImg != 0)
	{
		g_object_unref(gbl_infowindowImg);
		gbl_infowindowImg = 0;
	}
	if(gbl_press_infoImgP != 0)
	{
		g_object_unref(gbl_press_infoImgP);
		gbl_press_infoImgP = 0;
	}
*/
	if(gbl_controlsDisImgP1 != 0)
	{
		g_object_unref(gbl_controlsDisImgP1);
		gbl_controlsDisImgP1 = 0;
	}
	if(gbl_controlsDisImgP2 != 0)
	{
		g_object_unref(gbl_controlsDisImgP2);
		gbl_controlsDisImgP2 = 0;
	}
	if(gbl_infoImgP != 0)
	{
		g_object_unref(gbl_infoImgP);
		gbl_infoImgP = 0;
	}
/*
	if(gbl_infoDrawArea != 0)
	{
		gtk_widget_destroy(gbl_infoDrawArea);
		gbl_infoDrawArea = NULL;
	}

	if(gbl_infoWindow != 0)
	{
		gtk_widget_destroy(gbl_infoWindow);
		gbl_infoWindow = NULL;
	}
*/
	if(gbl_gdkPixImgP != 0)
	{
		g_object_unref(gbl_gdkPixImgP);
		gbl_gdkPixImgP = 0;
	}
	if(gbl_controlsImgP1 != 0)
	{
		g_object_unref(gbl_controlsImgP1);
		gbl_controlsImgP1 = 0;
	}
	if(gbl_controlsImgP2 != 0)
	{
		g_object_unref(gbl_controlsImgP2);
		gbl_controlsImgP2 = 0;
	}
	if(gbl_controlsImgP3 != 0)
	{
		g_object_unref(gbl_controlsImgP3);
		gbl_controlsImgP3 = 0;
	}
	if(gbl_controlsImgP4 != 0)
	{
		g_object_unref(gbl_controlsImgP4);
		gbl_controlsImgP4 = 0;
	}
	if(gbl_closeImgP != 0)
	{
		g_object_unref(gbl_closeImgP);
		gbl_closeImgP = 0;
	}
	if(gbl_abcImgPD != 0)
	{
		g_object_unref(gbl_abcImgPD);
		gbl_abcImgPD = 0;
	}
	if(gbl_delImgP != 0)
	{
		g_object_unref(gbl_delImgP);
		gbl_delImgP = 0;
	}
	if(gbl_enterImgP != 0)
	{
		g_object_unref(gbl_enterImgP);
		gbl_enterImgP = 0;
	}
	if(gbl_tabImgP != 0)
	{
		g_object_unref(gbl_tabImgP);
		gbl_tabImgP = 0;
	}
	if(gbl_ctrlImgPU != 0)
	{
		g_object_unref(gbl_ctrlImgPU);
		gbl_ctrlImgPU = 0;
	}
	if(gbl_ctrlImgPD != 0)
	{
		g_object_unref(gbl_ctrlImgPD);
		gbl_ctrlImgPD = 0;
	}
	if(gbl_capsImgPL != 0)
	{
		g_object_unref(gbl_capsImgPL);
		gbl_capsImgPL = 0;
	}
	if(gbl_capsImgPU != 0)
	{
		g_object_unref(gbl_capsImgPU);
		gbl_capsImgPU = 0;
	}
	if(gbl_spaceImgP != 0)
	{
		g_object_unref(gbl_spaceImgP);
		gbl_spaceImgP = 0;
	}
	if(gbl_numImgPD != 0)
	{
		g_object_unref(gbl_numImgPD);
		gbl_numImgPD = 0;
	}
	if(gbl_pixbufImage != 0)
	{
		g_object_unref(gbl_pixbufImage);
		gbl_pixbufImage = 0;
	}
	if(gbl_areaP !=0)
	{
		gtk_widget_destroy(gbl_areaP);
		gbl_areaP = NULL;
	}
	if(gbl_win !=0)
	{
		gtk_widget_destroy(gbl_win);
		gbl_win = NULL;
	}
	if(gbl_popup != 0)
	{
		gtk_widget_destroy(gbl_popup);
		gbl_popup = NULL;
	}
	if(gbl_popareaP != 0)
	{
		gtk_widget_destroy(gbl_popareaP);
		gbl_popareaP = NULL;
	}
	if(gbl_wndRegion != 0)
	{
		gdk_region_destroy(gbl_wndRegion);
		gbl_wndRegion = NULL;
	}
	gtk_main_quit ();
	memset(destring, 0, 512);
	sprintf(destring, "pphanpin helper %s exit\n", __func__);
   	g_writedebug("//home//user//pphanpindebug.txt", destring);
}

static void slot_attach_input_context (const HelperAgent *agent, int ic, const String &uuid)
{
	std::cout << "slot_attach_input_context (" << ic << ", " << uuid << ")\n";

    // Inform the focused IMEngineInstance (which starts this helper) that this helper
    // is started successfully.
    g_writedebug("//home//user//pphanpindebug.txt", "hanpin helper send SCIM_TRANS_CMD_START_HELPER\n");
    Transaction trans;
    trans.put_command (SCIM_TRANS_CMD_REQUEST);
    trans.put_command (SCIM_TRANS_CMD_START_HELPER);
    agent->send_imengine_event (ic, uuid, trans);
    gbl_bAttatch = true;
}

static void slot_detach_input_context (const HelperAgent *agent, int ic, const String &uuid)
{
	std::cout << "slot_detach_input_context (" << ic << ", " << uuid << ")\n";
}

static void slot_update_screen (const HelperAgent *agent, int ic, const String &uuid, int screen)
{
	char destring[512] = "";
	std::cout << "slot_update_screen (" << ic << ", " << uuid << ", " << screen << ")\n";

    if (gdk_display_get_n_screens (gdk_display_get_default ()) > screen) {
        GdkScreen *scr = gdk_display_get_screen (gdk_display_get_default (), screen);
        if (scr)
            gtk_window_set_screen (GTK_WINDOW (gbl_win), scr);
    }

    if(!gbl_bAttatch)
    {
        memset(destring, 0, 512); 
        sprintf(destring, "hapin helper %s send_imengine_event SCIM_TRANS_CMD_START_HELPER\n", __func__);
        g_writedebug("//home//user//pphanpindebug.txt", destring);
        Transaction trans;
        trans.put_command (SCIM_TRANS_CMD_REQUEST);
        trans.put_command (SCIM_TRANS_CMD_START_HELPER);
        agent->send_imengine_event (ic, uuid, trans);
        gbl_bAttatch = true;
    }
}

static void slot_update_spot_location (const HelperAgent *, int ic, const String &uuid, int x, int y)
{
	return;
}

static void slot_process_imengine_event (const HelperAgent *, int ic, const String &uuid, const Transaction &trans)
{
	std::cout << "slot_process_imengine_event (" << ic << ", " << uuid << ")\n";

    if (uuid == SCIM_PPHANPIN_IMENGINE_UUID) 
	{
        TransactionReader reader (trans);
        int cmd;
        KeyEvent key;
        WideString wstr;
		char destring[512] = "";

        if (reader.get_command (cmd) && cmd == SCIM_TRANS_CMD_REQUEST) 
		{
			while (reader.get_command (cmd)) 
			{
				switch (cmd) 
				{
				case SCIM_TRANS_CMD_PROCESS_KEY_EVENT:
				{
					reader.get_data(gbl_RootString);
					int strlen = gbl_RootString.size();

					for(int i = 0; i < strlen ; i++)
					{                        	
						RootString[i] = (wchar_t)gbl_RootString[i];
					}			
					//g_writedebug("./home/helper.txt", RootString);
					RootString[strlen] = L'\0';

					gbl_active_number = 0;
					if(strlen == DEFAULT_ROOT_NUMBER)
						gbl_b_root = false;
					else
						gbl_b_root = true;
				
					gbl_PPKeyboard.ConfigureKB(RootString);
					UpdateRapaint();
					//ConfigureKeyboard(RootString, false);
					//RePaintScreen(0,0);
					break;
				}
				case SCIM_TRANS_CMD_SET_CONFIG_STRING:
				{
					memset(destring, 0, 512); 
					sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_SET_CONFIG_STRING\n", __func__);
					g_writedebug("//home//user//pphanpindebug.txt", destring);

					reader.get_data(wstr);
					if(wstr.size() == 16)
						gbl_language = L_TAIWAN;
					else if(wstr.size() == 15)
						gbl_language = L_CHINA;
					else
						gbl_language = L_ENGLISH;
					break;
				}
				case SCIM_TRANS_CMD_SHOW_LOOKUP_TABLE:
				{
					gbl_active_number = 1;
					gbl_b_root = true;

					//ubSrڪɫ|
					//jNkb]w all disable ,  uѤUbackspace
					gbl_PPKeyboard.ConfigureKB(L" ");
					UpdateRapaint();
					//ConfigureKeyboard(RootString, false);
					//RePaintScreen(0,0);
					break;
				}
				case SCIM_TRANS_CMD_HIDE_LOOKUP_TABLE:
				{
					gbl_PPKeyboard.ConfigureKB(RootString);
					UpdateRapaint();
					//ConfigureKeyboard(NULL, false);
					//RePaintScreen(0,0);
					break;
				}
				case SCIM_TRANS_CMD_FOCUS_IN:
				{
					memset(destring, 0, 512); 
					sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_FOCUS_IN\n", __func__);
					g_writedebug("//home//user//pphanpindebug.txt", destring);

					//gbl_b_focus = true;
					cur_ic = ic;
					cur_uuid = uuid;
					gbl_b_focus = true;
					gtk_window_move(GTK_WINDOW (gbl_win), gbl_window_x, gbl_window_y);
					gtk_widget_show_all(gbl_win);
/*
					if(focus_timerid != 0)
					{
						if(!g_source_remove(focus_timerid))
							g_message("hanpin helper SCIM_TRANS_CMD_FOCUS_IN g_source_remove() error\n");

						focus_timerid = 0;
						memset(destring, 0, 512);
						sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_FOCUS_IN, kill timer\n", __func__);
						g_writedebug("//home//user//pphanpindebug.txt", destring);
					}
*/
					//gtk_widget_show (gbl_areaP);
					//gtk_widget_show (gbl_win);
					break;
				}
				case SCIM_TRANS_CMD_FOCUS_OUT:
				{
					memset(destring, 0, 512);
					sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_FOCUS_OUT \n", __func__);
					g_writedebug("//home//user//pphanpindebug.txt", destring);
				
					gtk_window_get_position(GTK_WINDOW (gbl_win), &gbl_window_x, &gbl_window_y);
					gtk_widget_hide_all(gbl_win);
					GdkEventMotion temp_event;
					temp_event.type = GDK_BUTTON_RELEASE;
					on_button_release_event(gbl_win, &temp_event);
					gbl_b_focus = false;
/*
					if(focus_timerid != 0)
					{
						if(!g_source_remove(focus_timerid))
						g_message("hanpin helper SCIM_TRANS_CMD_FOCUS_OUT g_source_remove() error\n");

						focus_timerid = 0;
						memset(destring, 0, 512);
						sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_FOCUS_OUT, kill timer\n", __func__);
						g_writedebug("//home//user//pphanpindebug.txt", destring);
					}

					focus_timerid = g_timeout_add(200,hide_keyboard, NULL);

					if(focus_timerid <= 0)
						g_message("hanpin helper SCIM_TRANS_CMD_FOCUS_OUT g_timeout_add() error\n");
*/
/*		
					if(gbl_binfoshow)
					{
						gbl_info_stat = PPOD_CTL_STATE_0;
						gtk_widget_hide_all(gbl_infoWindow);
						gbl_binfoshow = false;
						//DestroyInfoWindow();
					}
*/
					cur_ic = -1;
					cur_uuid = String ("");
					gbl_RootString.clear();
					memset(RootString, 0, sizeof(RootString));

					break;
				}
				case SCIM_TRANS_CMD_FORWARD_KEY_EVENT:
				{
					gbl_PPKeyboard.ConfigureKB(NULL);
					UpdateRapaint();
					//ConfigureKeyboard(NULL, true);
					//RePaintScreen(0,0);
					break;
				}
				case SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER:
				{
					memset(destring, 0, 512);
					sprintf(destring, "hanpin helper %s read SCIM_TRANS_CMD_HELPER_MANAGER_RUN_HELPER \n", __func__);
					g_writedebug("//home//user//pphanpindebug.txt", destring);
/*					if(gbl_b_focus)
					{
						gtk_widget_hide_all(gbl_win);

						GdkEventMotion temp_event;
						temp_event.type = GDK_BUTTON_RELEASE;
						on_button_release_event(gbl_win, &temp_event);
						memset(destring, 0, 512);
						sprintf(destring, "hanpin helper %s, hide keypad, call m_agent->hide_pad\n", __func__);
						g_writedebug("//home//user//pphanpindebug.txt", destring);
						//m_agent->hide_pad(SCIM_PPHANPIN_IMENGINE_UUID);
						gbl_b_focus = false;
					}
					else
					{
						gbl_b_focus = true;
						cur_ic = ic;
						cur_uuid = uuid;
						gtk_widget_show_all(gbl_win);
						memset(destring, 0, 512);
						sprintf(destring, "hanpin helper %s, show keypad, call m_agent->show_pad\n", __func__);
						g_writedebug("//home//user//pphanpindebug.txt", destring);

					}
*/					break;
				}

				}
            }
        }
    }
}
void send_focusout_to_imengine()
{
	Transaction trans;
	trans.clear();
	trans.put_command (SCIM_TRANS_CMD_REQUEST);
	trans.put_command (SCIM_TRANS_CMD_FOCUS_OUT);
    m_agent->send_imengine_event (cur_ic, cur_uuid, trans);
/*
	cur_ic = -1;
	cur_uuid = String ("");
	gtk_widget_hide (g_mainwindow);
*/

}

void forward_key_ctrlspace_clicked()
{
	guint keycode;
	keycode = SCIM_KEY_space;
	KeyEvent key = KeyEvent (keycode, SCIM_KEY_ControlMask);
	KeyEvent key_release = KeyEvent (keycode, SCIM_KEY_ReleaseMask);
	if (m_agent && cur_ic >= 0) 
	{
		m_agent->send_key_event (cur_ic, cur_uuid, key);
		m_agent->send_key_event (cur_ic, cur_uuid, key_release);
	}
}

/*
bool GrabMainPointer(GtkWidget *window)
{
	bool bresult = false;
	GdkGrabStatus result;
	result = gdk_pointer_grab (window->window, FALSE,
	(GdkEventMask) (GDK_PROXIMITY_IN_MASK | GDK_PROXIMITY_OUT_MASK | GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK | GDK_BUTTON_RELEASE_MASK), 0, NULL, GDK_CURRENT_TIME);
	switch (result)
	{

		case GDK_GRAB_SUCCESS:
			{
				bresult = true;
			}
		   break;
		case GDK_GRAB_ALREADY_GRABBED:
		   break;
		case GDK_GRAB_INVALID_TIME:
		   break;
		case GDK_GRAB_NOT_VIEWABLE:
		   break;
		case GDK_GRAB_FROZEN:
		   break;
		default:
		   break;
	}

	return bresult;
}
*/
/*
bool UnGrabMainPointer()
{
	GdkDisplay  *display; 
	display = gdk_display_get_default ();
	gdk_display_pointer_ungrab ( display, GDK_CURRENT_TIME);
}
*/

gboolean hide_keyboard(gpointer userdata)
{
	char destring[512] = "";

	gtk_widget_hide_all (gbl_win);
	GdkEventMotion temp_event;
    	temp_event.type = GDK_BUTTON_RELEASE;
    	on_button_release_event(gbl_win, &temp_event);
	sprintf(destring, "italy helper %s, hide keypad, call m_agent->hide_pad\n", __func__);
	g_writedebug("//home//user//pphanpindebug.txt", destring);

	//m_agent->hide_pad(SCIM_PPHANPIN_IMENGINE_UUID);
	if(gbl_infoWindow)
	{
		//DestroyInfoWindow();
	}
	focus_timerid = 0;
	return 0;
}

static void
delete_button_clicked_callback (GtkButton *button, gpointer user_data)
{
    HelperAgent *agent = static_cast<HelperAgent *> (user_data);

    if (agent && cur_ic >= 0) {
        Transaction trans;
        trans.put_command (SCIM_TRANS_CMD_REQUEST);
        trans.put_command (SCIM_TRANS_CMD_DELETE_SURROUNDING_TEXT);
        agent->send_imengine_event (cur_ic, cur_uuid, trans);
    }
}

gboolean update_lookup_table(WideString &str)
{	
	if (m_agent && cur_ic >= 0) {
		Transaction trans;
		trans.put_command (SCIM_TRANS_CMD_REQUEST);
		trans.put_command (SCIM_TRANS_CMD_UPDATE_LOOKUP_TABLE);
		trans.put_data(str);		
		m_agent->send_imengine_event (cur_ic, cur_uuid, trans);
		return TRUE;
	}
	return FALSE;
}

static gboolean
agent_input_handler (GIOChannel *source, GIOCondition condition, gpointer user_data)
{
    if (condition == G_IO_IN) {
        std::cerr << "agent_input_handler G_IO_IN\n";
        HelperAgent *agent = static_cast<HelperAgent *> (user_data);
        if (agent && agent->has_pending_event ())
            agent->filter_event ();
    } else if (condition == G_IO_ERR || condition == G_IO_HUP) {
        std::cerr << "agent_input_handler G_IO_ERR|G_IO_HUP\n";
        gtk_main_quit ();
    }
    return TRUE;
}

/*
static void cand_button_clicked (GtkWidget *widget, gpointer data)
{
	gint i = GPOINTER_TO_INT (data);
	gchar * ch;
	WideString str;
	
	do_auto_select_first_cand = FALSE;
	if (do_writing_done_timeout) {
		if (writing_done_timeout > 0) {
			g_source_remove (writing_done_timeout);
			writing_done_timeout = 0;
		}
	}
	if (i >= 0 && i < SCIM_PPHANPIN_CANDIDATE_NUM 
        && char_converted [i] != NULL)
		if (m_agent && cur_ic >= 0) {
			ch = char_converted [i];
			while (*ch != '\0') {
				str.push_back (*ch);
				ch++;
			}
			m_agent->commit_string (cur_ic, cur_uuid, str);
		}	
}

static void update_candiate (gchar *str, gint num)
{
	gchar *p, *wRes;
	gsize in, out;
	gint i, x, n;
	unsigned char w[8];
	ucs4_t pwc[8], wc, hwc;
	WideString wstr;
	
	for (i = 0; i < SCIM_PPHANPIN_CANDIDATE_NUM; i++)
	{
		if (char_converted [i] != NULL)
		{
			g_free (char_converted [i]);
			char_converted [i] = NULL;
		}
	}

	p = str;
	for (i = 0; i < num; i++)
	{	
		wRes = g_convert_with_iconv ((gchar *) p, SCIM_PPHANPIN_CHAR_WIDTH_DEFAULT,
				m_iconv,
				&in, &out, 
				NULL);
		if (((m_rec_type == SCIM_PPHANPIN_LETTER)
		     || (m_rec_type == SCIM_PPHANPIN_NUMBER)
		     || (m_rec_type == SCIM_PPHANPIN_PUNC))
                && (! m_use_full_width_symbol)) {
			n = utf8_mbtowc (pwc, (const unsigned char *)wRes, strlen (wRes));
			pwc [n] = 0;
			hwc = scim_wchar_to_half_width (pwc[0]);
			x = utf8_wctomb (w, hwc, 8);
			w[x] = '\0';
			g_free (wRes);
			wRes = g_strdup ((const gchar *) w);
		}
		gtk_button_set_label (GTK_BUTTON (cand_button [i]), wRes);
		char_converted [i] = wRes;
		p += SCIM_PPHANPIN_CHAR_WIDTH_DEFAULT;
	}
	for (x = i; x < SCIM_PPHANPIN_CANDIDATE_NUM; x++)
	{
		gtk_button_set_label (GTK_BUTTON (cand_button [x]), NULL);
		gtk_widget_hide (GTK_WIDGET (cand_button [x]));
		char_converted [x] = NULL;
	}
}

static gboolean writing_done_timeout_callback (gpointer data)
{
	if (do_auto_select_first_cand) {
		cand_button_clicked (NULL, GINT_TO_POINTER (0));	
		writing_done_timeout = 0;
		do_auto_select_first_cand = FALSE;
	}

	// call one time only 
	return FALSE;
}

static void scim_pphanpin_writing_start_cb (GtkWidget *widget, gpointer data, gpointer user_data)
{
	if (do_auto_select_first_cand) {
		if (writing_done_timeout > 0) {
			g_source_remove (writing_done_timeout);
			writing_done_timeout = 0;
		}
		cand_button_clicked (NULL, GINT_TO_POINTER (0));	
		do_auto_select_first_cand = FALSE;
	}
}

static void scim_pphanpin_writing_done_cb (GtkWidget *widget, gpointer data, gpointer user_data)
{
	gint16 *points;
	gushort wResult[SCIM_PPHANPIN_CANDIDATE_NUM * 2];
	int i, rec_range;
	gsize in, out;

	g_message ("Test: writing done!");
	
	if (scim_pphanpin_rec_engine_inited == 0) {
		// FIXME: add error handle here plz 
		scim_pphanpin_rec_engine_inited = 1;
	}

	switch (m_rec_type) {
		case SCIM_PPHANPIN_HANZI:
			rec_range = SCIM_PPHANPIN_REC_TYPE_HANZI;
			break;
		case SCIM_PPHANPIN_PUNC:
			rec_range= SCIM_PPHANPIN_REC_TYPE_PUNC;
			break;
		case SCIM_PPHANPIN_LETTER:
			rec_range = SCIM_PPHANPIN_REC_TYPE_LETTER;
			break;
		case SCIM_PPHANPIN_NUMBER:
			rec_range = SCIM_PPHANPIN_REC_TYPE_NUMBER;
			break;
	}	
	points = gtk_pphanpin_pane_get_points (widget);
	
	wResult[i*2] = '\0';

	update_candiate ((gchar *)wResult, i);

	if (do_writing_done_timeout) {
		writing_done_timeout = 
			g_timeout_add(1000 * SCIM_PPHANPIN_PANE_WRINTING_DONE_TIMEOUT_DEFAULT,
					writing_done_timeout_callback, (gpointer) widget);
	}

	do_auto_select_first_cand = TRUE;
}

static gboolean scim_pphanpin_rec_engine_quit (GtkWidget *widget, GdkEvent *event, gpointer data)
{
}

static void rec_type_toggoled (GtkWidget *widget, gpointer data)
{
	m_rec_type = GPOINTER_TO_INT(data);
}
*/
void forward_key_button_clicked (GtkWidget *widget, gpointer data)
{    
	guint keycode;
	KeyEvent key;
	g_writedebug("//home//user//pphanpindebug.txt", "hanpin forward_key_button_clicked\n");
	keycode = GPOINTER_TO_UINT(data);

	if (m_agent && cur_ic >= 0) 
	{		
/*	    if(keycode == SCIM_KEY_semicolon)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L";");
		return;
	    }
	    else if(keycode == SCIM_KEY_colon)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L":");
		return;
	    }
	    else if(keycode == SCIM_KEY_quoteright)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"'");
		return;
	    }
	    else if(keycode == SCIM_KEY_quotedbl)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"\"");
		return;
	    }
	    else if(keycode == SCIM_KEY_exclam)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"!");
		return;
	    }
	    else if(keycode == SCIM_KEY_asterisk)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"*");
		return;
	    }
	    else if(keycode == SCIM_KEY_question)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"?");
		return;
	    }
	    else if(keycode == SCIM_KEY_at)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"@");
		return;
	    }
	    else if(keycode == SCIM_KEY_comma)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L",");
		return;
	    }
	    else if(keycode == SCIM_KEY_less)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"<");
		return;
	    }
	    else if(keycode == SCIM_KEY_period)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L".");
		return;
	    }
	    else if(keycode == SCIM_KEY_greater)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L">");
		return;
	    }
	    else if(keycode == SCIM_KEY_minus)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"-");
		return;
	    }
	    else if(keycode == SCIM_KEY_underscore)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"_");
		return;
	    }
	    else if(keycode == SCIM_KEY_slash)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"/");
		return;
	    }
	    else if(keycode == SCIM_KEY_bar)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"|");
		return;
	    }
*/
	    if(keycode == SCIM_KEY_3270_PA1)
	    {	
		m_agent->commit_string(cur_ic, cur_uuid, L"＋");
		return;
	    }
	    else if(keycode == SCIM_KEY_Greek_horizbar)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"＿");
		return;
	    }
	    else if(keycode == SCIM_KEY_KP_Equal)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"＝");
		return;
	    }
	    else if(keycode == SCIM_KEY_Obarred)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"｜");
		return;
	    }
	    else if(keycode == SCIM_KEY_Armenian_comma)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"，");
		return;
	    }
	    else if(keycode == SCIM_KEY_Abelowdot)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"。");
		return;
	    }
	    else if(keycode == 0x00a9)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"©");
		return;
	    }
	    else if(keycode == 0x00b6)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"¶");
		return;
	    }
	    else if(keycode == 0x002b)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"+");
		return;
	    }
	    else if(keycode == 0x00f7)
	    {
		m_agent->commit_string(cur_ic, cur_uuid, L"÷");
		return;
	    }
	    else if(keycode == 0x013a)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"：");
			return;
		}
		else if(keycode == 0x013b)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"；");
			return;
		}
		else if(keycode == 0x0127)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"、");
			return;
		}
		else if(keycode == 0x0122)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"＂");
			return;
		}
		else if(keycode == 0x0121)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"！");
			return;
		}
		else if(keycode == 0x0140)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"@");
			return;
		}
		else if(keycode == 0x0123)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"＃");
			return;
		}
		else if(keycode == 0x0124)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"＄");
			return;
		}
		else if(keycode == 0x0125)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"％");
			return;
		}
		else if(keycode == SCIM_KEY_leftshoe)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"〈");
			return;
		}
		else if(keycode == 0x0126)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"＆");
			return;
		}
		else if(keycode == 0x012a)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"＊");
			return;
		}
		else if(keycode == 0x012d)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"－");
			return;
		}
		else if(keycode == 0x0128)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"（");
			return;
		}
		else if(keycode == 0x0129)
		{
			m_agent->commit_string(cur_ic, cur_uuid, L"）");
			return;
		}

		if(gbl_hanpin_bCTRL)
		{
			key = KeyEvent (keycode, SCIM_KEY_ControlMask);
			if(keycode == SCIM_KEY_space)
				gbl_hanpin_bCTRL = false;
		}
	    
		if(keycode == SCIM_KEY_exclam || keycode == SCIM_KEY_at ||
			keycode == SCIM_KEY_numbersign || keycode == SCIM_KEY_dollar ||
			keycode == SCIM_KEY_percent ||
			keycode == SCIM_KEY_ampersand || keycode == SCIM_KEY_asterisk ||
			keycode == SCIM_KEY_question || keycode == SCIM_KEY_colon ||
			keycode == SCIM_KEY_quotedbl || keycode == SCIM_KEY_underscore ||
			keycode == SCIM_KEY_parenleft || keycode == SCIM_KEY_parenright ||
			keycode == SCIM_KEY_asciitilde || keycode == SCIM_KEY_bar ||
			keycode == SCIM_KEY_greater || keycode == SCIM_KEY_less ||
			keycode == 0x007b || keycode == 0x007d	)
	    {
			key = KeyEvent (keycode, SCIM_KEY_ShiftMask);
	    }
		else if(gbl_hanpin_bCAPS)
	    {
			if(keycode <= 90 && keycode >= 65)
				key = KeyEvent(keycode, SCIM_KEY_ShiftMask);
			else
				key = KeyEvent (keycode, SCIM_KEY_NullMask);
	    }
        else
		{
			key = KeyEvent (keycode, SCIM_KEY_NullMask);
		}
	
		KeyEvent key_release = KeyEvent (keycode, SCIM_KEY_ReleaseMask);
		/* if you do not want thoese keys to be send to IMEngine, use (-1, "", key) instead */
		m_agent->send_key_event (cur_ic, cur_uuid, key);
		m_agent->send_key_event (cur_ic, cur_uuid, key_release);
	}	
}

static char* get_current_window_manager_name (Display *xdpy)
{
	int		 xscreen;
	Atom           atom_utf8_string, atom_wm_name, atom_check, type;
	int            result, format;
	char          *val, *retval;
	unsigned long  nitems, bytes_after;
	Window        *support_xwin = NULL;

	xscreen = DefaultScreen (xdpy);
	atom_check = XInternAtom (xdpy, "_NET_SUPPORTING_WM_CHECK", False);

	XGetWindowProperty (xdpy, 
			RootWindow(xdpy, xscreen),
			atom_check,
			0, 16L, False, XA_WINDOW, &type, &format,
			&nitems, &bytes_after, (unsigned char **)&support_xwin);

	if (support_xwin == NULL)
		return NULL;

	atom_utf8_string = XInternAtom (xdpy, "UTF8_STRING", False);
	atom_wm_name     = XInternAtom (xdpy, "_NET_WM_NAME", False);

	result = XGetWindowProperty (xdpy, *support_xwin, atom_wm_name,
			0, 1000L,False, atom_utf8_string,
			&type, &format, &nitems,
			&bytes_after, (unsigned char **)&val);
	if (result != Success)
		return NULL;

	if (type != atom_utf8_string || format !=8 || nitems == 0)
	{
		if (val) XFree (val);
		return NULL;
	}

	retval = strdup (val);

	XFree (val);

	return retval;
}
static void set_window_as_input_pad (GtkWidget *widget)
{
	Display *display;
	GdkWindow *win;
	char *wm_name;

	win = widget->window;
	display = GDK_WINDOW_XDISPLAY(win);

	wm_name = get_current_window_manager_name (display);
	if (wm_name && strcmp (wm_name, SUPPORTED_WM) == 0) {
		Atom atom_NET_WM_WINDOW_TYPE =
			XInternAtom(display, "_NET_WM_WINDOW_TYPE" , False);

		Atom atom_NET_WM_WINDOW_TYPE_TOOLBAR =
			XInternAtom(display, "_NET_WM_WINDOW_TYPE_TOOLBAR", False);


		XChangeProperty(display, GDK_WINDOW_XID(win),
				atom_NET_WM_WINDOW_TYPE, XA_ATOM, 32,
				PropModeReplace,
				(unsigned char *) 
				&atom_NET_WM_WINDOW_TYPE_TOOLBAR, 1);
	}
}

/*
gboolean FindInSenseXY(gdouble x,gdouble y)
{
	if (((x >= 560 ) && (x <= 593 )) &&
		((y >= 16 ) && (y <= 49 )))
	{
		return true;
	}
	else
		return false;
}


int FindControlInPTXY(gdouble x,gdouble y)
{
	int i; //,tmpW,tmpH;
	PPCtlInfo *oneInfoP;

    if(gbl_bNUMBER)
	{
        for (i = 0;i < gbl_symctl_count;i++)
        {
            oneInfoP = &(gbl_sym_controls[i]);
            if (oneInfoP != 0)
            {
                if (oneInfoP->m_disable == 0)
                {
                    if (((x >= oneInfoP->m_mainRect.m_left ) && (x <= oneInfoP->m_mainRect.m_right )) &&
                        ((y >= oneInfoP->m_mainRect.m_top ) && (y <= oneInfoP->m_mainRect.m_bottom )))
                    {
                        return i;
                    }
                }
            }
        }	
	}
	else
	{
		for (i = 0;i < gbl_ctl_count;i++)
		{
			oneInfoP = &(gbl_controls[i]);
			if (oneInfoP != 0)
			{
				if (oneInfoP->m_disable == 0)
				{
					if (((x >= oneInfoP->m_mainRect.m_left ) && (x <= oneInfoP->m_mainRect.m_right )) &&
						((y >= oneInfoP->m_mainRect.m_top ) && (y <= oneInfoP->m_mainRect.m_bottom )))
					{
						return i;
					}
				}
			}
		}
	}
	return -1;
}

int FindControlInSenseXY(gdouble x,gdouble y)
{
	int i; //,tmpW,tmpH;
	PPCtlInfo *oneInfoP;

    if(gbl_bNUMBER)
    {
        for (i = 0;i < gbl_symctl_count;i++)
        {
            oneInfoP = &(gbl_sym_controls[i]);
            if (oneInfoP != 0)
            {
                if (oneInfoP->m_disable == 0)
                {
                    if (((x >= oneInfoP->m_senseRect.m_left ) && (x <= oneInfoP->m_senseRect.m_right )) &&
                        ((y >= oneInfoP->m_senseRect.m_top ) && (y <= oneInfoP->m_senseRect.m_bottom )))
                    {
                        return i;
                    }
                }
            }
        }
	}
	else
	{
		for (i = 0;i < gbl_ctl_count;i++)
		{
			oneInfoP = &(gbl_controls[i]);
			if (oneInfoP != 0)
			{
				if (oneInfoP->m_disable == 0)
				{
					if (((x >= oneInfoP->m_senseRect.m_left ) && (x <= oneInfoP->m_senseRect.m_right )) &&
						((y >= oneInfoP->m_senseRect.m_top ) && (y <= oneInfoP->m_senseRect.m_bottom )))
					{
						return i;
					}
				}
			}
		}
	}

	return -1;

}
*/
void on_destroy(GtkWidget *Widget_pointer)
{
/*	if(gbl_gdkPixImgP != 0)
	{
		g_object_unref(gbl_gdkPixImgP);
		gbl_gdkPixImgP = 0;
	}
	if(gbl_controlsImgP != 0)
	{
		g_object_unref(gbl_controlsImgP);
		gbl_controlsImgP = 0;
	}
	if(gbl_controlsImgP1 != 0)
	{
		g_object_unref(gbl_controlsImgP1);
		gbl_controlsImgP1 = 0;
	}
	if(gbl_controlsImgP2 != 0)
	{
		g_object_unref(gbl_controlsImgP2);
		gbl_controlsImgP2 = 0;
	}
	if(gbl_closeImgP != 0)
	{
		g_object_unref(gbl_closeImgP);
		gbl_closeImgP = 0;
	}
*/				
	PPCtlInfo *oneInfoP;
	if(gbl_areaP !=0)
	{
		gtk_widget_destroy(gbl_areaP);
		gbl_areaP = NULL;
	}	
	gtk_main_quit();
}

gboolean on_delete_event(GtkWidget* window,GdkEvent* event,gpointer data)
{
	return FALSE;
}

gboolean on_expose_event(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{		
	//RePaintScreen(0,0);
	gbl_PPCaption.OnPaint(widget,event,user_data);
	gbl_PPKeyboard.OnPaint(widget,event,user_data);

	return TRUE;
}

void UpdateRapaint()
{
	gbl_PPCaption.OnPaint(NULL,NULL,NULL);
	gbl_PPKeyboard.OnPaint(NULL,NULL,NULL);
}

/*
int draw_controls(GtkWidget *widget,int iAutoXor)
{
	int i,tmpW,tmpH;
	PPCtlInfo *oneInfoP;
	int iRepaintFlag;
	int ctrl_count = 0;

	if(gbl_bNUMBER)
	{
		ctrl_count = gbl_symctl_count;
    }
    else
    {
		ctrl_count = gbl_ctl_count;
    }

	for (i = 0;i < ctrl_count;i++)
	{		
		if(gbl_bNUMBER)
			oneInfoP = &(gbl_sym_controls[i]);
		else
			oneInfoP = &(gbl_controls[i]);

		if (oneInfoP != 0)
		{				
			if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_NORM)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_NORM)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{					
					tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
					tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;										
		
					if(!gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable1 != NULL && oneInfoP->m_disable == DISABLE)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable1, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					else if(gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable2 != NULL && oneInfoP->m_disable == DISABLE)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable2, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					else
					{
						if(!gbl_hanpin_bCAPS)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						else
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgPU, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);					
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_NORM;
				}
				if(oneInfoP->m_CtlID == BUTTON_CTRL_ID)
				{
					tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
					tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;

					if(gbl_hanpin_bCTRL)
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPD, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
					else
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPU, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DOWN)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DOWN)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{										
					tmpW = oneInfoP->m_OFSPX_downRect.m_right - oneInfoP->m_OFSPX_downRect.m_left;
					tmpH = oneInfoP->m_OFSPX_downRect.m_bottom - oneInfoP->m_OFSPX_downRect.m_top;					
					if(oneInfoP->m_imgP_down != NULL)
					{					
						if(oneInfoP->m_CtlID == BUTTON_CAPS_ID)
						{
							if(!gbl_hanpin_bCAPS)
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_capsImgPU, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
							else
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_capsImgPL, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
						else
						{
							if(oneInfoP->m_CtlID == BUTTON_CTRL_ID)
							{
								if(gbl_hanpin_bCTRL)
									gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPU, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
								else
									gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPD, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
							}
							else
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_down, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
						}
					}
					else
					{
						
						tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
						tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;
						if(!gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable1 != NULL && oneInfoP->m_disable == DISABLE)
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable1, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						else if(gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable2 != NULL && oneInfoP->m_disable == DISABLE)
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable2, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 						
						else
						{
							if(!gbl_hanpin_bCAPS)
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
							else
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgPU, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DOWN;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_OVER)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_OVER)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{					
					tmpW = oneInfoP->m_OFSPX_overRect.m_right - oneInfoP->m_OFSPX_overRect.m_left;
					tmpH = oneInfoP->m_OFSPX_overRect.m_bottom - oneInfoP->m_OFSPX_overRect.m_top;
					if(oneInfoP->m_imgP_over != NULL)
					{						
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_over, oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					else
					{
						if(oneInfoP->m_CtlID != BUTTON_CTRL_ID)
						{														
							tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
							tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;
							if(!gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable1 != NULL && oneInfoP->m_disable == DISABLE)
							{
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable1, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
							}
							else if(gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable2 != NULL && oneInfoP->m_disable == DISABLE)
							{
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable2, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
							}
							else
							{
								if(oneInfoP->m_disable != DISABLE && oneInfoP->m_CtlID != BUTTON_INFO_ID)
								{
									if(!gbl_hanpin_bCAPS)
										gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP, oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
									else
										gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgPU, oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
								}
								else if(oneInfoP->m_disable != DISABLE && oneInfoP->m_CtlID == BUTTON_INFO_ID)
								{
									gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP, oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
								}
							}
						}
						else
						{
							if(gbl_hanpin_bCTRL)
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPD, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
							else
								gdk_draw_pixbuf(widget->window, widget->style->white_gc, gbl_ctrlImgPU, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0);
						}
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_OVER;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DISABLE)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DISABLE)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{					
					tmpW = oneInfoP->m_OFSPX_disableRect.m_right - oneInfoP->m_OFSPX_disableRect.m_left;
					tmpH = oneInfoP->m_OFSPX_disableRect.m_bottom - oneInfoP->m_OFSPX_disableRect.m_top;					
					if(!gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable1 != NULL && oneInfoP->m_disable == DISABLE)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable1, oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					else if(gbl_hanpin_bCAPS && oneInfoP->m_imgP_disable2 != NULL && oneInfoP->m_disable == DISABLE)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP_disable2, oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 					
					else
					{
						if(!gbl_hanpin_bCAPS)
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgP, oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						else
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, oneInfoP->m_imgPU, oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DISABLE;
				}
			}
		}
	}
	return 0;
}
*/
/*
void RePaintScreen(int iRpBackground,int iAutoXor)
{
	//int i;
	//GdkPoint points[5];	

	if (gbl_win != 0)
	{
		//if (gbl_oneGtkImgP != 0)
		{
			if (gbl_areaP != 0)
			{						
				//tmpType = gtk_image_get_storage_type(GTK_IMAGE(gbl_oneGtkImgP));
				//sprintf(BBB,"%d",tmpType);
				//gtk_window_set_title(GTK_WINDOW(gbl_win), BBB);

				//gtk_image_get_image(GTK_IMAGE(gbl_oneGtkImgP),&tmp_gdk_imageP,NULL);
				//for (i = 0;i < 5;i++)
				//{
				//	points[i].x = i*3;
				//	points[i].y = i*3;
				//}
				//gdk_draw_image(gbl_areaP->window,gbl_areaP->style->white_gc,tmp_gdk_imageP,0,0,0,0,-1,-1);
				//gtk_window_set_title(GTK_WINDOW(gbl_win),"Drawing");

				if (iRpBackground == 1)
				{
					if(gbl_gdkPixImgP != NULL)
					gdk_draw_pixbuf(gbl_areaP->window, gbl_areaP->style->white_gc, gbl_gdkPixImgP, 0, 0, 0, 0, -1, -1, GDK_RGB_DITHER_NONE, 0, 0); 
				}				
				draw_controls(gbl_areaP,iAutoXor);				
				//gdk_draw_points(gbl_areaP->window,gbl_areaP->style->fg_gc[GTK_WIDGET_STATE(gbl_areaP)],points,5);
			}
		}
	}

}
*/
/*
void Timer_Response(int)
{
	int idx = 0;
	PPCtlInfo *oneInfoP;
	KeyEvent key, key_release;	

	if(gbl_win != 0 && gbl_bPress == true)
	{
	//void Send_Backspace_KeyEvent(int)
	//根據timer發送backspace
		
		for(idx = 0; idx < gbl_ctl_count; idx++)
		{
			if(gbl_controls[idx].m_CtlDrawState == PPOD_CTLDRAW_DOWN)
			{
				if(gbl_controls[idx].m_CtlID != BUTTON_BK_ID)
					return;
				else
				{
					if (m_agent && cur_ic >= 0)
					{
						key = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_NullMask);
						key_release = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_ReleaseMask);
						m_agent->send_key_event (cur_ic, cur_uuid, key);
        					m_agent->send_key_event (cur_ic, cur_uuid, key_release);
					}
				}
			}
		}
		
	}
	else if(gbl_win != 0 && gbl_bPress == false)
	{
	//void hide_keyboard(int)
		if(!gbl_b_focus)
    		{
			gtk_widget_hide (gbl_areaP);
        		gtk_widget_hide (gbl_win);
    		}
	}
}
*/
void snd_sound()
{
	snd_handler_t h_snd;
	h_snd = snd_connect();
	char destring[64] = "";
	sprintf(destring, "snd_connect:%d", h_snd);
	g_writedebug("//home//user//pphanpindebug.txt", destring);
	g_message(destring);
	snd_play(h_snd, "/usr/share/scim/pphanpin/sounds/02_20080604.wav");
	snd_disconnect(h_snd);
}

static GTimeVal backspace_time;

gboolean Send_Backspace_KeyEvent(gpointer userdata)
{
    KeyEvent key, key_release;
    GTimeVal time;

    if (m_agent && cur_ic >= 0)
    {
	if(gbl_backspace_times == 0)
	{
		g_get_current_time(&backspace_time);
        	key = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_NullMask);
        	key_release = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_ReleaseMask);
        	m_agent->send_key_event (cur_ic, cur_uuid, key);
        	m_agent->send_key_event (cur_ic, cur_uuid, key_release);
		gbl_backspace_times++;
	}
	else if(gbl_backspace_times > 0)
	{
		g_get_current_time(&time);
		if((((time.tv_sec-backspace_time.tv_sec)*1000000)+(time.tv_usec-backspace_time.tv_usec)) > 600000)
		{
			key = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_NullMask);
        		key_release = KeyEvent (SCIM_KEY_BackSpace, SCIM_KEY_ReleaseMask);
        		m_agent->send_key_event (cur_ic, cur_uuid, key);
        		m_agent->send_key_event (cur_ic, cur_uuid, key_release);
			gbl_backspace_times++;
		}
	}
    }
    return true;
}

bool b_pressinfo = false;
/*
gboolean on_button_press_info_event(GtkWidget *widget, GdkEventButton *event)
{		
	if(gbl_infoWindow != 0)
	{
		if(event->type == GDK_BUTTON_PRESS)
		{
			if(FindInSenseXY(event->x, event->y))
			{
				gbl_info_stat = PPOD_CTL_STATE_1;
				if(gbl_infoCloseImg != NULL)
				{
					int width = gdk_pixbuf_get_width(gbl_infoCloseImg);
					int height = gdk_pixbuf_get_height(gbl_infoCloseImg);
					gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infoCloseImg, 0, 0, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
				}
			}
		}
	}
	return TRUE;
}
*/
static int press_bk_times = 0;

gboolean on_button_press_event( GtkWidget *widget, GdkEventButton *event )
{
	int idx;
	PPCtlInfo *oneInfoP;
	gint x,y;
	gint retV = 0;

	if (gbl_win != 0)
	{
		if (event->type == GDK_BUTTON_PRESS)
		{
			x = (gint)event->x;
			y = (gint)event->y;
			
			if (gbl_State == PPSTATE_NONE)
			{
				if (gbl_PPCaption.IsPTInThisObject(x,y) == 1)
				{
					if(GrabMainPointer(gbl_areaP))
					{		
						gbl_bGrab = true;
					}					
					retV = gbl_PPCaption.OnMouseLButtonDown(x,y);
					gbl_State = PPSTATE_CAPTION_AREA;
				}else if (gbl_PPKeyboard.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPKeyboard.OnMouseLButtonDown(x,y);
					gbl_State = PPSTATE_KEYBD_AREA;
				}
/*				else if (gbl_PPeditinfo.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPeditinfo.OnMouseLButtonDown(x,y);
					gbl_State = PPSTATE_EDITINFO_AREA;
				}*/
				else
				{
					gbl_State = PPSTATE_NONE;
				}
			}else
			{
				//Err?
			}
		}
	}
/*			
	if (gbl_win != 0 && (gbl_binfoshow == false))
	{
		if (event->type == GDK_BUTTON_PRESS)
		{									
			idx = FindControlInSenseXY(event->x,event->y);
			if (idx != -1)
			{									
				gbl_bPress = true;
				
				if(gbl_bNUMBER)
					oneInfoP = &(gbl_sym_controls[idx]);
                else
					oneInfoP = &(gbl_controls[idx]);

				if (oneInfoP != 0)
				{
					if(oneInfoP->m_disable == DISABLE)
						return TRUE;
					//if (b_printf == FALSE) 
					//if (pRootString != NULL)							
					if (oneInfoP->m_CtlState == PPOD_CTL_STATE_0)						
					{												
						oneInfoP->m_CtlState = PPOD_CTL_STATE_1;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
						lastCPControl = idx;
  						RePaintScreen(0,1);
						if( (oneInfoP->m_CtlID == BUTTON_BK_ID) ||  (oneInfoP->m_CtlID == BUTTON_S_BK_ID) )
						{
							//when BackSpace key is pressed, to set a interval time to send signal.
							set_backspace_timer();
							press_bk_times++;
							char destring[512] = "";
    						sprintf(destring, "hanpin helper press times: %d\n", press_bk_times);
    						g_writedebug("//home//user//pphanpindebug.txt", destring);
						}

						if(strlen(oneInfoP->m_transp_imgU_path) > 0)
						{											
							if(gbl_hanpin_bCAPS)
							{																		
								ShowPopupWindow(oneInfoP->m_transp_imgU_path, oneInfoP->m_transpRect.m_left, oneInfoP->m_transpRect.m_top);
							}
							else
							{	
								ShowPopupWindow(oneInfoP->m_transp_imgL_path, oneInfoP->m_transpRect.m_left, oneInfoP->m_transpRect.m_top);									
							}
						}
						if(oneInfoP->m_CtlID != BUTTON_CLOSE_ID && oneInfoP->m_CtlID != BUTTON_INFO_ID)
                        {
                            snd_sound();
                        }
					}
				}
			}else
			{
				lastCPControl = -1;
			}
		}
	}		
*/		
	return TRUE;
}
/*
gboolean on_motion_notify_info_event( GtkWidget *widget, GdkEventMotion *event )
{
	static bool b_find = false;
	if(gbl_infoWindow != 0)
	{
		int width = gdk_pixbuf_get_width(gbl_infoCloseImg);
		int height = gdk_pixbuf_get_height(gbl_infoCloseImg);
		GdkModifierType state;
		gint x, y;
			if(event->is_hint)
			{
				gdk_window_get_pointer(event->window, &x, &y, &state);
			}
			else
			{
				x = event->x;
				y = event->y;
			}

			if(FindInSenseXY(x, y))
			{
				if(gbl_info_stat == PPOD_CTL_STATE_1)
				{
					gbl_info_stat = PPOD_CTL_STATE_2;
				}
				if(gbl_infoCloseImg != NULL)
				{
					if( (gbl_info_stat == PPOD_CTL_STATE_2) && (b_find == false))
					{
						b_find = true;
						gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infoCloseImg, 0, 0, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
					}
				}
			}
			else
			{
				if( (gbl_info_stat == PPOD_CTL_STATE_2) && b_find)
				{
					b_find = false;
					gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infowindowImg, 560, 16, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
					
				}
			}
		
	}
	return TRUE;
}
*/
gboolean on_motion_notify_event( GtkWidget *widget, GdkEventMotion *event )
{
	gint x,y;
	gint retV = 0;
	GdkModifierType state;

	if (gbl_win != 0)
	{
		if (event->type == GDK_MOTION_NOTIFY)
		{
			if (event->is_hint)
				gdk_window_get_pointer (event->window, &x, &y, &state);
			else
			{
				x = (gint)event->x;
				y = (gint)event->y;
			}
			
			if (gbl_State == PPSTATE_NONE)	//Over and Restore
			{
				if (gbl_PPCaption.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPCaption.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPCaption.OnMouseMove(-1,-1);
				}

				if (gbl_PPKeyboard.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPKeyboard.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPKeyboard.OnMouseMove(-1,-1);
				}
/*
				if (gbl_PPeditinfo.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPeditinfo.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPeditinfo.OnMouseMove(-1,-1);
				}
*/
			}else if (gbl_State == PPSTATE_CAPTION_AREA)
			{
				if (gbl_PPCaption.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPCaption.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPCaption.OnMouseMove(-1,-1);
				}
			}else if (gbl_State == PPSTATE_KEYBD_AREA)
			{
				if (gbl_PPKeyboard.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPKeyboard.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPKeyboard.OnMouseMove(-1,-1);
				}
			}else if (gbl_State == PPSTATE_EDITINFO_AREA)
			{
/*				if (gbl_PPeditinfo.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPeditinfo.OnMouseMove(x,y);
				}else
				{
					retV = gbl_PPeditinfo.OnMouseMove(-1,-1);
				}
*/
			}			
		}
	}

/*	int idx;
	PPCtlInfo *oneInfoP;
	// gchar point_po[32];
	gint x, y;
	GdkModifierType state;
	if (gbl_win != 0)
	{
		//if (event->type == GDK_MOTION_NOTIFY)
		{
			//g_sprintf(point_po,"x:%d, y: %d", (int)event->x, (int)event->y);
			//gtk_window_set_title(GTK_WINDOW(gbl_win), point_po);
			//gtk_window_set_title(GTK_WINDOW(gbl_win), "motion");
			if(event->is_hint)
			{
				gdk_window_get_pointer(event->window, &x, &y, &state);
			}
			else
			{
				x = event->x;
				y=event->y;
			}
			idx = FindControlInPTXY(x,y);	
			
			if (idx != -1)  //pointerbYW
			{
				
				if(gbl_bNUMBER)
					oneInfoP = &(gbl_sym_controls[idx]);
				else
					oneInfoP = &(gbl_controls[idx]);

				if (oneInfoP != 0)
				{
					if (lastCPControl == -1)	//無焦點
					{
						//press ɦ줸
						if (lastPSControl == -1)	//無最後通過的元件
						{
							lastPSControl = idx;
							oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;							
						}else						//有最後通過的元件,需要還原
						{ 
							if (lastPSControl != idx)
							{	
								if(gbl_bNUMBER)
									oneInfoP = &(gbl_sym_controls[lastPSControl]);
								else
									oneInfoP = &(gbl_controls[lastPSControl]);

								if (oneInfoP != 0)
								{
									oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
								}
								lastPSControl = idx;

								if(gbl_bNUMBER)
									oneInfoP = &(gbl_sym_controls[lastPSControl]);
                                else
									oneInfoP = &(gbl_controls[lastPSControl]);

								oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
							}
						}
						HidePopupWindow();
						stop_backspace_timer();
					}
					else //有焦點
					{
						if (lastCPControl != idx) //目前位置不在此焦點元件下, 還原焦點元件
						{
							stop_backspace_timer();

							if(gbl_bNUMBER)
                                oneInfoP = &(gbl_sym_controls[lastPSControl]);
                            else
   								oneInfoP = &(gbl_controls[lastCPControl]);

							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
								HidePopupWindow();
							}
						}else //在焦點元件下
						{
							oneInfoP->m_CtlState = PPOD_CTL_STATE_2;
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
							if(oneInfoP->m_CtlID == BUTTON_BK_ID || oneInfoP->m_CtlID == BUTTON_S_BK_ID )
                            {
                                set_backspace_timer();
                            }
							if(strlen(oneInfoP->m_transp_imgU_path) > 0)
							{
								//ShowPopupWindow(oneInfoP->m_transp_imgU_path, oneInfoP->m_transpRect.m_left, oneInfoP->m_transpRect.m_top);								
								if(gbl_hanpin_bCAPS)
									ShowPopupWindow(oneInfoP->m_transp_imgL_path, oneInfoP->m_transpRect.m_left, oneInfoP->m_transpRect.m_top);
								else
									ShowPopupWindow(oneInfoP->m_transp_imgU_path, oneInfoP->m_transpRect.m_left, oneInfoP->m_transpRect.m_top);
							}
						}
					}
				}
				RePaintScreen(0,1);
			}else // 目前移動位置底下無元件
			{
				if (lastCPControl != -1)	//有焦點
				{
					if(gbl_bNUMBER)
						oneInfoP = &(gbl_sym_controls[lastCPControl]);
					else
						oneInfoP = &(gbl_controls[lastCPControl]);
					
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
						//HidePopupWindow();
					}
				}else	//無焦點
				{
					if (lastPSControl != -1)
					{
						if(gbl_bNUMBER)
                            	oneInfoP = &(gbl_sym_controls[lastPSControl]);
                        else
                            	oneInfoP = &(gbl_controls[lastPSControl]);
						
						if (oneInfoP != 0)
						{
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
							//HidePopupWindow();
							//通知重繪
						}
					}
					lastPSControl = -1;
				}
				stop_backspace_timer();
				RePaintScreen(0,1);
				HidePopupWindow();
			}
		}
	}
*/
	return FALSE;
}

int wcCompareTo(wchar_t a, wchar_t b, bool ignoreCase)
{
	if(ignoreCase)
	{
		wchar_t cmpA, cmpB;
		
		// A:0x0041 ~ Z:0x005A
		// a:0x0061 ~ z:0x007A
		if(a >= 0x0041 && a<= 0x005A)
		{
			cmpA = a + 0x0020;
		}
		else
		{
			cmpA = a;
		}

		// A:0x0041 ~ Z:0x005A
		// a:0x0061 ~ z:0x007A
		if(b >= 0x0041 && b<= 0x005A)
		{
			cmpB = b + 0x0020;
		}
		else
		{
			cmpB = b;
		}

		if(cmpA > cmpB)
			return 1;
		else if(cmpA == cmpB)
			return 0;
		else //if(cmpA < cmpB)
			return -1;
	}
	else
	{
		if(a > b)
			return 1;
		else if(a == b)
			return 0;
		else //if(a < b)
			return -1;
	}
}
/*
int FindKeyMapIndex(int keyid)
{
	int re_index = 0;
	for(int i = 0; i < gbl_key_number; i++)
	{
		if(gbl_hanpin_keymap[i].m_keyid == keyid)
		{
			if(wcscmp(gbl_hanpin_keymap[i].m_keywchar1,L"") != 0 )
				re_index = i;
			break;
		}
	}
	return re_index;
}
*/
/*
gboolean on_button_release_info_event(GtkWidget *widget, GdkEventMotion *event)
{
	if(gbl_infoWindow != 0)
	{
		if(event->type == GDK_BUTTON_RELEASE)
		{
			gbl_info_stat = PPOD_CTL_STATE_0;
			if(FindInSenseXY(event->x, event->y))
			{
				gtk_widget_hide_all(gbl_infoWindow);
				gbl_binfoshow = false;
				DestroyInfoWindow();
			}
		}
		else if(b_pressinfo)
		{
            int width = gdk_pixbuf_get_width(gbl_infoCloseImg);
            int height = gdk_pixbuf_get_height(gbl_infoCloseImg);
            gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infowindowImg, 560, 16, 560, 16, width, height,GDK_RGB_DITHER_NONE, 0, 0);
        }
	}
	return TRUE;
}
*/
gboolean on_button_release_event( GtkWidget *widget, GdkEventMotion *event )
{
	gint x,y;
	gint retV = 0;

	if(gbl_bGrab)
	{
		UnGrabMainPointer();
		gbl_bGrab = false;
	}	

	if (gbl_win != 0)
	{
		if (event->type == GDK_BUTTON_RELEASE)
		{
			x = (gint)event->x;
			y = (gint)event->y;
			
			if (gbl_State == PPSTATE_NONE)	//Over and Restore
			{
				if (gbl_PPCaption.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPCaption.OnMouseLButtonUp(x,y);
				}else
				{
					retV = gbl_PPCaption.OnMouseLButtonUp(-1,-1);
				}
				if (gbl_PPKeyboard.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPKeyboard.OnMouseLButtonUp(x,y);
				}else
				{
					retV = gbl_PPKeyboard.OnMouseLButtonUp(-1,-1);
				}					
			}else if (gbl_State == PPSTATE_CAPTION_AREA)
			{
				if (gbl_PPCaption.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPCaption.OnMouseLButtonUp(x,y);
				}else
				{
					retV = gbl_PPCaption.OnMouseLButtonUp(-1,-1);
				}
				gbl_State = PPSTATE_NONE;
			}else if (gbl_State == PPSTATE_KEYBD_AREA)
			{
				if (gbl_PPKeyboard.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPKeyboard.OnMouseLButtonUp(x,y);
				}else
				{
					retV = gbl_PPKeyboard.OnMouseLButtonUp(-1,-1);
				}
				gbl_State = PPSTATE_NONE;
			}
/*			else if (gbl_State == PPSTATE_EDITINFO_AREA)
			{
				if (gbl_PPeditinfo.IsPTInThisObject(x,y) == 1)
				{
					retV = gbl_PPeditinfo.OnMouseLButtonUp(x,y);
				}else
				{
					retV = gbl_PPeditinfo.OnMouseLButtonUp(-1,-1);
				}
				gbl_State = PPSTATE_NONE;
			}
*/
		}
	}
	return TRUE;
	
/*	int idx;
	PPCtlInfo *oneInfoP;
	bool b_forward = false;

		if (gbl_win != 0)
		{
			if (event->type == GDK_BUTTON_RELEASE)
			{				
				idx = FindControlInPTXY(event->x,event->y);
				if (idx != -1)	//?獢?????綜等???渲麾 --------------------------------------------
				{					
					if (lastCPControl == -1)	//????綜童??謍莎?鈭????-----------------
					{
						if (lastPSControl != -1) //????綽??謍??????? ?????踝?鈭???????????謕?!
						{
							if(gbl_bNUMBER)
                                oneInfoP = &(gbl_sym_controls[lastPSControl]);
                            else
                                oneInfoP = &(gbl_controls[lastPSControl]);
							
							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
								//?謍船????
							}
						}
					}else //??伐????
					{
						if (idx == lastCPControl)	//??質縐????????????.. ??mmand
						{
							gbl_bPress = false;
							if(gbl_bNUMBER)
                                oneInfoP = &(gbl_sym_controls[lastCPControl]);
                            else
                                oneInfoP = &(gbl_controls[lastCPControl]);
							
							if (oneInfoP != 0)
							{								
								oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
								lastPSControl = idx;
								//stop timer
								stop_backspace_timer();
								gbl_backspace_times = 0;
								//?謍船????, ?﹝謒?蹓????
								if(oneInfoP->m_CtlID == BUTTON_CLOSE_ID)
								{
									send_focusout_to_imengine();
									gbl_RootString.clear();
									memset(RootString, 0, sizeof(RootString));
									//gbl_hanpin_bCTRL = true;
									//oneInfoP->m_CmdCallbackP(BUTTON_SPACE_ID,oneInfoP->m_CmdUserDefP);
								}
								else if(oneInfoP->m_CtlID == BUTTON_S_CLOSE_ID)
								{
									send_focusout_to_imengine();
								}
								else if(oneInfoP->m_CtlID == BUTTON_INFO_ID)
								{
									int width = gdk_pixbuf_get_width(gbl_press_infoImgP);
									int height = gdk_pixbuf_get_height(gbl_press_infoImgP);
									gdk_draw_pixbuf(gbl_areaP->window, gbl_areaP->style->white_gc, gbl_infoImgP, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, width, height,GDK_RGB_DITHER_NONE, 0, 0);
									oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
									oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
									lastCPControl = -1;
									ShowInfoWindow();
									return true;
								}
								else if (oneInfoP->m_CtlID == BUTTON_NUMBER_ID)
								{
									gbl_bNUMBER = true;
									RePaintScreen(0, 0);
									lastCPControl = -1;
									return true;
								}
								else if (oneInfoP->m_CtlID == BUTTON_S_ABC_ID)
                                {
									gbl_hanpin_bCAPS = false; //jN caps]w false, ]~ caps `A disable A
									gbl_bNUMBER = false;
									RePaintScreen(0, 0);
									lastCPControl = -1;
									return true;
								}
								else if(oneInfoP->m_CtlID == BUTTON_S_CAPS_ID)
                                {
									if(gbl_hanpin_bCAPS)
										gbl_hanpin_bCAPS = false;
									else    
										gbl_hanpin_bCAPS = true;

									init_sym_controls();
									RePaintScreen(0, 0);
									lastCPControl = -1;
									return true;
                                }
								else if (oneInfoP->m_CmdCallbackP != 0)
								{
								//	wchar_t *pRootChar = NULL;
								///	if(oneInfoP->m_CtlID == BUTTON_BK_ID && gbl_hanpin_bCTRL == false &&
								//		preedit_string_len > 0)
								//	{																							
								//		//preedit_string_len--;
								//		//memset(&wRootChar[preedit_string_len], 0, sizeof(wchar_t));																				
								//		if(preedit_string_len == 0)
								//			pRootChar = NULL;
								//		else
								//			pRootChar = wRootChar;
								//	}
								//	else if(oneInfoP->m_CtlID == BUTTON_SPACE_ID && preedit_string_len == 0)
								//	{										
								//		b_forward = true;
								//		memset(wRootChar, 0, 5*sizeof(wchar_t));
								//		preedit_string_len = 0;
								//		//wchar_t *pRootChar = NULL;										
								//	}
								//	else if(FindKeyMapIndex(oneInfoP->m_CtlID) > 0)
								//	{										
								//		wcscat(wRootChar, gbl_keymap[lastPSControl].m_keywchar);
								//		preedit_string_len++;
								//		//pRootChar = wRootChar;
								//	}
								//	else
								//	{
								//		memset(wRootChar, 0, 5*sizeof(wchar_t));
								//		//pRootChar = NULL;
								//	}																											
								//
								//	char buf_out[256] = "";
								//	GdkWChar wbuf[256];	
								//	sprintf(buf_out, "preedit_string_len:%d", preedit_string_len);
								//	gdk_mbstowcs(wbuf, buf_out, 256);
								//		if(cur_ic >= 0)
								//			m_agent->commit_string (cur_ic, cur_uuid, (wchar_t*)wbuf);
								//																			
									//CimConfigure(pRootChar);									
									oneInfoP->m_CmdCallbackP(oneInfoP->m_CtlID,oneInfoP->m_CmdUserDefP);
									
																		
									//?桀??CAPS???
									if(oneInfoP->m_CtlID == BUTTON_CAPS_ID)
									{
										if(gbl_hanpin_bCAPS)
											gbl_hanpin_bCAPS = false;
										else	
											gbl_hanpin_bCAPS = true;
										//init_hanpin_controls();										
									}
									//?桀??CTRL???
									if(oneInfoP->m_CtlID == BUTTON_CTRL_ID)
									{
										if(gbl_hanpin_bCTRL)
										{
											gbl_hanpin_bCTRL = false;
											g_writedebug("//home//user//pphanpindebug.txt", "hanpin bCTRL false\n");
										}
										else
										{
											gbl_hanpin_bCTRL = true;
											g_writedebug("//home//user//pphanpindebug.txt", "hanpin bCTRL true\n");
										}
									}
									else if(gbl_hanpin_bCTRL)
									{
										gbl_hanpin_bCTRL = false;
										g_writedebug("//home//user//pphanpindebug.txt", "hanpin bCTRL false\n");
									}
								}
							}
						}else	
						{
							if(gbl_bNUMBER)
								oneInfoP = &(gbl_sym_controls[lastCPControl]);
							else
								oneInfoP = &(gbl_controls[lastCPControl]);

							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
							}

							if(gbl_bNUMBER)
                                oneInfoP = &(gbl_sym_controls[idx]);
                            else
                                oneInfoP = &(gbl_controls[idx]);
							
							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
								lastPSControl = idx;
							}
						}
						lastCPControl = -1;
					}
				}else //????綜策???渲麾 -----------------------------------------------------------
				{
					if (lastCPControl != -1)
					{
						if(gbl_bNUMBER)
							oneInfoP = &(gbl_sym_controls[lastCPControl]);
						else
							oneInfoP = &(gbl_controls[lastCPControl]);
						
						if (oneInfoP != 0)
						{
							oneInfoP->m_CtlState = PPOD_CTL_STATE_0;
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
							//?謍船????
						}
						lastCPControl = -1;
					}
				}
			}			
			RePaintScreen(0,0);
			HidePopupWindow();	
			DestroyPopupWindow();
		}

		return TRUE;
*/
}

void set_backspace_timer()
{
    //when BackSpace key is pressed, to set a timer to send signal.
    if(backspace_timerid != 0)
    {
        if(!g_source_remove(backspace_timerid))
        {
            g_writedebug("//home//user//pphanpindebug.txt", "hanpin g_source_remove() error\n");
        }
        backspace_timerid = 0;
    }
    backspace_timerid = g_timeout_add(120, Send_Backspace_KeyEvent, NULL);
    if(backspace_timerid <= 0)
    {
        g_writedebug("//home//user//pphanpindebug.txt", "hanpin g_timeout_add() error\n");
    }
}

void stop_backspace_timer()
{
    //stop timer
    if(backspace_timerid != 0)
    {
        if(!g_source_remove(backspace_timerid))
        {
            g_writedebug("//home//user//pphanpindebug.txt", "hanpin g_source_remove() error\n");
            g_message("hanpin g_source_remove() error\n");
        }
        backspace_timerid = 0;
    }
}
/*
gboolean on_expose_info_event(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{
	GdkPixbuf	*pixbufScreen;
	int width = gdk_pixbuf_get_width(gbl_infowindowImg);
	int height = gdk_pixbuf_get_height(gbl_infowindowImg);
	if(gbl_infowindowImg == NULL || width <= 0 || height <= 0)
		return FALSE;
	pixbufScreen = CaptureScreenEx(80, 40, width, height);
	gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, pixbufScreen, 0, 0, 0, 0, width, height,GDK_RGB_DITHER_NONE, 0, 0);
	
	gdk_draw_pixbuf(gbl_infoDrawArea->window, gbl_infoDrawArea->style->white_gc, gbl_infowindowImg, 0, 0, 0, 0, width, height,GDK_RGB_DITHER_NONE, 0, 0);
}
*/
/*
gboolean on_expose_popupevent(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{
	g_print("on_expose_event\n");

	int 		width, height, x, y, xBgn, yBgn;
	guchar 	*pixelImage, *pixelScreen;
	GdkPixbuf	*pixbufScreen;
	float 		fAlpha = 0.73;	

	gdk_window_get_origin(widget->window, &xBgn, &yBgn);
	g_print("gdk_window_get_origin    : (%d, %d)\n", xBgn, yBgn);

	width = gdk_pixbuf_get_width (gbl_pixbufImage);
	height = gdk_pixbuf_get_height (gbl_pixbufImage);
	pixbufScreen = CaptureScreenEx(xBgn, yBgn, width, height);

	// paint screen pixbuf
	gdk_draw_pixbuf(gbl_popareaP->window, gbl_popareaP->style->white_gc, pixbufScreen, 0, 0, 0, 0, width, height, GDK_RGB_DITHER_NONE, 0, 0); 

	for(x=0; x<width; x++)
	{
		for(y=0; y<height; y++)
		{
			pixelImage = GetPixel(gbl_pixbufImage, x, y);
			pixelScreen = GetPixel(pixbufScreen, x, y);

			
			pixelScreen[0] = pixelImage[0]*fAlpha + pixelScreen[0]*(1-fAlpha); //red;
			pixelScreen[1] = pixelImage[1]*fAlpha + pixelScreen[1]*(1-fAlpha); //green;
			pixelScreen[2] = pixelImage[2]*fAlpha + pixelScreen[2]*(1-fAlpha); //blue;
						
		}
	}

	// set polygon region and paint image pixbuf
	gdk_gc_set_clip_region(gbl_popareaP->style->white_gc, gbl_wndRegion);
	gdk_draw_pixbuf(gbl_popareaP->window, gbl_popareaP->style->white_gc, pixbufScreen, 0, 0, 0, 0, width, height, GDK_RGB_DITHER_NONE, 0, 0);

	// unset region
	gdk_gc_set_clip_rectangle(gbl_areaP->style->white_gc, NULL);	

	g_object_unref (pixbufScreen);

	return TRUE;
}
*/
/*
gboolean CreateInfoWindow()
{	
	if(gbl_language == L_TAIWAN)
        	gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_CHT_PATH,0);
    	else if(gbl_language == L_CHINA)
        	gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_CHS_PATH,0);
	else 
		gbl_infowindowImg = gdk_pixbuf_new_from_file(PIC_INFO_ENG_PATH,0);
	gbl_infoCloseImg = gdk_pixbuf_new_from_file(PIC_INFO_CLOSE_PATH, 0);
	if(gbl_infowindowImg == NULL || gbl_infoCloseImg == NULL)
		return FALSE;
	int width = gdk_pixbuf_get_width(gbl_infowindowImg);
	int height = gdk_pixbuf_get_height(gbl_infowindowImg);

	gbl_infoWindow = gtk_window_new(GTK_WINDOW_POPUP);
	if(gbl_infoWindow == NULL)
		return FALSE;
	gtk_widget_set_usize(gbl_infoWindow, width, height);
	gtk_window_set_resizable(GTK_WINDOW(gbl_infoWindow), FALSE);
	gtk_window_move(GTK_WINDOW(gbl_infoWindow), 80, 40);
	// create paint area in window
	gbl_infoDrawArea = gtk_drawing_area_new();
	gtk_widget_set_size_request(gbl_infoDrawArea, width, height);
	
	if(gbl_infoDrawArea == NULL)
	{
		gtk_widget_destroy(gbl_infoWindow);
		gbl_infoWindow = NULL;
		return FALSE;
	}
	gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "expose_event", GTK_SIGNAL_FUNC(on_expose_info_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "button_press_event", GTK_SIGNAL_FUNC(on_button_press_info_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "button_release_event", GTK_SIGNAL_FUNC(on_button_release_info_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_infoDrawArea), "motion_notify_event",GTK_SIGNAL_FUNC(on_motion_notify_info_event), NULL);	
	gtk_widget_set_events (GTK_WIDGET(gbl_infoDrawArea), GDK_EXPOSURE_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_RELEASE_MASK );

	gtk_container_add(GTK_CONTAINER(gbl_infoWindow), gbl_infoDrawArea);	
	gtk_widget_show_all(gbl_infoWindow);
	GrabMainPointer(gbl_infoDrawArea);
}

gboolean CreatePopupWindow(char *str_path, int posX, int posY)
{
	// get image
	if(gbl_pixbufImage == NULL)
		gbl_pixbufImage = gdk_pixbuf_new_from_file(str_path,0);				

	if(gbl_pixbufImage == NULL)
		return FALSE;	

	// create polygon region for display
	GdkPoint 	points[40] = {{0, 8}, {1,7}, {1, 6},  {2, 5}, {2, 4}, {3, 3}, {4, 2}, {5, 1}, {6, 1}, {7, 0},
	{49, 0}, {50, 1}, {51, 1}, {53, 2},  {54, 3}, {55, 4}, {55, 5}, {56,6}, {56, 7}, {57,8},
	{57, 85}, {56, 87}, {56, 88}, {55, 89}, {54, 90}, {53,91}, {52, 91}, {51, 92}, {50, 92}, {49, 93},
	{8, 93}, {7, 92}, {6, 92}, {5, 91}, {4, 91}, {3, 90}, {2, 89}, {1, 88},  {1, 87}, {0, 85} };
	gbl_wndRegion = gdk_region_polygon(points, 40, GDK_WINDING_RULE);

	// the width & hight of window is same as image
	int width = gdk_pixbuf_get_width (gbl_pixbufImage);
	int height = gdk_pixbuf_get_height (gbl_pixbufImage);

	// create new window
	gbl_popup = gtk_window_new(GTK_WINDOW_POPUP);		

	if(gbl_popup == NULL)
	{
		return FALSE;
	}

	gtk_widget_set_usize(gbl_popup, width, height);
	gtk_window_set_resizable(GTK_WINDOW(gbl_popup), FALSE);

	// move window to any position
	gtk_window_move(GTK_WINDOW(gbl_popup), posX, posY);

	// set widget name, to distinguish this window from another
	gtk_widget_set_name(gbl_popup, "popup");

	// set destroy event can be recieved
	//gtk_signal_connect(GTK_OBJECT(gbl_popup),"delete_event",GTK_SIGNAL_FUNC(on_delete_event),NULL);
	//gtk_signal_connect(GTK_OBJECT(gbl_popup), "destroy", GTK_SIGNAL_FUNC(on_destroy), NULL);

	// create paint area in window
	gbl_popareaP = gtk_drawing_area_new();
	
	if(gbl_popareaP == NULL)
	{
		gtk_widget_destroy(gbl_popup);
		gbl_popup = NULL;
		return FALSE;
	}

	gtk_signal_connect(GTK_OBJECT(gbl_popareaP), "expose_event", GTK_SIGNAL_FUNC(on_expose_popupevent), NULL);	
	//gdk_draw_pixbuf(gbl_popareaP->window, gbl_popareaP->style->white_gc, gbl_pixbufImage, 0, 0, 0, 0, -1, -1, GDK_RGB_DITHER_NONE, 0, 0);
	gtk_container_add(GTK_CONTAINER(gbl_popup), gbl_popareaP);
	gtk_widget_show_all(gbl_popup);

	return TRUE;
}

void DestroyInfoWindow()
{
	if(gbl_infowindowImg)
	{
		g_object_unref(gbl_infowindowImg);
		gbl_infowindowImg = 0;
	}
	if(gbl_infoCloseImg)
	{
		g_object_unref(gbl_infoCloseImg);
		gbl_infoCloseImg = 0;
	}
	if(gbl_infoDrawArea)
	{
		gtk_widget_destroy(gbl_infoDrawArea);
		gbl_infoDrawArea = NULL;
	}
	if(gbl_infoWindow)
	{
		gtk_widget_destroy(gbl_infoWindow);
		gbl_infoWindow = NULL;
	}
}


void DestroyPopupWindow()
{		
	UnGrabMainPointer();
	if(gbl_pixbufImage)
	{
		g_object_unref(gbl_pixbufImage);	
		gbl_pixbufImage = NULL;
	}
	if(gbl_popup != NULL)
	{
		gtk_widget_destroy(gbl_popup);
		gbl_popup = NULL;
	}
}
*/
/*
void ShowInfoWindow()
{
	gbl_binfoshow = true;
	if(gbl_infoWindow == NULL)
		CreateInfoWindow();
	if(gbl_infoWindow)
		gtk_widget_show_all(gbl_infoWindow);
}


void ShowPopupWindow(char *str_path, int posX, int posY)
{	
	if(gbl_popup == NULL)
		CreatePopupWindow(str_path, posX, posY);
	// show popup window
	if(gbl_popup)
		gtk_widget_show(gbl_popup);
}


void HidePopupWindow()
{
	if(gbl_popup)
		gtk_widget_hide(gbl_popup);
}
*/
/*
bool g_writedebug(char * pFilename, wchar_t *OutputString)
{
	FILE* stream = NULL;
	if(pFilename == NULL) return false;
	if(OutputString == NULL) return false;

	if ((stream = fopen(pFilename, "a+")) != NULL)
	{
		if(OutputString != NULL)
		{
			fwrite(OutputString, wcslen(OutputString)*sizeof(wchar_t), 1, stream);
			fclose(stream);
			return true;
		}
		else
			return false;
	}
}
*/
void OutputDebugMessage(char * pmsg)
{

#ifdef __DUMP_DEBUG_MESSAGE__	
	if(cur_ic != -1 )
	{
		WideString str;		
		int len = strlen (pmsg);
		for(int i = 0; i < len ; i++)
		{
			str.push_back (  *(pmsg+i)  );
		}

		m_agent->commit_string (cur_ic, cur_uuid, str);
	}
#else

#endif
}

void WOutputDebugMessage(wchar_t * pstr)
{

#ifdef __DUMP_DEBUG_MESSAGE__	
	if((cur_ic != -1 )&& (pstr))
	{
		m_agent->commit_string (cur_ic, cur_uuid, pstr);
	}
#else

#endif
}

bool g_writedebug(char * pFilename, char *OutputString)
{
#ifdef __DUMP_DEBUG_MESSAGE__
    FILE* stream = NULL;
    if(pFilename == NULL) return false;
    if(OutputString == NULL) return false;

    if ((stream = fopen(pFilename, "a+")) != NULL)
    {
        if(OutputString != NULL)
        {
            fwrite(OutputString, strlen(OutputString)*sizeof(char), 1, stream);
            fclose(stream);
            return true;
        }
        else
            return false;
    }
#else
    if(OutputString != NULL)
        g_message(OutputString);
#endif
    return true;
}

/*
void ConfigureKey(int keyindex, bool b_find)
{	
	if(gbl_active_number > 0)
	{
		if(gbl_controls[keyindex].m_CtlID != BUTTON_CLOSE_ID &&	gbl_controls[keyindex].m_CtlID != BUTTON_BK_ID)
		{	
			gbl_controls[keyindex].m_disable = DISABLE;
		}
	}
	else
	{
		if(b_find)
		{
			//g_writedebug("./home/enable.txt", "enable");
			gbl_controls[keyindex].m_disable = ENABLE;
		}
		else
		{
			if(gbl_b_root)
			{//have root
				if( gbl_controls[keyindex].m_CtlID == BUTTON_BK_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_ENTER_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_CAPS_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_INFO_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_CLOSE_ID)
				{
					gbl_controls[keyindex].m_disable = ENABLE;
				}
				else
				{
					gbl_controls[keyindex].m_disable = DISABLE;
				}
			
			}
			else
			{
				if( gbl_controls[keyindex].m_CtlID == BUTTON_BK_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_ENTER_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_TAB_ID ||
					//gbl_controls[keyindex].m_CtlID == BUTTON_CAPS_ID || // `Adisable caps 
					gbl_controls[keyindex].m_CtlID == BUTTON_NUMBER_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_SEMI_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_QUOTE_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_EXCLAM_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_QUEST_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_COMMA_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_DOT_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_DASH_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_SLASH_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_CLOSE_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_CTRL_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_INFO_ID ||
					gbl_controls[keyindex].m_CtlID == BUTTON_SPACE_ID)
				{
					gbl_controls[keyindex].m_disable = ENABLE;
				}
				else
				{
					gbl_controls[keyindex].m_disable = DISABLE;
				}
			}
		}
	}
}
*/
/*
void ConfigureKeyboard(wchar_t * pRootString, bool b_ctrl)
{
	wchar_t *pwChar = NULL;		
	int cKeyIndex = 0;
	bool b_find = false;
	wchar_t pwtemp[2];
			
	if(b_ctrl)
	{
		while(cKeyIndex < gbl_key_number)
		{
			if(gbl_controls[cKeyIndex].m_CtlID == BUTTON_BOARD_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_SEMI_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_QUOTE_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_EXCLAM_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_QUEST_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_COMMA_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_DOT_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_DASH_ID ||
			   gbl_controls[cKeyIndex].m_CtlID == BUTTON_SLASH_ID )
				gbl_controls[cKeyIndex].m_disable = DISABLE;
			else
				gbl_controls[cKeyIndex].m_disable = ENABLE;
			cKeyIndex++;
		}
		return;
	}

	if(pRootString == NULL)
	{
		init_hanpin_controls();
		return;
	}

	int strlen = 0;		
	while( cKeyIndex < gbl_key_number)
	{				
		//pwChar = wcsstr(pRootString, gbl_keymap[cKeyIndex].m_keywchar);
		if(pRootString != NULL)
			strlen = wcslen(pRootString);
		else
			strlen = 0;
		for(int idx = 0; idx < strlen; idx++)
		{
			b_find = false;
			memset(pwtemp, 0, 2*sizeof(wchar_t));
			pwtemp[0] = pRootString[idx];
			if(wcscmp(gbl_hanpin_keymap[cKeyIndex].m_keywchar1, L"") != 0)
			{
				if(wcCompareTo(pwtemp[0], gbl_hanpin_keymap[cKeyIndex].m_keywchar1[0], true) == 0)
				{
					b_find = true;
					break;
				}
			}
		}

//		if(wcscmp(gbl_hanpin_keymap[cKeyIndex].m_keywchar1, L"") != 0)
//		{
//			//字根不存在，為符號				
//			b_find = false;
//			//pwChar = NULL;
//		}

		ConfigureKey(cKeyIndex, b_find);
		cKeyIndex++;
	}	

}
*/
int CheckScreenMode()
{
	gint 			x;
	GdkScreen		*screen    = NULL;
	screen = gdk_screen_get_default();
	x = gdk_screen_get_width (screen);

	// g_message("screen width: %d pixels", x);

	if(x > 960)
	{
		return 1;
	}

	return 0;
}

int MyCommand_CALLBACKPROC(int iCmd,void *infoP,void *userDef)
{
	int iScanCode;
	int iModifyState;
	char utf8_char[32] = "";
	gunichar dest_ucs4;
	gunichar *ucs4string = NULL;
	int i = 0;
	GError *gerror;
	PPCtlInfo *oneInfoP = (PPCtlInfo *)infoP;
	iScanCode = PPLOWORD(iCmd);
	iModifyState = PPHIWORD(iCmd);
	
	if (PPVK_ABOUT == iScanCode)
	{
		if(g_minwindowmode)
		{
			g_minwindowmode = false;
			
			if(CheckScreenMode() == 0)
			{
				gtk_widget_set_usize(gbl_win, 768, 200);	//small mode
			}
			else
			{
				gtk_widget_set_usize(gbl_win, 960, 250);	//big mode
			}
		}
		else
		{
			//ܸT  
			ShowInfoWindow();
		}
	}
	else if (PPVK_MINWIN == iScanCode)
	{
		g_minwindowmode = true;
		if(CheckScreenMode() == 0)
		{
			//small layout
			gtk_widget_set_usize(gbl_win, 50, 25);
		}
		else
		{
			//large layout
			gtk_widget_set_usize(gbl_win, 64, 32);
		}
	}
	else if (PPVK_CLOSEWIN == iScanCode)
	{
		forward_key_ctrlspace_clicked();
	}
	else if(  (iScanCode == PPEDINFO_CADIDATE1) ||
			  (iScanCode == PPEDINFO_CADIDATE2) ||
			  (iScanCode == PPEDINFO_CADIDATE3) ||
			  (iScanCode == PPEDINFO_CADIDATE4) ||
			  (iScanCode == PPEDINFO_CADIDATE5) ||
			  (iScanCode == PPEDINFO_CADIDATE6) ||
			  (iScanCode == PPEDINFO_CADIDATE7) ||
			  (iScanCode == PPEDINFO_CADIDATE8) )
	{
/*		if(wcslen(oneInfoP->m_keywchar) > 0)
		{
			gchar szptmp[1024];
			gchar szptmptr[64];
			char * pz;
			int itotallen = 0;
			memset(szptmp, 0, sizeof(szptmp));
			memset(szptmptr, 0, sizeof(szptmptr));
			pz = szptmp;

			int wlen = wcslen(oneInfoP->m_keywchar);
			int iltmp = 0;

			for(int i= 0; i<wlen; i++)
			{
				iltmp = g_unichar_to_utf8(*(oneInfoP->m_keywchar+i), szptmptr);
				itotallen += iltmp;
				if(pz + iltmp <=  szptmp+1024)
				{
					strcat(pz, szptmptr);
					pz = pz + iltmp;
					memset(szptmptr, 0, sizeof(szptmptr));
				}			
			}

			gbl_StrPos.sp_post_string(szptmp);

			//[Jpriority
			gbl_PPbopomo.SelectCandidate(oneInfoP->m_keywchar[0]);

			//Mæ^_lA
			memset(gbl_PPbopomo.m_preedit_wstring, 0,sizeof(gbl_PPbopomo.m_preedit_wstring));
			memset(gbl_PPbopomo.m_PreeditString, 0,sizeof(gbl_PPbopomo.m_PreeditString));
			memset(gbl_PPbopomo.m_CandicateString, 0,sizeof(gbl_PPbopomo.m_CandicateString));
			gbl_PPKeyboard.ConfigureKB(NULL);
			gbl_PPeditinfo.UpdateCandidateString(gbl_PPbopomo.m_CandicateString);
			gbl_PPeditinfo.UpdatePreeditString(gbl_PPbopomo.m_preedit_wstring);
		}
*/
	}
	else
	{	
		guint keycode = 0;
		KeyEvent key;

		switch(iScanCode)
		{
		case PPVK_BACK:
			{
				keycode = SCIM_KEY_BackSpace;
			}
			break;
		case PPVK_SPACE:
			{
				keycode = SCIM_KEY_space;
			}
			break;
		case PPVK_TAB:
			{
				keycode = SCIM_KEY_Tab;
			}
			break;
		case PPVK_RETURN:
			{
				keycode = SCIM_KEY_Return;
			}
			break;
		case PPVK_ESCAPE:
			{
				keycode = PPVK_ESCAPE;
			}
			break;
		case '1':
			{
				keycode = SCIM_KEY_1;
			}
			break;
		case '2':
			{
				keycode = SCIM_KEY_2;
			}
			break;
		case '3':
			{
				keycode = SCIM_KEY_3;
			}
			break;
		case '4':
			{
				keycode = SCIM_KEY_4;
			}
			break;
		case '5':
			{
				keycode = SCIM_KEY_5;
			}
			break;
		case '6':
			{
				keycode = SCIM_KEY_6;
			}
			break;
		case '7':
			{
				keycode = SCIM_KEY_7;
			}
			break;
		case '8':
			{
				keycode = SCIM_KEY_8;
			}
			break;
		case '9':
			{
				keycode = SCIM_KEY_9;
			}
			break;
		case '0':
			{
				keycode = SCIM_KEY_0;
			}
			break;
		case '"':
			{
				wchar_t temp1[]= L"¨";
				if( gbl_PPKeyboard.GetCaseInfo() == 1) 
					m_agent->commit_string(cur_ic, cur_uuid,temp1);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"\"");
			}
			break;
		case ':':
			{
				wchar_t temp2[]= L"：";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp2);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L":");
				
			}
			break;
		case ';':
			{
				wchar_t temp3[]= L"；";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp3);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L";");
			}
			break;
		case '\'':
			{
				wchar_t temp4[]= L"´";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp4);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"\'");
			}
			break;
		case ',':
			{
				wchar_t temp5[]= L"，";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid,temp5 );
				else
					m_agent->commit_string(cur_ic, cur_uuid,L",");
			}
			break;
		case '.':
			{
				wchar_t temp6[]= L"。";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp6);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L".");
			}
			break;
		case '!':
			{
				wchar_t temp7[]= L"！";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid,temp7 );
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"!");
			}
			break;
		case '?':
			{
				wchar_t temp8[]= L"？";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp8);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"?");
			}
			break;
		case '-':
			{
				wchar_t temp9[]= L"－";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp9);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"-");
			}	
			break;
		case '+':
			{
				wchar_t temp0[]= L"＋";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp0);
				else 
					m_agent->commit_string(cur_ic, cur_uuid, L"+");
			}
			break;
		case '=':
			{
				wchar_t temp10[]= L"＝";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp10);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"=");
			}
			break;
		case '\\':
			{
				wchar_t temp11[]= L"＼";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp11);
				else
					m_agent->commit_string(cur_ic, cur_uuid, L"\\");
			}
			break;
		case '/':
			{
				wchar_t temp12[]= L"／";
				if( gbl_PPKeyboard.GetCaseInfo() == 1)
					m_agent->commit_string(cur_ic, cur_uuid, temp12);
				else 
					m_agent->commit_string(cur_ic, cur_uuid, L"/");
			}
		case PPVK_NONE:
			{
				if(wcslen(oneInfoP->m_keywchar) >0)
				{
					if( wcscmp(oneInfoP->m_keywchar, L"A") == 0 )
					{	keycode = SCIM_KEY_A;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"B") == 0 )
					{	keycode = SCIM_KEY_B;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"C") == 0 )
					{	keycode = SCIM_KEY_C;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"D") == 0 )
					{	keycode = SCIM_KEY_D;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"E") == 0 )
					{	keycode = SCIM_KEY_E;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"F") == 0 )
					{	keycode = SCIM_KEY_F;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"G") == 0 )
					{	keycode = SCIM_KEY_G;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"H") == 0 )
					{	keycode = SCIM_KEY_H;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"I") == 0 )
					{	keycode = SCIM_KEY_I;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"J") == 0 )
					{	keycode = SCIM_KEY_J;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"K") == 0 )
					{	keycode = SCIM_KEY_K;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"L") == 0 )
					{	keycode = SCIM_KEY_J;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"M") == 0 )
					{	keycode = SCIM_KEY_M;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"N") == 0 )
					{	keycode = SCIM_KEY_N;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"O") == 0 )
					{	keycode = SCIM_KEY_O;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"P") == 0 )
					{	keycode = SCIM_KEY_P;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"Q") == 0 )
					{	keycode = SCIM_KEY_Q;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"R") == 0 )
					{	keycode = SCIM_KEY_R;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"S") == 0 )
					{	keycode = SCIM_KEY_S;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"T") == 0 )
					{	keycode = SCIM_KEY_T;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"U") == 0 )
					{	keycode = SCIM_KEY_U;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"V") == 0 )
					{	keycode = SCIM_KEY_V;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"W") == 0 )
					{	keycode = SCIM_KEY_W;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"X") == 0 )
					{	keycode = SCIM_KEY_X;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"Y") == 0 )
					{	keycode = SCIM_KEY_Y;	}
					else if( wcscmp(oneInfoP->m_keywchar, L"Z") == 0 )
					{	keycode = SCIM_KEY_Z;	}
				}
			}
			break;
		}

		if(keycode != 0)
		{
			key = KeyEvent (keycode, SCIM_KEY_NullMask);
			KeyEvent key_release = KeyEvent (keycode, SCIM_KEY_ReleaseMask);
			m_agent->send_key_event (cur_ic, cur_uuid, key);
			m_agent->send_key_event (cur_ic, cur_uuid, key_release);
		}
			

/*		bool bnotsendback = false;
		if( (PPVK_BACK == iScanCode) || (PPVK_SPACE == iScanCode) || (PPVK_NONE == iScanCode))
		{
			//pGrڵLr, BԿrr, eXĤ@Ӧr
			if(wcslen(gbl_PPbopomo.m_preedit_wstring) == 0)
			{
				//pGԿr, eXĤ@Ӧr
				wchar_t* cand1 = gbl_PPeditinfo.GetCandidateStr(PPEDINFO_CADIDATE1);
				if(cand1)
				{
					if(wcslen(cand1)>0)
					{
						gchar szptmp[1024];
						gchar szptmptr[64];
						char * pz;
						int itotallen = 0;
						memset(szptmp, 0, sizeof(szptmp));
						memset(szptmptr, 0, sizeof(szptmptr));
						pz = szptmp;

						int wlen = wcslen(cand1);
						int iltmp = 0;

						for(int i= 0; i<wlen; i++)
						{
							iltmp = g_unichar_to_utf8(*(cand1+i), szptmptr);
							itotallen += iltmp;
							if(pz + iltmp <=  szptmp+1024)
							{
								strcat(pz, szptmptr);
								pz = pz + iltmp;
								memset(szptmptr, 0, sizeof(szptmptr));
							}			
						}

						if(PPVK_BACK != iScanCode) 
						{
							gbl_StrPos.sp_post_string(szptmp);
						}
						else
						{
							bnotsendback = true;
						}
						
						//Mæ^_lA
						memset(gbl_PPbopomo.m_preedit_wstring, 0,sizeof(gbl_PPbopomo.m_preedit_wstring));
						memset(gbl_PPbopomo.m_PreeditString, 0,sizeof(gbl_PPbopomo.m_PreeditString));
						memset(gbl_PPbopomo.m_CandicateString, 0,sizeof(gbl_PPbopomo.m_CandicateString));
						gbl_PPKeyboard.ConfigureKB(NULL);
						gbl_PPeditinfo.UpdateCandidateString(gbl_PPbopomo.m_CandicateString);
						gbl_PPeditinfo.UpdatePreeditString(gbl_PPbopomo.m_preedit_wstring);	
					}
				}	
			}
		

			//Bzbackspace
			if((PPVK_BACK == iScanCode) && (gbl_PPbopomo.GetPreeditStringLen() <= 0))
			{	
				if( bnotsendback && (PPVK_BACK == iScanCode) ) 
				{
				}
				else
				{
					gbl_StrPos.sp_post_command(iScanCode,iModifyState);
				}

				return false;
			}
			else if((PPVK_BACK == iScanCode) && (gbl_PPbopomo.GetPreeditStringLen() > 0))
			{
				//preedit string ֤@
				int plen = wcslen(gbl_PPbopomo.m_preedit_wstring);
				if(plen > 0)
				{
					// Ӧr̫@Ӧr -1
					gbl_PPbopomo.m_preedit_wstring[plen-1] = 0;
					WOutdebugstring(gbl_PPbopomo.m_preedit_wstring);
					gbl_PPbopomo.CimConfigure(gbl_PPbopomo.m_preedit_wstring);

					if(gbl_PPbopomo.m_pRootString != NULL)
					{
						memset(gbl_PPbopomo.m_PreeditString, 0, sizeof(gbl_PPbopomo.m_PreeditString));
						wcscpy(gbl_PPbopomo.m_PreeditString, gbl_PPbopomo.m_pRootString);
						//Mǰe edit string 
						WOutdebugstring(gbl_PPbopomo.m_PreeditString);
						gbl_PPKeyboard.ConfigureKB(gbl_PPbopomo.m_PreeditString);
					}
					else
					{
						memset(gbl_PPbopomo.m_preedit_wstring, 0,sizeof(gbl_PPbopomo.m_preedit_wstring));
						gbl_PPKeyboard.ConfigureKB(NULL);
						WOutdebugstring(gbl_PPbopomo.m_CandicateString);
						gbl_PPeditinfo.UpdateCandidateString(gbl_PPbopomo.m_CandicateString);
					}

					gbl_PPeditinfo.UpdatePreeditString(gbl_PPbopomo.m_preedit_wstring);
				}
				else
				{
					gbl_StrPos.sp_post_command(iScanCode,iModifyState);
				}
				
				return false;
			}
			//BzWeXspace
			if(PPVK_SPACE == iScanCode)
			{
				if( (gbl_PPbopomo.GetPreeditStringLen() == 0) ||
					(gbl_PPbopomo.GetPreeditStringLen() == PPDEFAULT_BOPOMO_ROOTNUMBER) )
				{
					gbl_StrPos.sp_post_command(iScanCode,iModifyState);
					return false;
				}
			}
			i = g_unichar_to_utf8((gunichar)*(oneInfoP->m_keywchar), utf8_char);

			if(i <= 0) return 0;
			ucs4string = g_utf8_to_ucs4(utf8_char, 3, NULL, NULL, &gerror);

			if(ucs4string == NULL) return true;
			memcpy(&dest_ucs4, ucs4string, sizeof(gunichar));
			g_free(ucs4string);
			wcscat(gbl_PPbopomo.m_preedit_wstring, oneInfoP->m_keywchar);
			gbl_PPbopomo.CimConfigure(gbl_PPbopomo.m_preedit_wstring); 

			if(gbl_PPbopomo.m_pRootString != NULL)
			{
				memset(gbl_PPbopomo.m_PreeditString, 0, sizeof(gbl_PPbopomo.m_PreeditString));
				wcscpy(gbl_PPbopomo.m_PreeditString, gbl_PPbopomo.m_pRootString);
				//Mǰe edit string 
				gbl_PPeditinfo.UpdatePreeditString(gbl_PPbopomo.m_preedit_wstring);
				gbl_PPeditinfo.UpdateCandidateString(gbl_PPbopomo.m_CandicateString);
				gbl_PPKeyboard.ConfigureKB(gbl_PPbopomo.m_PreeditString);
			}
			else
			{
				memset(gbl_PPbopomo.m_preedit_wstring, 0, sizeof(gbl_PPbopomo.m_preedit_wstring));
				gbl_PPeditinfo.UpdatePreeditString(gbl_PPbopomo.m_preedit_wstring);
				gbl_PPeditinfo.UpdateCandidateString(gbl_PPbopomo.m_CandicateString);
				gbl_PPKeyboard.ConfigureKB(NULL);
			}

		}
		else
		{	
			if( gbl_PPKeyboard.GetCaseInfo() == 1) 
			{
				//, BOݭnܪIŸ
				if('"' == iScanCode)
				{
					wchar_t temp1[]= L"¨";
					PostOneWcharto(*temp1);
				}
				else if(':' == iScanCode)
				{
					wchar_t temp2[]= L"：";
					PostOneWcharto(*temp2);
				}
				else if(';' == iScanCode)
				{
					wchar_t temp3[]= L"；";
					PostOneWcharto(*temp3);
				}
				else if('\'' == iScanCode)
				{
					wchar_t temp4[]= L"´";
					PostOneWcharto(*temp4);
				}
				else if(',' == iScanCode)
				{
					wchar_t temp5[]= L"，";
					PostOneWcharto(*temp5);
				}
				else if('.' == iScanCode)
				{
					wchar_t temp6[]= L"。";
					PostOneWcharto(*temp6);
				}
				else if('!' == iScanCode)
				{
					wchar_t temp7[]= L"！";
					PostOneWcharto(*temp7);
				}
				else if('?' == iScanCode)
				{
					wchar_t temp8[]= L"？";
					PostOneWcharto(*temp8);	
				}
				else if('-' == iScanCode)
				{
					wchar_t temp9[]= L"－";
					PostOneWcharto(*temp9);	
				}	
				else if('+' == iScanCode)
				{
					wchar_t temp0[]= L"＋";
					PostOneWcharto(*temp0);	
				}
				else if('=' == iScanCode)
				{
					wchar_t temp10[]= L"＝";
					PostOneWcharto(*temp10);	
				}
				else if('\\' == iScanCode)
				{
					wchar_t temp11[]= L"＼";
					PostOneWcharto(*temp11);	
				}
				else if('/' == iScanCode)
				{
					wchar_t temp12[]= L"／";
					PostOneWcharto(*temp12);
				}		
				else
				{
					gbl_StrPos.sp_post_command(iScanCode,iModifyState);
				}
				return 0;
			}
			else
			{
				if('"' == iScanCode)
				{
					char temp1[]= "\"";
					gbl_StrPos.sp_post_string(temp1);
				}
				else if('\'' == iScanCode)
				{
					char temp2[]= "'";
					gbl_StrPos.sp_post_string(temp2);
				}
				else
				{
					gbl_StrPos.sp_post_command(iScanCode,iModifyState);
				}				
			}
		}
*/
	}

	return 0;
}



static void run (const String &display)
{
    char **argv = new char * [4];
    int    argc = 1;
    argv [0] = "pphanpin-helper";
    argv [1] = 0;

    HelperAgent	agent;	
    GtkWidget *widget;        			
    GtkWidget *button;
    wchar_t *pRootChar = NULL;
	
    gtk_set_locale();
    gtk_init(&argc, &argv);
    setenv ("DISPLAY", display.c_str (), 1);

	gbl_win = gtk_window_new(GTK_WINDOW_POPUP);
    g_writedebug("//home//user//pphanpindebug.txt", "hanpin helper run() begin \n");
	
	// main.cpp global information
	if (CheckScreenMode() == 0)
	{
		gtk_widget_set_usize(gbl_win, 768, 200);	//small mode
		gbl_KeybdPixMaps[0] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_small_half.png",0);
		gbl_KeybdPixMaps[1] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_small_half_down.png",0);
		gbl_KeybdPixMaps[2] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_small_full.png",0);
		gbl_KeybdPixMaps[3] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_small_full_down.png",0);
	}
	else
	{
		gtk_widget_set_usize(gbl_win, 960, 250);	//big mode
		gbl_KeybdPixMaps[0] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_large_half.png",0);
		gbl_KeybdPixMaps[1] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_large_half_down.png",0);
		gbl_KeybdPixMaps[2] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_large_full.png",0);
		gbl_KeybdPixMaps[3] = gdk_pixbuf_new_from_file("//usr//share//scim//pphanpin//pic//hanpinkb_large_full_down.png",0);	
	}

	gtk_window_set_resizable(GTK_WINDOW(gbl_win),FALSE);
	gbl_areaP = gtk_drawing_area_new();

	// caption & keyboard informations
	if (CheckScreenMode() == 0)
	{
		gbl_PPCaption.SetOrgXYWH(0,0,768,24);
		gbl_PPCaption.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPCaption.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPCaption.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPCaption.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPCaption.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPCaption.init_controls(0);
		gbl_PPCaption.SetCommandCallBack(MyCommand_CALLBACKPROC,0);
/*		
		gbl_PPeditinfo.SetOrgXYWH(0,24,768, 60-24); //]we
		gbl_PPeditinfo.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPeditinfo.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPeditinfo.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPeditinfo.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPeditinfo.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPeditinfo.init_controls(0);
		gbl_PPeditinfo.SetCommandCallBack(MyCommand_CALLBACKPROC,0);
*/
		gbl_PPKeyboard.SetOrgXYWH(0,24,768,200-24);
		gbl_PPKeyboard.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPKeyboard.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPKeyboard.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPKeyboard.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPKeyboard.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPKeyboard.init_controls(0);
		gbl_PPKeyboard.SetCommandCallBack(MyCommand_CALLBACKPROC,0);

	}else
	{
		gbl_PPCaption.SetOrgXYWH(0,0,960,30);
		gbl_PPCaption.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPCaption.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPCaption.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPCaption.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPCaption.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPCaption.init_controls(1);
		gbl_PPCaption.SetCommandCallBack(MyCommand_CALLBACKPROC,0);
/*
		gbl_PPeditinfo.SetOrgXYWH(0,30,960, 71-30);
		gbl_PPeditinfo.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPeditinfo.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPeditinfo.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPeditinfo.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPeditinfo.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPeditinfo.init_controls(1);
		gbl_PPeditinfo.SetCommandCallBack(MyCommand_CALLBACKPROC,0);
*/
		gbl_PPKeyboard.SetOrgXYWH(0,30,960,250-30);
		gbl_PPKeyboard.SetDrawWinInfo(gbl_win,gbl_areaP);
		gbl_PPKeyboard.SetDrawPixbufNormal(gbl_KeybdPixMaps[0]);
		gbl_PPKeyboard.SetDrawPixbufDown(gbl_KeybdPixMaps[1]);
		gbl_PPKeyboard.SetDrawPixbufNormal_Big(gbl_KeybdPixMaps[2]);
		gbl_PPKeyboard.SetDrawPixbufDown_Big(gbl_KeybdPixMaps[3]);
		gbl_PPKeyboard.init_controls(1);
		gbl_PPKeyboard.SetCommandCallBack(MyCommand_CALLBACKPROC,0);	
	}

 /*  
    gbl_RootString.clear();
    gbl_active_number = 0;


    gbl_win = input_pad_window_new ();
    

    gtk_widget_set_usize(gbl_win, 800, 184);
    gtk_window_set_resizable (GTK_WINDOW (gbl_win), FALSE);

    gtk_widget_hide (gbl_win);
    gbl_controlsImgP1 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/china.bmp",0);
    gbl_controlsImgP2 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/eng_capital.bmp",0);
	gbl_controlsImgP3 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/symbols.bmp",0);
	gbl_controlsImgP4 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/symbols_changinput.bmp",0);

    gbl_controlsDisImgP1 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/china_disable.bmp",0);
    gbl_controlsDisImgP2 = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/eng_capital_disable.bmp",0);
    gbl_closeImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/close_on_a.bmp",0);
    gbl_delImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/del_on_a.bmp",0);
    gbl_enterImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/enter_on_a.bmp",0);
    gbl_tabImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/tab_on_a.bmp",0);
    gbl_ctrlImgPD = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/ctrl_on_a.bmp",0);
    gbl_ctrlImgPU = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/ctrl_on_b.bmp",0);
    gbl_capsImgPL = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/shift_over.bmp",0);
    gbl_capsImgPU = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/shift_over2.bmp",0);
    gbl_spaceImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/space_on_a.bmp",0);
    gbl_infoImgP =  gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/about.png",0);
    gbl_press_infoImgP = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/about_over.png",0);
	gbl_numImgPD = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/123.bmp",0);
	gbl_abcImgPD = gdk_pixbuf_new_from_file("./usr/share/scim/pphanpin/pic/abc_over.bmp",0);

	gbl_areaP = gtk_drawing_area_new();
	//gtk_widget_realize(gbl_areaP);
	gtk_widget_set_size_request(gbl_areaP, 800, 184);
	//g_writedebug("./home/initcon.txt", "initcon");

	init_sym_controls();
	init_hanpin_controls();
	
	gbl_key_number = init_hanpinkeymap(gbl_hanpin_keymap);	
	gbl_symkey_number = init_sym_keymap();	
    //preedit_string_len = 0;

	//CimConfigure(pRootChar);	

	CUnicodeStringList StringList;
	size_t n = 0;
	
	// 1. get available roots.
	cim.GetAvailableRoots(pRootChar, false, &StringList);

	// 2. get number of available roots.
	n = cim.GetCountOfAvailableRoots(&StringList);

	if(n>0)
	{
		pRootString = new wchar_t[n+1];	// zero ending string.
		// 3. get wide character array. 
		cim.GetAvailableRootsArray(&StringList, pRootString, n+1);
		ConfigureKeyboard(pRootString, n+1, pRootChar);
	}
	//OutputDebugString(pRootString);
	//OutputDebugString(L"\r\n");
	//delete [] pRootString;
	//pRootString = NULL;

	// 4. if you want reuse CUnicodeStringList, suggest clear it's content before using.
	StringList.Clear();
*/
	gtk_signal_connect(GTK_OBJECT(gbl_areaP), "expose_event", GTK_SIGNAL_FUNC(on_expose_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_areaP), "button_press_event", GTK_SIGNAL_FUNC(on_button_press_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_areaP), "button_release_event", GTK_SIGNAL_FUNC(on_button_release_event), NULL);
	gtk_signal_connect(GTK_OBJECT(gbl_areaP), "motion_notify_event",GTK_SIGNAL_FUNC(on_motion_notify_event), NULL);	
	
	gtk_widget_set_events (GTK_WIDGET(gbl_areaP), GDK_EXPOSURE_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK | GDK_BUTTON_RELEASE_MASK );
	
	gtk_container_add(GTK_CONTAINER(gbl_win), gbl_areaP);

	agent.signal_connect_exit (slot (slot_exit));
	agent.signal_connect_attach_input_context (slot (slot_attach_input_context));
	agent.signal_connect_update_screen (slot (slot_update_screen));
	agent.signal_connect_detach_input_context (slot (slot_detach_input_context));
	agent.signal_connect_update_spot_location (slot (slot_update_spot_location));
	agent.signal_connect_process_imengine_event (slot (slot_process_imengine_event));

	//signal(SIGALRM, Timer_Response);

    int fd = agent.open_connection (__helper_info, display);
    GIOChannel *ch = g_io_channel_unix_new (fd);

    if (fd < 0 || !ch) {
		std::cerr << "Unable to open the connection to Panel.\n";
		exit (-1);
    }

	m_agent = &agent;
    g_io_add_watch (ch, G_IO_IN, agent_input_handler, (gpointer) &agent);
    g_io_add_watch (ch, G_IO_ERR, agent_input_handler, (gpointer) &agent);
    g_io_add_watch (ch, G_IO_HUP, agent_input_handler, (gpointer) &agent);

    g_writedebug("//home//user//pphanpindebug.txt", "hanpin helper run() exit\n");
    gtk_main ();
}

/*
vi:ts=4:nowrap:ai:expandtab
*/
