#include "libsnd.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>

static int getSocket(char* path)
{
	int s;
	struct sockaddr_un addr;
	if(path == NULL)
		return -1;
	s = socket(PF_LOCAL, SOCK_DGRAM, 0);
	if(s == -1)
		return s;
	memset(&addr, 0, sizeof(struct sockaddr_un));
	addr.sun_family = AF_LOCAL;
	strncpy(addr.sun_path, path, sizeof(addr.sun_path) - 1);

	if(connect(s, (struct sockaddr*)&addr, sizeof(struct sockaddr_un)) == -1){
		close(s);
		return -1;
	}
	return s;
}

snd_handler_t snd_connect()
{
	return getSocket("/tmp/.sound.sock");
}

int snd_play(snd_handler_t handler, const char* filename)
{
	char buf[1024];
	int s = handler;
	int r;
	*(unsigned short*)buf = strlen(filename)+1;
	r = send(s, buf, 2, 0);
	if(r != 2)
		return -1;
	memcpy(buf+2, filename, strlen(filename)+1);
	r = send(s, buf+2, strlen(filename)+1, 0);
	if(r != strlen(filename)+1)
		return -1;
	printf("%d:%s\n", *(unsigned short*)buf, buf+2);
	return 0;
}

void snd_disconnect(snd_handler_t handler)
{
	close(handler);
}

