#include "UnicodeStringList.h"

CUnicodeStringList::CUnicodeStringList(void)
{
}

CUnicodeStringList::~CUnicodeStringList(void)
{
}


void CUnicodeStringList::ClearData(ListNode* pNode)
{
	if(pNode->Data != NULL)
	{
		CUnicodeString* pData = (CUnicodeString*)pNode->Data;
		pData->Dispose();

		// delete pNode->Data; 
		// ==> Releasing memory by void* pointer will cause Memory leak.

		delete pData;
		pNode->Data = NULL;
	}
}

bool CUnicodeStringList::AreDataEqual(void* pDataA, void* pDataB, LLEqualOption nOption)
{
	if(pDataA != NULL && pDataB != NULL)
	{
		CUnicodeString* pUSA = (CUnicodeString*)pDataA;
		CUnicodeString* pUSB = (CUnicodeString*)pDataB;

		bool bIgnoreCase = (nOption == BY_STRING_IGNORECASE) ? true : false;

		return pUSA->Equals(pUSB, bIgnoreCase);
	}
	else
	{
		return false;
	}
}


// a > b return 1
// a == b return 0
// a < b return -1
int CUnicodeStringList::Comparer(void* pDataA, void* pDataB, LLCompareOption nOption)
{
	if(pDataA == NULL || pDataB == NULL) return 0;

	CUnicodeString* pUStrA = (CUnicodeString*)pDataA;
	CUnicodeString* pUStrB = (CUnicodeString*)pDataB;

	bool bIgnoreCase = false;
	
	if( nOption == DES_BY_STRING_IGNORECASE || 
		nOption == ASC_BY_STRING_IGNORECASE )
	{
		bIgnoreCase = true;
	}

	int result = pUStrA->CompareTo(pUStrB, bIgnoreCase);

	switch(nOption)
	{
	// Descending by string.
	case DES_BY_STRING: 
	case DES_BY_STRING_IGNORECASE:
		return result;

	// Ascending by string.
	case ASC_BY_STRING:
	case ASC_BY_STRING_IGNORECASE:
		{
			if(result > 0) return -1;
			else if(result < 0) return 1;
			else return 0;
		}

	default:
		return 0;
	}
}


//	Node*			pNode = NULL;
//	CUnicodeString*	pData = NULL;
//
//	while((pData = DumpData(&pNode)) != NULL)
//	{
//		...
//	}
CUnicodeString* CUnicodeStringList::DumpData(ListNode** pNode)
{
	return (CUnicodeString*)CLinkedList::GetData(pNode);
}
