#include "PriorityList.h"

CPriorityList::CPriorityList(void)
{
}

CPriorityList::~CPriorityList(void)
{
	this->Clear();
}


void CPriorityList::ClearData(ListNode* pNode)
{
	if(pNode->Data != NULL)
	{
		PriorityData* pData = (PriorityData*)pNode->Data;

		// delete pNode->Data; 
		// ==> Releasing memory by void* pointer will cause Memory leak.

		delete pData;
		pNode->Data = NULL;
	}
}

bool CPriorityList::AreDataEqual(void* pDataA, void* pDataB, LLEqualOption nOption)
{
	if( pDataA != NULL && 
		pDataB != NULL &&
		nOption == BY_ID )
	{
		PriorityData* pPDA = (PriorityData*)pDataA;
		PriorityData* pPDB = (PriorityData*)pDataB;

		if( (pPDA->CandidateIndexID == pPDB->CandidateIndexID) &&
			(pPDB->CandidateWordID == pPDB->CandidateWordID) )
			return true;
		else
			return false;
	}
	else
	{
		return false;
	}
}


// a > b return 1
// a == b return 0
// a < b return -1
int CPriorityList::Comparer(void* pDataA, void* pDataB, LLCompareOption nOption)
{
	if(pDataA == NULL || pDataB == NULL) return 0;

	PriorityData* pPDA = (PriorityData*)pDataA;
	PriorityData* pPDB = (PriorityData*)pDataB;

	int result = 0;

	if(pPDA->CandidateIndexID > pPDB->CandidateIndexID)
	{
		result = 1;
	}
	else if(pPDA->CandidateIndexID == pPDB->CandidateIndexID)
	{
		if(pPDA->CandidateWordID > pPDB->CandidateWordID)
		{
			result = 1;		
		}
		else if(pPDA->CandidateWordID == pPDB->CandidateWordID)
		{
			result = 0;
		}
		else
		{
			result = -1;
		}
	}
	else
	{
		result = -1;
	}


	switch(nOption)
	{
	// Descending by ID.
	case DES_BY_ID: 
		return result;

	// Ascending by ID.
	case ASC_BY_ID:
		{
			if(result > 0) return -1;
			else if(result < 0) return 1;
			else return 0;
		}

	default:
		return 0;
	}
}


//	Node*			pNode = NULL;
//	PriorityData*	pData = NULL;
//
//	while((pData = DumpData(&pNode)) != NULL)
//	{
//		...
//	}
PriorityData* CPriorityList::DumpData(ListNode** pNode)
{
	return (PriorityData*)CLinkedList::GetData(pNode);
}
