#ifndef __PPKeyboard_00000_H__
#define __PPKeyboard_00000_H__
#pragma once

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <string.h>
#include <stdlib.h>
#include <wchar.h>
#include <wctype.h>
#include "PPCtlBase.h"

#define PPKEYBD_MAX_WORD_LEN	256

#define PPKEYBD_STATE_000		0
#define PPKEYBD_STATE_001		1
#define PPKEYBD_STATE_002		2
#define PPKEYBD_STATE_003		3

class PPKeyboard
{
	public:
		PPKeyboard();
		~PPKeyboard();
		
		gint SetOrgXYWH(gint x,gint y,gint w,gint h);
		gint SetDrawWinInfo(GtkWidget *winP,GtkWidget *areaP);
		gint SetDrawPixbufNormal(GdkPixbuf *dataPtr);
		gint SetDrawPixbufDown(GdkPixbuf *dataPtr);
		gint SetDrawPixbufNormal_Big(GdkPixbuf *dataPtr);
		gint SetDrawPixbufDown_Big(GdkPixbuf *dataPtr);
		gint IsPTInThisObject(gint x,gint y);
		gint SetCommandCallBack(PPCommand_CALLBACKPROC callback,void *userDef);
		gint init_controls(gint iMode);
		
		gint OnMouseLButtonDown(int x,int y);
		gint OnMouseMove(int x,int y);
		gint OnMouseLButtonUp(int x,int y);
		gint OnPaint(GtkWidget *widget,GdkEventExpose *event,gpointer user_data);
		bool ConfigureKB(wchar_t* pwcStr);
		int GetCaseInfo();
private:
		bool WCUpToLow(wchar_t* dest, wchar_t wch);
		PPCtlInfo m_controls[256];
		wchar_t m_preeditstr[PPKEYBD_MAX_WORD_LEN];
		wchar_t m_candidatestr[PPKEYBD_MAX_WORD_LEN];
		gint m_ctl_count;
		gint m_lastCPControl;
		gint m_lastPSControl;
		gint FindControlInPTXY(gdouble x,gdouble y);
		gint draw_controls(GtkWidget *widget,gint iAutoXor);
		void RePaintScreen(gint iRpBackground,gint iAutoXor);
		void SetOneControlInfo(PPCtlInfo *tmpCtlP,int iID0,int iID1,int iLeft,int iTop, int iRight, int iBottom, wchar_t* pkeycode);
		void ProcessCallBack(int iID,void *infoP,void *userDataP);
		void SetOneMultiBlockControlInfo(PPCtlInfo *tmpCtlP,int iID0 ,int iID1 ,int iNumBlock ,ppRect *ppRectP);
		gint m_orgX;
		gint m_orgY;
		gint m_orgH;
		gint m_orgW;
		gint m_State;
		gint m_LastMouseX;
		gint m_LastMouseY;
		//gint m_rootX;
		//gint m_rootY;
		GtkWidget *m_win;
		GtkWidget *m_areaP;
		GdkPixbuf *m_KeybdPixMaps[10];
		gint m_UCaseMode;
		gint m_ControlDown;
		PPCommand_CALLBACKPROC m_CallBackPtr;
		void *m_cbUserDefP;
		PPCtlInfo *ControlInfoP;
};


#endif
