#include "PPKeybd.h"

extern void OutputDebugMessage(char * pmsg);
extern void WOutputDebugMessage(wchar_t * pstr);

PPKeyboard::PPKeyboard()
{
	m_ctl_count = 0;
	m_win = 0;
	m_areaP = 0;
	m_State = 0;
	m_CallBackPtr = 0;
	m_lastCPControl = -1;
	m_lastPSControl = -1;
	m_UCaseMode = 0;
	m_ControlDown = 0;
	memset(m_preeditstr, 0, sizeof(wchar_t)*PPKEYBD_MAX_WORD_LEN);
	memset(m_candidatestr, 0, sizeof(wchar_t)*PPKEYBD_MAX_WORD_LEN);
/*
	//bopomo
	m_Candidate_count = 0;
	m_pRootString = NULL;
	memset(m_preedit_wstring, 0, sizeof(m_preedit_wstring));
	memset(m_CandicateString, 0, sizeof(m_CandicateString));
	memset(m_PreeditString, 0, sizeof(m_PreeditString));
	m_pCI = NULL;
	m_pCWBuffer = NULL;
*/	
}

PPKeyboard::~PPKeyboard()
{

}


gint PPKeyboard::init_controls(gint iMode)
{
	gint i;
	//PPCtlInfo *tmpCtlP;
	ppRect tmpRect[4];
	for (i = 0;i < 256;i++)
	{
		memset(&m_controls[i],0,sizeof(PPCtlInfo));
	}
		
	m_ctl_count = 0;
	
	wchar_t wca[]=L"A";
	wchar_t wcb[]=L"B";
	wchar_t wcc[]=L"C";
	wchar_t wcd[]=L"D";
	wchar_t wce[]=L"E";
	wchar_t wcf[]=L"F";
	wchar_t wcg[]=L"G";
	wchar_t wch[]=L"H";
	wchar_t wci[]=L"I";
	wchar_t wcj[]=L"J";
	wchar_t wck[]=L"K";
	wchar_t wcl[]=L"L";
	wchar_t wcm[]=L"M";
	wchar_t wcn[]=L"N";
	wchar_t wco[]=L"O";
	wchar_t wcp[]=L"P";
	wchar_t wcq[]=L"Q";
	wchar_t wcr[]=L"R";
	wchar_t wcs[]=L"S";
	wchar_t wct[]=L"T";
	wchar_t wcu[]=L"U";
	wchar_t wcv[]=L"V";
	wchar_t wcw[]=L"W";
	wchar_t wcx[]=L"X";
	wchar_t wcy[]=L"Y";
	wchar_t wcz[]=L"Z";
	wchar_t wcspace[]=L"　";
	
	if (iMode == 0)
	{
		//first line
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_ESCAPE,PPVK_ESCAPE,0,60-35, 0+53, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'1','1', 52,  60-35, 52+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'2','2', 103, 60-35, 103+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'3','3', 154, 60-35, 154+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'4','4', 205, 60-35, 205+53, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'5','5', 257, 60-35, 257+51, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'6','6', 307, 60-35, 307+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'7','7', 358, 60-35, 358+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'8','8', 409, 60-35, 409+53, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'9','9', 461, 60-35, 461+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'0','0', 512, 60-35, 512+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'-','-', 563, 60-35, 563+52, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'+','+', 614, 60-35, 614+53, 60+45-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_BACK,PPVK_BACK, 666, 60-35, 666+102, 60+45-35, NULL);
		m_ctl_count++;
		//ĤG
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_TAB,PPVK_TAB,   0, 104-35, 0+53, 104+44-35,NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 52, 104-35, 52+52, 104+44-35,wcq);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 103, 104-35, 103+52, 104+44-35,wcw);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 154, 104-35, 154+51, 104+44-35,wce);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 204, 104-35, 205+53, 104+44-35,wcr);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 257, 104-35, 257+51, 104+44-35,wct);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 307, 104-35, 307+52, 104+44-35,wcy);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 358, 104-35, 358+52, 104+44-35,wcu);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 409, 104-35, 409+53, 104+44-35,wci);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 461, 104-35, 461+52, 104+44-35,wco);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 512, 104-35, 512+52, 104+44-35,wcp);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'=','=', 563, 104-35, 563+52, 104+44-35,NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'\\','\\' , 615, 104-35, 615+52, 104+44-35, NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'/','/',  665, 104-35, 665+53, 104+44-35 ,NULL);
		m_ctl_count++;	
		tmpRect[0].m_left = 717; tmpRect[0].m_top = 104-35; tmpRect[0].m_right = 717+51; tmpRect[0].m_bottom = 104+44-35;
		tmpRect[1].m_left = 666; tmpRect[1].m_top = 147-35; tmpRect[1].m_right = 666+102; tmpRect[1].m_bottom = 147+44-35;
		SetOneMultiBlockControlInfo(&m_controls[m_ctl_count],PPVK_RETURN,PPVK_RETURN,2,tmpRect);
		m_ctl_count++;
		//ĤT
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_SHIFT,PPVK_SHIFT, 0, 147-35, 0+52, 147+88-35,NULL);
		m_ctl_count++;			
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,52, 147-35, 52+52,147+42-35, wca);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,103,147-35, 103+52,147+42-35, wcs);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,154, 147-35, 154+52, 147+42-35, wcd);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 205, 147-35, 205+53, 147+42-35, wcf);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,257, 147-35, 257+51, 147+42-35, wcg);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,307, 147-35, 307+53, 147+42-35, wch);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,359, 147-35, 359+52, 147+42-35, wcj);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,410, 147-35, 410+51, 147+42-35, wck);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,460, 147-35, 460+53, 147+42-35, wcl);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],':',':',512, 147-35, 512+52, 147+42-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],';', ';', 563, 147-35, 563+52, 147+42-35 ,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'"', '"', 615, 147-35, 615+53, 147+42-35 ,NULL);
		m_ctl_count++;
		//ĥ|
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,52,  188-35, 52+52, 188+47-35, wcz);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,103, 188-35, 103+52, 188+47-35, wcx);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,154, 188-35, 154+52, 188+47-35, wcc);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,205, 188-35, 205+53, 188+47-35, wcv);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,257, 188-35, 257+51, 188+47-35, wcb);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,307, 188-35, 307+53, 188+47-35, wcn);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,359, 188-35, 359+52, 188+47-35, wcm);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],',',',',410, 188-35, 410+51, 188+47-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'.','.',460, 188-35, 460+53, 188+47-35,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'\'','\'',512, 188-35, 512+52, 188+47-35, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'!', '!', 563, 188-35, 563+52, 188+47-35,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'?', '?', 614, 188-35, 614+53, 188+47-35,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_SPACE,PPVK_SPACE,666,191-35, 666+102,191+44-35, wcspace);
		m_ctl_count++;
	}
	else
	{
		//first line
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_ESCAPE,PPVK_ESCAPE,0,70-40, 0+66, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'1','1', 65,  70-40, 65+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'2','2', 129, 70-40, 129+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'3','3', 193, 70-40, 193+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'4','4', 257, 70-40, 257+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'5','5', 321, 70-40, 321+66, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'6','6', 386, 70-40, 386+63, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'7','7', 448, 70-40, 448+64, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'8','8', 511, 70-40, 511+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'9','9', 575, 70-40, 575+66, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'0','0', 640, 70-40, 640+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'-','-', 704, 70-40, 704+65, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'+','+', 768, 70-40, 768+64, 70+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_BACK,PPVK_BACK, 831, 70-40, 831+129, 70+56-40, NULL);
		m_ctl_count++;
		//ĤG
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_TAB,PPVK_TAB,   0, 125-40, 0+66, 125+56-40,NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 66,  125-40, 66+65, 125+56-40,wcq);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 129, 125-40, 129+65, 125+56-40,wcw);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 192, 125-40, 192+65, 125+56-40,wce);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 257, 125-40, 257+65, 125+56-40,wcr);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 321, 125-40, 321+65, 125+56-40,wct);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 385, 125-40, 385+64, 125+56-40,wcy);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 448, 125-40, 448+64, 125+56-40,wcu);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 511, 125-40, 511+65, 125+56-40,wci);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 575, 125-40, 575+66, 125+56-40,wco);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE, 640, 125-40, 640+65, 125+56-40,wcp);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'=','=', 704, 125-40, 704+65, 125+56-40,NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'\\','\\' , 768, 125-40, 768+64, 125+56-40, NULL);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],'/', '/', 831, 125-40, 831+66, 125+56-40,NULL);
		m_ctl_count++;	
		tmpRect[0].m_left = 896; tmpRect[0].m_top = 125-40; tmpRect[0].m_right = 896+64; tmpRect[0].m_bottom = 125+56-40;
		tmpRect[1].m_left = 832; tmpRect[1].m_top = 180-40; tmpRect[1].m_right = 832+128; tmpRect[1].m_bottom = 180+56-40;
		SetOneMultiBlockControlInfo(&m_controls[m_ctl_count],PPVK_RETURN,PPVK_RETURN,2,tmpRect);
		m_ctl_count++;
		//ĤT
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_SHIFT,PPVK_SHIFT, 0, 180-40, 0+66, 180+110-40, NULL);
		m_ctl_count++;			
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,65, 180-40, 65+65, 180+55-40, wca);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,129,180-40, 129+65,180+55-40, wcs);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,193, 180-40, 193+65, 180+55-40, wcd);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,257, 180-40, 257+65, 180+55-40, wcf);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,321, 180-40, 321+65, 180+55-40, wcg);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,385, 180-40, 385+64, 180+55-40, wch);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,448, 180-40, 448+64, 180+55-40, wcj);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,511, 180-40, 511+64, 180+55-40, wck);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,575, 180-40, 575+65, 180+55-40, wcl);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],':',':',640, 180-40, 640+65, 180+55-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],';', ';', 704, 180-40, 704+65, 180+55-40,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'"', '"', 768, 180-40, 768+66, 180+55-40,NULL);
		m_ctl_count++;
		//ĥ|
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,65,  234-40, 65+65, 234+56-40, wcz);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,129, 234-40, 129+65, 234+56-40, wcx);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,193, 234-40, 193+65, 234+56-40, wcc);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,257, 234-40, 257+65, 234+56-40, wcv);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,321, 234-40, 321+65, 234+56-40, wcb);
		m_ctl_count++;	
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,385, 234-40, 385+64, 234+56-40, wcn);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_NONE,PPVK_NONE,448, 234-40, 448+64, 234+56-40, wcm);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],',',',',511, 234-40, 511+65, 234+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'.','.',575, 234-40, 575+66, 234+56-40,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'\'','\'',640, 234-40, 640+65, 234+56-40, NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'!','!' , 704, 234-40, 704+65, 234+56-40,NULL); 
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],'?', '?', 768, 234-40, 768+65, 234+56-40,NULL);
		m_ctl_count++;
		SetOneControlInfo(&m_controls[m_ctl_count],PPVK_SPACE,PPVK_SPACE, 832,235-40, 832+127,235+55-40, wcspace);
		m_ctl_count++;

	}
	return 0;

}

gint PPKeyboard::SetCommandCallBack(PPCommand_CALLBACKPROC callback,void *userDef)
{
	m_CallBackPtr = callback;
	m_cbUserDefP = userDef;
	return 0;
}

gint PPKeyboard::OnMouseLButtonDown(int x,int y)
{
	PPCtlInfo *oneInfoP;
	gint idx;
//	GdkModifierType state;
		
	if (m_State == PPKEYBD_STATE_000)
	{
		idx = FindControlInPTXY(x,y);
		if (idx != -1)
		{
			//found button
			oneInfoP = &(m_controls[idx]);
			if (oneInfoP != 0)
			{
				if (oneInfoP->m_CtlState == PPKEYBD_STATE_000)
				{
					oneInfoP->m_CtlState = PPKEYBD_STATE_001;
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
					m_lastCPControl = idx;
					RePaintScreen(0,1);
				}
			}
			m_State = PPKEYBD_STATE_001;
		}else
		{
			// found no button.
			m_lastCPControl = -1;
			m_State = PPKEYBD_STATE_003;
			m_LastMouseX = x;
			m_LastMouseY = y;
			//gdk_window_get_pointer(NULL, &m_LastMouseX, &m_LastMouseY, &state);
			
		}
	}
	return 0;
}

gint PPKeyboard::OnMouseMove(int x,int y)
{
	gint idx;
	PPCtlInfo *oneInfoP;
	gint nowX,nowY;
	GdkModifierType state;

	if ((m_State == PPKEYBD_STATE_001) || (m_State == PPKEYBD_STATE_000))
	{
		idx = FindControlInPTXY(x,y);	//­
		if (idx != -1) // found it!
		{
			oneInfoP = &(m_controls[idx]);
			if (oneInfoP != 0)
			{
				if (m_lastCPControl == -1)	//No last control
				{
					if (m_lastPSControl == -1)	//over this control
					{
						m_lastPSControl = idx;
						oneInfoP->m_CtlState = PPKEYBD_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
					}else
					{
						if (m_lastPSControl != idx) //check over control same?
						{
							oneInfoP = &(m_controls[m_lastPSControl]);
							if (oneInfoP != 0)
							{
								oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
							}
							m_lastPSControl = idx;
							oneInfoP = &(m_controls[m_lastPSControl]);
							oneInfoP->m_CtlState = PPKEYBD_STATE_000;
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						}
					}
				}else //last one pressed
				{
					if (m_lastCPControl != idx) //press control not same
					{
						oneInfoP = &(m_controls[m_lastCPControl]);
						if (oneInfoP != 0)
						{
							oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
						}
					}else //press control same
					{
						oneInfoP->m_CtlState = PPKEYBD_STATE_002;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_DOWN;
					}
				}
			}
			RePaintScreen(0,1);
		}else // No control in PT localation
		{
			if (m_lastCPControl != -1)	//restore
			{
				oneInfoP = &(m_controls[m_lastCPControl]);
				if (oneInfoP != 0)
				{
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
				}
			}else	// restore it!
			{
				if (m_lastPSControl != -1)
				{
					oneInfoP = &(m_controls[m_lastPSControl]);
					if (oneInfoP != 0)
					{
						//some problem here!
						//Outdebugstring("");
						//oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
				}
				m_lastPSControl = -1;
			}
			RePaintScreen(0,1);
		}
	}else if (m_State == PPKEYBD_STATE_003)
	{
		if ((x == -1) || (y == -1))
		{
		}else
		{
			gdk_window_get_pointer(NULL, &nowX, &nowY, &state);
			gtk_window_move(GTK_WINDOW(m_win),nowX - m_LastMouseX,nowY - m_LastMouseY);
		}
	}
	return 0;
}

gint PPKeyboard::OnMouseLButtonUp(int x,int y)
{
	gint idx;
	PPCtlInfo *oneInfoP;
	
	if (m_State == PPKEYBD_STATE_003)
	{
		m_State = PPKEYBD_STATE_000;
	}else
	{
		idx = FindControlInPTXY(x,y);
		if (idx != -1)	
		{
			if (m_lastCPControl == -1)	// no object
			{
				if (m_lastPSControl != -1) //restore last object
				{
					oneInfoP = &(m_controls[m_lastPSControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
				}
			}else //has object
			{
				if (idx == m_lastCPControl)	//do command
				{
					oneInfoP = &(m_controls[m_lastCPControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPKEYBD_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						m_lastPSControl = idx;

						//process callback function
						ProcessCallBack(oneInfoP->m_CtlID[0],oneInfoP,0);
					}
				}else	//last object not the same
				{
					oneInfoP = &(m_controls[m_lastCPControl]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPKEYBD_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
					}
					oneInfoP = &(m_controls[idx]);
					if (oneInfoP != 0)
					{
						oneInfoP->m_CtlState = PPKEYBD_STATE_000;
						oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_OVER;
						m_lastPSControl = idx;
					}
				}
				m_lastCPControl = -1;
			}
		}else //no object ,do restore ---------------------------------------------------------
		{
			if (m_lastCPControl != -1)
			{
				oneInfoP = &(m_controls[m_lastCPControl]);
				if (oneInfoP != 0)
				{
					oneInfoP->m_CtlState = PPKEYBD_STATE_000;
					oneInfoP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
				}
				m_lastCPControl = -1;
			}
		}
		RePaintScreen(0,1);
	}

	m_State = PPKEYBD_STATE_000;
	return 0;
}

gint PPKeyboard::OnPaint(GtkWidget *widget,GdkEventExpose *event,gpointer user_data)
{
	RePaintScreen(1,0);
	return 1;
}

gint PPKeyboard::FindControlInPTXY(gdouble x,gdouble y)
{
	gint i,j; //,tmpW,tmpH;
	PPCtlInfo *oneInfoP;

	for (i = 0;i < m_ctl_count;i++)
	{
		oneInfoP = &(m_controls[i]);
		if (oneInfoP != 0)
		{
			if (oneInfoP->m_disable == 0)
			{
				if (oneInfoP->m_CtlMultiBlock > 1)
				{
					for (j = 0;j < oneInfoP->m_CtlMultiBlock;j++)
					{
						if (((x >= oneInfoP->m_MBlocks[j].m_left ) && (x <= oneInfoP->m_MBlocks[j].m_right )) &&
						((y >= oneInfoP->m_MBlocks[j].m_top ) && (y <= oneInfoP->m_MBlocks[j].m_bottom )))
						{
							return i;
						}
					}
				}
				else
				{
					if (((x >= oneInfoP->m_mainRect.m_left ) && (x <= oneInfoP->m_mainRect.m_right )) &&
						((y >= oneInfoP->m_mainRect.m_top ) && (y <= oneInfoP->m_mainRect.m_bottom )))
					{
						return i;
					}
				}
			}
		}
	}
	return -1;

}


gint PPKeyboard::SetOrgXYWH(gint x,gint y,gint w,gint h)
{
	m_orgX = x;
	m_orgY = y;
	m_orgH = h;
	m_orgW = w;
	
	return 1;
}

gint PPKeyboard::SetDrawWinInfo(GtkWidget *winP,GtkWidget *areaP)
{
	m_win = winP;
	m_areaP = areaP;
	return 1;
}

gint PPKeyboard::SetDrawPixbufNormal(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[0] = dataPtr;
	return 1;
}

gint PPKeyboard::SetDrawPixbufDown(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[1] = dataPtr;
	return 1;
}

gint PPKeyboard::SetDrawPixbufNormal_Big(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[2] = dataPtr;
	return 1;
}

gint PPKeyboard::SetDrawPixbufDown_Big(GdkPixbuf *dataPtr)
{
	m_KeybdPixMaps[3] = dataPtr;
	return 1;
}

gint PPKeyboard::IsPTInThisObject(gint x,gint y)
{
	if (m_State == PPKEYBD_STATE_003)	//caption draging
	{
		return 1;
	}else
	{
		if (((x  >= m_orgX) && (x <= (m_orgX + m_orgW))) &&
		((y  >= m_orgY) && (y <= (m_orgY + m_orgH))))
		{
			return 1;
		}else
		{
			return 0;
		}
	}
	
}



void PPKeyboard::RePaintScreen(gint iRpBackground,gint iAutoXor)
{
	//int i;
	//GdkPoint points[5];

	if (m_win != 0)
	{
		//if (gbl_oneGtkImgP != 0)
		{
			if (m_areaP != 0)
			{
				if (iRpBackground == 1)
				{
					if (m_UCaseMode == 0)
					{
						gdk_draw_pixbuf(m_areaP->window, m_areaP->style->white_gc, m_KeybdPixMaps[0], m_orgX, m_orgY, m_orgX, m_orgY, m_orgW, m_orgH, GDK_RGB_DITHER_NONE, 0, 0); 
					}else
					{
						gdk_draw_pixbuf(m_areaP->window, m_areaP->style->white_gc, m_KeybdPixMaps[2], m_orgX, m_orgY, m_orgX, m_orgY, m_orgW, m_orgH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
				}

				draw_controls(m_areaP,iAutoXor);
			}
		}
	}

}


gint PPKeyboard::draw_controls(GtkWidget *widget,gint iAutoXor)
{
	gint i,j,tmpW,tmpH;
	PPCtlInfo *oneInfoP;
	gint iRepaintFlag;
	GdkPixbuf *drawPtr;
	

	for (i = 0;i < m_ctl_count;i++)
	{
		oneInfoP = &(m_controls[i]);
		if (oneInfoP != 0)
		{
			if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_NORM)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_NORM)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					if (oneInfoP->m_CtlModeState == PPCTLMODESTATE_TOGGLEDOWN)
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[1];
						}else
						{
							drawPtr = m_KeybdPixMaps[3];
						}
					}else
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[0];
						}else
						{
							drawPtr = m_KeybdPixMaps[2];
						}
					}
						
					if (oneInfoP->m_CtlMultiBlock > 1)
					{
						for (j = 0;j < oneInfoP->m_CtlMultiBlock;j++)
						{
							tmpW = oneInfoP->m_MBlocks[j].m_right - oneInfoP->m_MBlocks[j].m_left;
							tmpH = oneInfoP->m_MBlocks[j].m_bottom - oneInfoP->m_MBlocks[j].m_top;
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
					}else
					{
						tmpW = oneInfoP->m_OFSPX_mainRect.m_right - oneInfoP->m_OFSPX_mainRect.m_left;
						tmpH = oneInfoP->m_OFSPX_mainRect.m_bottom - oneInfoP->m_OFSPX_mainRect.m_top;
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_OFSPX_mainRect.m_left, oneInfoP->m_OFSPX_mainRect.m_top, oneInfoP->m_mainRect.m_left, oneInfoP->m_mainRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					//= gdk_display_get_default_screen();
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_NORM;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DOWN)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DOWN)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					if (m_UCaseMode == 0)
					{
						drawPtr = m_KeybdPixMaps[1];
					}else
					{
						drawPtr = m_KeybdPixMaps[3];
					}
					
					if (oneInfoP->m_CtlMultiBlock > 1)
					{
						for (j = 0;j < oneInfoP->m_CtlMultiBlock;j++)
						{
							tmpW = oneInfoP->m_MBlocks[j].m_right - oneInfoP->m_MBlocks[j].m_left;
							tmpH = oneInfoP->m_MBlocks[j].m_bottom - oneInfoP->m_MBlocks[j].m_top;
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
					}else
					{
						tmpW = oneInfoP->m_OFSPX_downRect.m_right - oneInfoP->m_OFSPX_downRect.m_left;
						tmpH = oneInfoP->m_OFSPX_downRect.m_bottom - oneInfoP->m_OFSPX_downRect.m_top;
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_OFSPX_downRect.m_left, oneInfoP->m_OFSPX_downRect.m_top, oneInfoP->m_downRect.m_left, oneInfoP->m_downRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DOWN;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_OVER)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_OVER)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}
				if (iRepaintFlag == 1)
				{
					if (oneInfoP->m_CtlModeState == PPCTLMODESTATE_TOGGLEDOWN)
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[1];
						}else
						{
							drawPtr = m_KeybdPixMaps[3];
						}
					}else
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[0];
						}else
						{
							drawPtr = m_KeybdPixMaps[2];
						}
					}
					if (oneInfoP->m_CtlMultiBlock > 1)
					{
						for (j = 0;j < oneInfoP->m_CtlMultiBlock;j++)
						{
							tmpW = oneInfoP->m_MBlocks[j].m_right - oneInfoP->m_MBlocks[j].m_left;
							tmpH = oneInfoP->m_MBlocks[j].m_bottom - oneInfoP->m_MBlocks[j].m_top;
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
					}else
					{
						tmpW = oneInfoP->m_OFSPX_overRect.m_right - oneInfoP->m_OFSPX_overRect.m_left;
						tmpH = oneInfoP->m_OFSPX_overRect.m_bottom - oneInfoP->m_OFSPX_overRect.m_top;
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_OFSPX_overRect.m_left, oneInfoP->m_OFSPX_overRect.m_top, oneInfoP->m_overRect.m_left, oneInfoP->m_overRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_OVER;
				}
			}else if (oneInfoP->m_CtlDrawState == PPOD_CTLDRAW_DISABLE)
			{
				iRepaintFlag = 0;
				if (iAutoXor == 1)
				{
					if (oneInfoP->m_CtlLastDrawState != PPOD_CTLDRAW_DISABLE)
					{
						iRepaintFlag = 1;
					}
				}else
				{
					iRepaintFlag = 1;
				}

				if (iRepaintFlag == 1)
				{
					if (oneInfoP->m_CtlModeState == PPCTLMODESTATE_TOGGLEDOWN)
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[1];
						}else
						{
							drawPtr = m_KeybdPixMaps[3];
						}
					}else
					{
						if (m_UCaseMode == 0)
						{
							drawPtr = m_KeybdPixMaps[1];
						}else
						{
							drawPtr = m_KeybdPixMaps[3];
						}
					}

					if (oneInfoP->m_CtlMultiBlock > 1)
					{
						for (j = 0;j < oneInfoP->m_CtlMultiBlock;j++)
						{
							tmpW = oneInfoP->m_MBlocks[j].m_right - oneInfoP->m_MBlocks[j].m_left;
							tmpH = oneInfoP->m_MBlocks[j].m_bottom - oneInfoP->m_MBlocks[j].m_top;
							gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, oneInfoP->m_MBlocks[j].m_left, oneInfoP->m_MBlocks[j].m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
						}
					}else
					{
						tmpW = oneInfoP->m_OFSPX_disableRect.m_right - oneInfoP->m_OFSPX_disableRect.m_left;
						tmpH = oneInfoP->m_OFSPX_disableRect.m_bottom - oneInfoP->m_OFSPX_disableRect.m_top;
						gdk_draw_pixbuf(widget->window, widget->style->white_gc, drawPtr, oneInfoP->m_OFSPX_disableRect.m_left, oneInfoP->m_OFSPX_disableRect.m_top, oneInfoP->m_disableRect.m_left, oneInfoP->m_disableRect.m_top, tmpW, tmpH, GDK_RGB_DITHER_NONE, 0, 0); 
					}
					oneInfoP->m_CtlLastDrawState = PPOD_CTLDRAW_DISABLE;
				}
			}
		}
	}
	return 0;
}


void PPKeyboard::SetOneControlInfo(PPCtlInfo *tmpCtlP,int iID0,int iID1,int iLeft,int iTop, int iRight, int iBottom, wchar_t* pkeycode)
{
	if (tmpCtlP != 0)
	{
		if(pkeycode)
		{
			wcscpy(tmpCtlP->m_keywchar, pkeycode);
		}
		else
		{
			memset(tmpCtlP->m_keywchar, 0, sizeof(tmpCtlP->m_keywchar));
		}

		tmpCtlP->m_CtlID[0] = iID0;
		tmpCtlP->m_CtlID[1] = iID1;
		tmpCtlP->m_mainRect.m_left = iLeft;
		tmpCtlP->m_mainRect.m_top = iTop;
		tmpCtlP->m_mainRect.m_right = iRight;
		tmpCtlP->m_mainRect.m_bottom = iBottom;

		if( wcscmp(tmpCtlP->m_keywchar, L"U") == 0 ||
			wcscmp(tmpCtlP->m_keywchar, L"I") == 0 ||
			wcscmp(tmpCtlP->m_keywchar, L"V") == 0 )
		{
			tmpCtlP->m_disable = 1;
			tmpCtlP->m_CtlDrawState = PPOD_CTLDRAW_DISABLE;
		}
		else
		{
			tmpCtlP->m_disable = 0;
			tmpCtlP->m_CtlDrawState = PPOD_CTLDRAW_NORM;
		}

		memcpy(&(tmpCtlP->m_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_senseRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_transpRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_mainRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
		memcpy(&(tmpCtlP->m_OFSPX_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));	
	}
}


void PPKeyboard::SetOneMultiBlockControlInfo(PPCtlInfo *tmpCtlP,int iID0,int iID1,int iNumBlock,ppRect *ppRectP)
{
	int i;
	if (tmpCtlP != 0)
	{
		tmpCtlP->m_CtlID[0] = iID0;
		tmpCtlP->m_CtlID[1] = iID1;
		
		if (iNumBlock > 1)
		{
			tmpCtlP->m_mainRect.m_left = ppRectP[0].m_left;
			tmpCtlP->m_mainRect.m_top = ppRectP[0].m_top;
			tmpCtlP->m_mainRect.m_right = ppRectP[0].m_right;
			tmpCtlP->m_mainRect.m_bottom = ppRectP[0].m_bottom;
			memcpy(&(tmpCtlP->m_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_senseRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_transpRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_OFSPX_mainRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_OFSPX_overRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_OFSPX_downRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			memcpy(&(tmpCtlP->m_OFSPX_disableRect),&(tmpCtlP->m_mainRect),sizeof(ppRect));
			tmpCtlP->m_CtlMultiBlock = iNumBlock;
			for (i = 0;i < iNumBlock;i++)
			{
				memcpy(&(tmpCtlP->m_MBlocks[i]),&ppRectP[i],sizeof(ppRect));
			}
		}
	}
}


void PPKeyboard::ProcessCallBack(int iID,void *infoP,void *userDataP)
{

	PPCtlInfo *oneInfoP = (PPCtlInfo *)infoP;
	
	if (m_CallBackPtr != 0)
	{
		if (iID == PPVK_SHIFT)
		{
			if (m_UCaseMode == 0)
			{
				m_UCaseMode = 1;
			}else
			{
				m_UCaseMode = 0;
			}
			RePaintScreen(1,0);
		}else if (iID == PPVK_CONTROL)
		{
			if (oneInfoP->m_CtlModeState == PPCTLMODESTATE_TOGGLEDOWN)
			{
				oneInfoP->m_CtlModeState = PPCTLMODESTATE_NORMAL;
				RePaintScreen(0,0);
				m_ControlDown = 0;
			}else
			{
				oneInfoP->m_CtlModeState = PPCTLMODESTATE_TOGGLEDOWN;
				RePaintScreen(0,0);
				m_ControlDown = 1;
			}
			ControlInfoP = oneInfoP;
		}else if (iID == PPVK_WORDTYPE)
		{
			//word type change
		}
		else if (iID == PPVK_NONE)
		{
			//m_CallBackPtr(PPMAKEDWORD(m_ControlDown,oneInfoP->m_CtlID[m_UCaseMode]),infoP,userDataP);
			//ǰeQUrXLh
			m_CallBackPtr(PPMAKEDWORD(m_ControlDown,oneInfoP->m_CtlID[m_UCaseMode]),infoP,oneInfoP);
		}
		else
		{
			if (m_ControlDown == 1) //pGObcontrol UA
			{
				m_CallBackPtr(PPMAKEDWORD(m_ControlDown,oneInfoP->m_CtlID[m_UCaseMode]),infoP,oneInfoP);
				ControlInfoP->m_CtlModeState = PPCTLMODESTATE_NORMAL;
				RePaintScreen(0,0);
			}else
			{	
				//pGObcontrol UA
				//ǤJO/bΪcontrol ID
				m_CallBackPtr(PPMAKEDWORD(m_ControlDown,oneInfoP->m_CtlID[m_UCaseMode]),infoP,userDataP);
			}
		}
	}	
}

bool PPKeyboard::ConfigureKB(wchar_t* pwcStr)
{
	int i,j;
	bool beenable;
		
	if(pwcStr)
	{
		OutputDebugMessage("(configure kb:");
		WOutputDebugMessage(pwcStr);
		OutputDebugMessage(")");
	}
	else
	{
		OutputDebugMessage("(configure kb with null string.\n)");
	}	


	//enable
	for(i= 0; i<m_ctl_count; i++)
	{
		m_controls[i].m_disable = 0;
		m_controls[i].m_CtlDrawState = PPOD_CTLDRAW_NORM;
	}

	if(pwcStr)
	{
		int wlen = wcslen(pwcStr);

		if(wlen == PPDEFAULT_BOPOMO_ROOTNUMBER)
		{
			wchar_t wcu[]=L"U";
			wchar_t wci[]=L"I";
			wchar_t wcv[]=L"V";

			for(i = 0; i<m_ctl_count; i++)
			{
				beenable = false;

				if(wcslen(m_controls[i].m_keywchar)>0)
				{
					for(j = 0; j<wlen; j++)
					{

						if( (wcscmp(m_controls[i].m_keywchar, wcu) == 0)  ||
							(wcscmp(m_controls[i].m_keywchar, wci) == 0)  ||
							(wcscmp(m_controls[i].m_keywchar, wcv) == 0)  )
						{
						
						}
						else
						{
							beenable = true;
						}
					}
				}
				else
				{
					beenable = true;
				}
				
				if(!beenable)
				{
					m_controls[i].m_disable = 1;
					m_controls[i].m_CtlDrawState = PPOD_CTLDRAW_DISABLE;		
				}
			}		

			return true;
		}
		
		
		if(wlen >0)
		{
			wchar_t wctmp[16];
			wchar_t wctmporig[16];
			for(i = 0; i<m_ctl_count; i++)
			{
				beenable = false;

				if(wcslen(m_controls[i].m_keywchar)>0)
				{
					for(j = 0; j<wlen; j++)
					{
						
						//pgনjg
						memset(wctmp, 0, sizeof(wctmp));
						memset(wctmporig, 0, sizeof(wctmporig));
						WCUpToLow(wctmporig,m_controls[i].m_keywchar[0]);
						*wctmp = *(pwcStr+j);
						
						if(wcscmp(wctmporig,wctmp) == 0)
						{
							beenable = true;
						}
					}

					/*
					if(m_controls[i].m_CtlID[0] == PPVK_SPACE)
					{
						beenable = true;
					}
					*/
				}
				else
				{
					//enable ҦƦr
					if( (m_controls[i].m_CtlID[0] == '1') || 
					    (m_controls[i].m_CtlID[0] == '2') || 
					    (m_controls[i].m_CtlID[0] == '3') || 
					    (m_controls[i].m_CtlID[0] == '4') || 
					    (m_controls[i].m_CtlID[0] == '5') || 
					    (m_controls[i].m_CtlID[0] == '6') || 
					    (m_controls[i].m_CtlID[0] == '7') || 
					    (m_controls[i].m_CtlID[0] == '8') || 
					    (m_controls[i].m_CtlID[0] == '9') || 
					    (m_controls[i].m_CtlID[0] == '0')  )
					{
						beenable = true;
					}

					//Srh disable, F space  backspace H~
					if( (m_controls[i].m_CtlID[0] == PPVK_SPACE) || (m_controls[i].m_CtlID[0] == PPVK_BACK))
					{
						beenable = true;
					}
				}

				if(!beenable)
				{
					m_controls[i].m_disable = 1;
					m_controls[i].m_CtlDrawState = PPOD_CTLDRAW_DISABLE;		
				}
			}
		}

		


	}
	else
	{
		//^lA
		wchar_t wcu[]=L"U";
		wchar_t wci[]=L"I";
		wchar_t wcv[]=L"V";

		for(i = 0; i<m_ctl_count; i++)
		{
			beenable = false;

			if(wcslen(m_controls[i].m_keywchar)>0)
			{
				if( (wcscmp(m_controls[i].m_keywchar, wcu) == 0)  ||
					(wcscmp(m_controls[i].m_keywchar, wci) == 0)  ||
					(wcscmp(m_controls[i].m_keywchar, wcv) == 0)  )
				{
				
				}
				else
				{
					beenable = true;
				}
			}
			else
			{
				beenable = true;
			}

			if(!beenable)
			{
				m_controls[i].m_disable = 1;
				m_controls[i].m_CtlDrawState = PPOD_CTLDRAW_DISABLE;		
			}
		}
	}

	return true;
}


bool PPKeyboard::WCUpToLow(wchar_t* dest, wchar_t wch)
{
	//@Ӧr, ഫr
	if(dest)
	{
		wchar_t wctemp[4];
		memset(wctemp,0, sizeof(wctemp));
		wctemp[0] = wch;
		if(wcscmp(wctemp,L"A") == 0)
			wcscpy(dest, L"a");
		else if(wcscmp(wctemp,L"B") == 0)
			wcscpy(dest, L"b");
		else if(wcscmp(wctemp,L"C") == 0)
			wcscpy(dest, L"c");
		else if(wcscmp(wctemp,L"D") == 0)
			wcscpy(dest, L"d");
		else if(wcscmp(wctemp,L"E") == 0)
			wcscpy(dest, L"e");
		else if(wcscmp(wctemp,L"F") == 0)
			wcscpy(dest, L"f");
		else if(wcscmp(wctemp,L"G") == 0)
			wcscpy(dest, L"g");
		else if(wcscmp(wctemp,L"H") == 0)
			wcscpy(dest, L"h");
		else if(wcscmp(wctemp,L"I") == 0)
			wcscpy(dest, L"i");
		else if(wcscmp(wctemp,L"J") == 0)
			wcscpy(dest, L"j");
		else if(wcscmp(wctemp,L"K") == 0)
			wcscpy(dest, L"k");
		else if(wcscmp(wctemp,L"L") == 0)
			wcscpy(dest, L"l");
		else if(wcscmp(wctemp,L"M") == 0)
			wcscpy(dest, L"m");
		else if(wcscmp(wctemp,L"N") == 0)
			wcscpy(dest, L"n");
		else if(wcscmp(wctemp,L"O") == 0)
			wcscpy(dest, L"o");
		else if(wcscmp(wctemp,L"P") == 0)
			wcscpy(dest, L"p");
		else if(wcscmp(wctemp,L"Q") == 0)
			wcscpy(dest, L"q");
		else if(wcscmp(wctemp,L"R") == 0)
			wcscpy(dest, L"r");
		else if(wcscmp(wctemp,L"S") == 0)
			wcscpy(dest, L"s");
		else if(wcscmp(wctemp,L"T") == 0)
			wcscpy(dest, L"t");
		else if(wcscmp(wctemp,L"U") == 0)
			wcscpy(dest, L"u");
		else if(wcscmp(wctemp,L"V") == 0)
			wcscpy(dest, L"v");
		else if(wcscmp(wctemp,L"W") == 0)
			wcscpy(dest, L"w");
		else if(wcscmp(wctemp,L"X") == 0)
			wcscpy(dest, L"x");
		else if(wcscmp(wctemp,L"Y") == 0)
			wcscpy(dest, L"y");
		else if(wcscmp(wctemp,L"Z") == 0)
			wcscpy(dest, L"z");
		return true;
	}

	return false;
}

int PPKeyboard::GetCaseInfo()
{
	return m_UCaseMode;
}

///////////////////////////////////File End///////////////////////////////////

