#ifndef __PPCaption_00000_H__
#define __PPCaption_00000_H__
#pragma once

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <string.h>
#include "PPCtlBase.h"




#define PPCAPTION_STATE_000	0
#define PPCAPTION_STATE_001	1
#define PPCAPTION_STATE_002	2
#define PPCAPTION_STATE_003	3

class PPCaption
{
	public:
		PPCaption();
		~PPCaption();
		
		gint SetOrgXYWH(gint x,gint y,gint w,gint h);
		gint SetDrawWinInfo(GtkWidget *winP,GtkWidget *areaP);
		gint SetDrawPixbufNormal(GdkPixbuf *dataPtr);
		gint SetDrawPixbufDown(GdkPixbuf *dataPtr);
		gint SetDrawPixbufNormal_Big(GdkPixbuf *dataPtr);
		gint SetDrawPixbufDown_Big(GdkPixbuf *dataPtr);
		gint IsPTInThisObject(gint x,gint y);
		gint SetCommandCallBack(PPCommand_CALLBACKPROC callback,void *userDef);
		gint init_controls(gint iMode);
		
		gint OnMouseLButtonDown(int x,int y);
		gint OnMouseMove(int x,int y);
		gint OnMouseLButtonUp(int x,int y);
		gint OnPaint(GtkWidget *widget,GdkEventExpose *event,gpointer user_data);
		
private:		
		PPCtlInfo m_controls[256];
		gint m_ctl_count;
		gint m_lastCPControl;
		gint m_lastPSControl;
		gint FindControlInPTXY(gdouble x,gdouble y);
		gint draw_controls(GtkWidget *widget,gint iAutoXor);
		void RePaintScreen(gint iRpBackground,gint iAutoXor);
		void SetOneControlInfo(PPCtlInfo *tmpCtlP,int iID,int iLeft,int iTop, int iRight, int iBottom);
		void ProcessCallBack(int iID,void *infoP,void *userDataP);
		gint m_orgX;
		gint m_orgY;
		gint m_orgH;
		gint m_orgW;
		gint m_State;
		gint m_LastMouseX;
		gint m_LastMouseY;
		//gint m_rootX;
		//gint m_rootY;
		GtkWidget *m_win;
		GtkWidget *m_areaP;
		GdkPixbuf *m_KeybdPixMaps[10];
		PPCommand_CALLBACKPROC m_CallBackPtr;
		void *m_cbUserDefP;
		
};


#endif
