#ifndef __LINKEDLIST_H__
#define __LINKEDLIST_H__
#pragma once

//#include <iostream>
//#include <stdio.h>
#include "Definitions.h"
#include "ListNode.h"

/*
struct Node
{
	Node*			Previous;
	void*			Data;
	Node*			Next;

	Node()
	{
		Previous = NULL;
		Data = NULL;
		Next = NULL;
	}
};
*/

class CLinkedList
{
private:
	ListNode*			Head;
	ListNode*			Tail;
	size_t			Count;

	bool SwapNodes(ListNode* pA, ListNode* pB);

protected:
	ListNode* FindNode(size_t index); // index: Storage order
	ListNode* FindNodeByData(void* pData, size_t* uIndex, LLEqualOption nOption);
	void* GetData(ListNode** ppNode);

public:
	CLinkedList();
	virtual ~CLinkedList();

	void CreateData(ListNode* pNode, void* pData)
	{
		if(pNode->Data == NULL)
		{
			pNode->Data = pData;
		}
	}

	size_t GetCount()
	{
		return Count;
	}

	bool Add(void* pData);
	bool Clear();
	bool Insert(size_t index, void* pData);
	bool RemoveAt(size_t index);
	bool Contains(void* pData, bool bIgnoreCase);
	bool Sort(LLCompareOption nOption);


	// Sub-class must override the following function:
	virtual void ClearData(ListNode* pNode) = 0;
	virtual bool AreDataEqual(void* pDataA, void* pDataB, LLEqualOption nOption) = 0;
	virtual int Comparer(void* pDataA, void* pDataB, LLCompareOption nOption) = 0;
};


#endif
