#include "LinkedList.h"

CLinkedList::CLinkedList(void)
{
	Head = NULL;
	Tail = NULL;

	Count = 0;
}

CLinkedList::~CLinkedList(void)
{
	Clear();
}

// Please use a Data object by 'new'.
// Ex:
//    CandidateWord* pData = new CandidateWord();
//    Add(pData);
//
// DO NOT USEG
//    CandidateWord pData;
//    Add(&pData);
// When using 'delete', it will crash.
//
bool CLinkedList::Add(void* pData)
{
	if(pData == NULL)
	{
		return false;
	}

	if(Head == NULL && Tail == NULL)
	{
		ListNode* newnode = new ListNode();
		if(newnode != NULL)
		{
			CreateData(newnode, pData);

			Head = newnode;
			Tail = newnode;

			Count = 1;

			return true;
		}
		else
		{
			return false;
		}
	}
	else if(Head != NULL && Tail != NULL)
	{
		// Appending a new node in back of this linked list.
		ListNode* newnode = new ListNode();
		if(newnode != NULL)
		{
			CreateData(newnode, pData);

			newnode->Previous = Tail;
			Tail->Next = newnode;
			
			Tail = newnode;
			newnode = NULL;

			Count++;

			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;	
	}
}

bool CLinkedList::Clear()
{
	if(Count > 0 && Head != NULL && Tail != NULL)
	{
		ListNode* deletingnode = NULL;

		while(Head != NULL)
		{
			deletingnode = Head;

			Head = Head->Next;

			if(Head != NULL)
			{
				Head->Previous = NULL;
			}

			if(deletingnode != NULL)
			{
				ClearData(deletingnode);
				deletingnode->Next = NULL;
				deletingnode->Previous = NULL;
				delete deletingnode;
				deletingnode = NULL;
			}
		}

		Tail = NULL;
		Count = 0;

		return true;	
	}
	else if(Count == 0 && Head == NULL && Tail == NULL)
	{
		return true;
	}
	else
	{
		return false;
	}
}

// int index: 0 ~ Count-1
ListNode* CLinkedList::FindNode(size_t index)
{
	if(/*index < 0 ||*/ index >= Count)
	{
		return NULL;
	}

	ListNode* pNode = Head;
	size_t i = 0;

	while(pNode != NULL && i < Count)
	{
		if(i == index)
		{
			return pNode;
		}
		else
		{
			i++;
			pNode = pNode->Next;
		}
	}

	return NULL;
}


// If it cannot find a node, return NULL.
ListNode* CLinkedList::FindNodeByData(
	void* pData,				// in
	size_t* uIndex,				// out
	LLEqualOption nOption)		// in
{
	if(pData == NULL)
	{
		return NULL;
	}

	ListNode* pNode = Head;
	size_t i = 0;

	while(pNode != NULL && i < Count)
	{
		if(AreDataEqual(pData, pNode->Data, nOption))
		{
			if(uIndex != NULL)
			{
				*uIndex = i;
			}
			return pNode;
		}
		else
		{
			i++;
			pNode = pNode->Next;
		}
	}

	return NULL;

}




// size_t index: 0 ~ Count
bool CLinkedList::Insert(size_t index, void* pData)
{
	if(pData == NULL)
	{
		return false;
	}

	// if index equals to Count , append a data in back of list.
	if(index == Count)
	{
		return Add(pData);
	}
	
	ListNode* pNode = FindNode(index);
	if(pNode != NULL)
	{
		ListNode* newnode = new ListNode();
		if(newnode != NULL)
		{
			CreateData(newnode, pData);

			newnode->Next = pNode;
			newnode->Previous = pNode->Previous;
			
			if(pNode->Previous != NULL)
			{
				pNode->Previous->Next = newnode;
			}

			if(Head == pNode)
			{
				Head = newnode;
			}

			pNode->Previous = newnode;

			Count++;

			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

// size_t index: 0 ~ Count-1
bool CLinkedList::RemoveAt(size_t index)
{
	ListNode* pNode = FindNode(index);
	if(pNode != NULL)
	{
		if(pNode == Head && pNode == Tail)
		{
			// Only one node.
			Head = NULL;
			Tail = NULL;
		}
		else if(pNode == Head && pNode != Tail)
		{
			// Remove the first node.
			Head = Head->Next;
			if(Head != NULL)
			{
				Head->Previous = NULL;
			}
		}
		else if(pNode !=Head && pNode == Tail)
		{
			// Remove the last node.

			Tail = Tail->Previous;
			if(Tail != NULL)
			{
				Tail->Next = NULL;
			}
		}
		else
		{
			// Remove a node in the middle of list.
			if(pNode->Previous != NULL)
			{
				pNode->Previous->Next = pNode->Next;
			}
			if(pNode->Next != NULL)
			{
				pNode->Next->Previous = pNode->Previous;
			}
		}

		pNode->Next = NULL;
		pNode->Previous = NULL;
		ClearData(pNode);
		delete pNode;
		pNode = NULL;

		Count--;

		return true;
	}
	else
	{
		return false;
	}
}


// Node* pNode = NULL;
// void* pData = NULL;
//
// while((pData = GetData(&pNode) != NULL)
// {
//   ...
// }
// 
void* CLinkedList::GetData(ListNode** ppNode)
{
	if((*ppNode) == NULL)
	{
		(*ppNode) = Head;
		if((*ppNode) != NULL)
		{
			return (*ppNode)->Data;
		}
		else
		{
			return NULL;
		}
	}
	else
	{
		(*ppNode) = (*ppNode)->Next;
		if((*ppNode) != NULL)
		{
			return (*ppNode)->Data;
		}
		else
		{
			return NULL;
		}
	}
}


bool CLinkedList::Contains(void* pData, bool bIgnoreCase)
{
	if(pData == NULL)
	{
		return false;
	}

	ListNode* pNode = Head;

	while(pNode != NULL)
	{
		if(AreDataEqual(pData, pNode->Data, bIgnoreCase))
		{
			return true;
		}
		else
		{
			pNode = pNode->Next;
		}
	}

	return false;


}

bool CLinkedList::SwapNodes(ListNode* pA, ListNode* pB)
{
	if(pA != NULL && pB != NULL)
	{
		if(pA == pB) return true;

// !!!Suppose pNodeA should be in front of pNodeB.!!!

		ListNode* pPreviousA = pA->Previous; 
		ListNode* pNextA = pA->Next;

		ListNode* pPreviousB = pB->Previous;
		ListNode* pNextB = pB->Next;


		if(pA->Next == pB)
		{
			pA->Next = pNextB;
			pA->Previous = pB;

			pB->Next = pA;
			pB->Previous = pPreviousA;

			if(pNextB != NULL)
				pNextB->Previous = pA;
			if(pPreviousA != NULL)
				pPreviousA->Next = pB;
		}
		else if(pA->Next != pB)
		{
			pA->Next = pNextB;
			pA->Previous = pPreviousB;

			pB->Next = pNextA;
			pB->Previous = pPreviousA;

			if(pPreviousB != NULL)
				pPreviousB->Next = pA;
			if(pNextB != NULL)
				pNextB->Previous = pA;

			if(pPreviousA != NULL)
				pPreviousA->Next = pB;
			if(pNextA != NULL)
				pNextA->Previous = pB;
		}


		if(Head == pA)
			Head = pB;
		if(Tail == pB)
			Tail = pA;

		return true;
	}
	else
	{
		return false;
	}
}

bool CLinkedList::Sort(LLCompareOption nOption)
{
	if(Count > 1)
	{
		// selection sort
		ListNode* i = NULL;
		ListNode* j = NULL;

		for(i = Head; i != NULL; i=i->Next)
		{
			for(j = i->Next; j != NULL ; j=j->Next)
			{
				if(i != NULL && j != NULL)
				{
					if(Comparer(i->Data, j->Data, nOption) < 0)
					{
						if(SwapNodes(i, j))
						{

// After swapping the two nodes, the pointers i and j still point to original nodes.
// if using 'i=i->next' or 'j=j->next' to move pointer, the data will be in disorder.

							ListNode* tmp = NULL;

							tmp = i;
							i = j;
							j = tmp;
						}
						
					}
				}
			}
		}
	}

	return true;
}

