#ifndef __COMMONINPUTMETHOD_H__
#define __COMMONINPUTMETHOD_H__
#pragma once

#include <iostream>
#include <stdio.h>
#include "Definitions.h"
#include "CandidateIndexList.h"
#include "UnicodeString.h"
#include "PriorityList.h"
#include "UnicodeStringList.h"

class CCommonInputMethod
{
private:
	wchar_t*				m_pRoots;
	size_t					m_nRoots;
	CCandidateIndexList		m_Indexes;
	CPriorityList			m_Priorities;

	bool IsRoot(const wchar_t in_character);
	CCandidateIndex* FindCandidateIndexByID(unsigned int uCandidateIndexID);
	CCandidateWord* FindCandidateWordByIDs(unsigned int uCandidateIndexID, unsigned int uCandidateWordID);

public:
	CCommonInputMethod()
	{
		m_pRoots = NULL;
		m_nRoots = 0;
	}


	~CCommonInputMethod()
	{
		Dispose();
	}

	void Dispose()
	{
		if(m_pRoots != NULL)
		{
			delete [] m_pRoots;
			m_pRoots = NULL;
			m_nRoots = 0;
		}

		m_Indexes.Clear();
		m_Priorities.Clear();
	}

#if defined(__WINDOWS__)        
	bool ReadFile(wchar_t* in_path);
#elif defined(__LINUX__) || defined(__MACOSX__)
    bool ReadFile(char* in_path);
#endif

	bool Dump();

	bool	GetAvailableRoots(wchar_t* pInitialCharacters, bool bIgnoreCase, CUnicodeStringList* pStringList);
	size_t	GetCountOfAvailableRoots(CUnicodeStringList* pStringList);
	bool	GetAvailableRootsArray(CUnicodeStringList* pStringList, wchar_t* pBuffer, size_t uBufferSize);
	bool GetCandidateWordsByRoot(wchar_t* pRoots, bool bIgnoreCase, CCandidateIndex** ppCandidateIndex);

	bool DumpCandidateWords(CCandidateIndex* pCandidateIndex);
	size_t GetCountOfCandidateWords(CCandidateIndex* pCandidateIndex);
	bool GetCandidateWordsArray(CCandidateIndex* pCandidateIndex, CandidateWordBuffer* pCWBuffer, size_t uBufferSize);
	bool SelectCandidateWord(CCandidateIndex* pCandidateIndex, unsigned int uID, CandidateWordBuffer* pCandidateWord);
	bool SelectCandidateWord(unsigned int uCandidateIndexID, unsigned int uCandidateWordID, CandidateWordBuffer* pCandidateWord);
	bool SortCandidateWords(CCandidateIndex* pCandidateIndex, LLCompareOption nOption);

	void SortIndexes(int nOption);

	bool DumpPriorityList();
	bool LoadPriorities(const char * pFilename);
	bool SavePriorities(const char * pFilename);

	bool LoadCTB(const char * pFilename);
	bool SaveCTB(const char * pFilename);
};

#endif
