#include "CandidateWordList.h"


CCandidateWordList::CCandidateWordList()
{
	m_CandidateWordID_Counter = 0;
}

CCandidateWordList::~CCandidateWordList()
{
	CCandidateWordList::Clear();
}

// When adding a new candidate word, it will also create an unique ID.
bool CCandidateWordList::Add(CCandidateWord* pData)
{
	if(pData == NULL) return false;

	if(pData->GetID() == 0)
	{
		// Adding a ID for CCandidateWord automatically.
		if(m_CandidateWordID_Counter == 0) 
		{
			m_CandidateWordID_Counter = 1;
		}
		pData->SetID(m_CandidateWordID_Counter);
		m_CandidateWordID_Counter++;
	}

	return CLinkedList::Add(pData);
}

bool CCandidateWordList::Clear()
{
	if(CLinkedList::Clear())
	{
		m_CandidateWordID_Counter = 0;
		return true;
	}
	else
	{
		return false;
	}
}

void CCandidateWordList::ClearData(ListNode* pNode)
{
	if(pNode->Data != NULL)
	{
		CCandidateWord* pData = (CCandidateWord*)pNode->Data;
		pData->Dispose();

		// delete pNode->Data; 
		// ==> Releasing memory by void* pointer will cause Memory leak.

		delete pData;
		pNode->Data = NULL;
	}
}

bool CCandidateWordList::AreDataEqual(void* pDataA, void* pDataB, LLEqualOption nOption)
{
	if(pDataA != NULL && pDataB != NULL)
	{
		CCandidateWord* pCWA = (CCandidateWord*)pDataA;
		CCandidateWord* pCWB = (CCandidateWord*)pDataB;

		bool bIgnoreCase = (nOption == BY_STRING_IGNORECASE) ? true : false;

		return pCWA->Word.Equals(&(pCWB->Word), bIgnoreCase);
	}
	else
	{
		return false;
	}
}


//	Node*			pNode = NULL;
//	CCandidateWord*	pData = NULL;
//
//	while((pData = DumpData(&pNode)) != NULL)
//	{
//		...
//	}
CCandidateWord* CCandidateWordList::DumpData(ListNode** pNode)
{
	return (CCandidateWord*)CLinkedList::GetData(pNode);
}


void CCandidateWordList::ClearPriorities()
{
	ListNode*			pNode = NULL;
	CCandidateWord*	pData = NULL;

	while((pData = (CCandidateWord*)GetData(&pNode)) != NULL)
	{
		pData->SetPriority(0);
	}
}


// When selecting a candidate word, it's priority value will increase 1.
CCandidateWord* CCandidateWordList::SelectCandidateWord(
	CPriorityList* pPriorityList,
	unsigned int uCandidateIndexID,
	unsigned int uCandidateWordID)
{
	int priority = -1;
	CCandidateWord*	pData = GetCandidateWordPriority(uCandidateWordID, priority);
	
	if(pData == NULL) return NULL;
	
	priority++;
	pData->SetPriority(priority);

	if(pData->PriorityDataPtr == NULL)
	{
		if(pPriorityList != NULL)
		{
			PriorityData* pNewData = new PriorityData;
			if(pNewData != NULL)
			{
				pNewData->CandidateIndexID = uCandidateIndexID;
				pNewData->CandidateWordID = uCandidateWordID;
				pNewData->Priority = priority;

				pPriorityList->Add(pNewData);

				pData->PriorityDataPtr = pNewData;
			}
		
		}
	}
	else
	{
		pData->PriorityDataPtr->CandidateIndexID = uCandidateIndexID;
		pData->PriorityDataPtr->CandidateWordID = uCandidateWordID;
		pData->PriorityDataPtr->Priority = priority;
	}

	return pData;

}

CCandidateWord*	CCandidateWordList::FindCandidateWordByID(unsigned int in_uID)
{
	ListNode*			pNode = NULL;
	CCandidateWord*	pData = NULL;

	while((pData = (CCandidateWord*)GetData(&pNode)) != NULL)
	{
		if(pData->GetID() == in_uID)
		{
			return pData;
		}
	}

#ifdef OUTPUT_DEBUG_STRING
	OutputDebugString(L"Could not find the candidate word.\r\n");
#endif
	return NULL;
}


CCandidateWord* CCandidateWordList::SetCandidateWordPriority(unsigned int in_uID, int in_nPriority)
{
	CCandidateWord*	pData = NULL;

	pData = this->FindCandidateWordByID(in_uID);

	if(pData != NULL)
	{
		pData->SetPriority(in_nPriority);
		return pData;
	}


#ifdef OUTPUT_DEBUG_STRING
	OutputDebugString(L"Could not find the candidate word.\r\n");
#endif
	return NULL;

}


CCandidateWord*	CCandidateWordList::GetCandidateWordPriority(unsigned int in_uID, int& out_rPriority)
{
	CCandidateWord*	pData = NULL;

	pData = this->FindCandidateWordByID(in_uID);

	if(pData != NULL)
	{
		out_rPriority = pData->GetPriority();
		return pData;
	}

#ifdef OUTPUT_DEBUG_STRING
	OutputDebugString(L"Could not find the candidate word.\r\n");
#endif
	return NULL;
}

// a > b return 1
// a == b return 0
// a < b return -1
int CCandidateWordList::Comparer(void* pDataA, void* pDataB, LLCompareOption nOption)
{
	if(pDataA == NULL || pDataB == NULL) return 0;

	CCandidateWord* pCWA = (CCandidateWord*)pDataA;
	CCandidateWord* pCWB = (CCandidateWord*)pDataB;

	switch(nOption)
	{
	case DES_BY_PRIORITY: // Descending by priority. Ex: 6, 6, 5, 2, 1, 0, ...
		{
			if(pCWA->GetPriority() > pCWB->GetPriority())
				return 1;
			else if(pCWA->GetPriority() == pCWB->GetPriority())
				return 0;
			else if(pCWA->GetPriority() < pCWB->GetPriority())
				return -1;
		}
		break;

	case ASC_BY_PRIORITY: // Ascending by priority. Ex: 0, 0, ...., 1, 2, 5, 6, 6
		{
			if(pCWA->GetPriority() < pCWB->GetPriority())
				return 1;
			else if(pCWA->GetPriority() == pCWB->GetPriority())
				return 0;
			else if(pCWA->GetPriority() > pCWB->GetPriority())
				return -1;
		}
		break;

	case DES_BY_ID: // Descending by ID. Ex: 5, 4, 3, 2, 1
		{
			if(pCWA->GetID() > pCWB->GetID())
			{
				return 1;
			}
			else if(pCWA->GetID() == pCWB->GetID())
			{
				return 0;
			}
			else if(pCWA->GetID() < pCWB->GetID())
			{
				return -1;
			}
		}
		break;

	case ASC_BY_ID: // Ascending by ID. Ex: 1, 2, 3, 4, 5
		{
			if(pCWA->GetID() < pCWB->GetID())
			{
				return 1;
			}
			else if(pCWA->GetID() == pCWB->GetID())
			{
				return 0;
			}
			else if(pCWA->GetID() > pCWB->GetID())
			{
				return -1;
			}
		}
		break;
	}

	return 0;
}


