/*
 * PROPRIETARY INFORMATION.  This software is proprietary to POWDER
 * Development, and is not to be reproduced, transmitted, or disclosed
 * in any way without written permission.
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        worldstate.cpp ( Save Scummer Library, C++ )
 *
 * COMMENTS:
 */

#include "worldstate.h"

#include "map.h"
#include "mob.h"
#include "score.h"
#include "speed.h"
#include "msg.h"
#include "avatar.h"

WORLDSTATE::WORLDSTATE()
{
    myMainMap = 0;
    myRef = 0;
}

WORLDSTATE::~WORLDSTATE()
{
    delete myMainMap;
}

void
WORLDSTATE::incRef()
{
    myRef++;
}

void
WORLDSTATE::decRef()
{
    myRef--;
    if (myRef <= 0)
    {
	delete this;
    }
}


WORLDSTATE *
WORLDSTATE::pushState(MAP *mainmap)
{
    WORLDSTATE	*state;

    state = new WORLDSTATE();

    state->incRef();
    
    state->myMainMap = mainmap->copyAll();
    state->myScore = score_get();
    state->myTime = spd_gettime();
    state->myHistory = msg_gethistoryline();
    state->myAvatarHP_DPDF = MOB::getAvatarHP_DPDF();

    state->myAvatarMP = avatar_mp();
    
    state->myAvatarHP = 0;
    if (MOB::getAvatar())
	state->myAvatarHP = MOB::getAvatar()->getHP();

    state->myAvatarProb = avatar_prob();
    state->myAvatarProbExp = avatar_probexp();

    return state;
}

MAP *
WORLDSTATE::popState()
{
    MAP		*result;
    
    score_set(myScore);
    spd_settime(myTime);
    msg_scrolltohistory(myHistory);
    result = myMainMap->copyAll();
    result->locateAvatar(MOB_AVATAR);

    MOB::getAvatarHP_DPDF() = myAvatarHP_DPDF;

    avatar_setmp(myAvatarMP);
    avatar_setprob(myAvatarProb, myAvatarProbExp);

    // Impossible to save a victory state, or so I say :>
    avatar_setvictory(false);
    
    return result;
}
