/*
 * Licensed under BSD license.  See LICENCE.TXT  
 *
 * Produced by:	Jeff Lait
 *
 *      	7DRL Development
 *
 * NAME:        ptrlist.h ( Letter Hunt Library, C++ )
 *
 * COMMENTS:
 *	Implements a simple list of pointers.
 */

#ifndef __ptrlist_h__
#define __ptrlist_h__

template <typename PTR>
class PTRLIST
{
public:
    PTRLIST();
    ~PTRLIST();

    void		 append(PTR item);

    // Reverses the order of the stack.
    void		 reverse();

    // Empties the stack
    void		 clear();

    // Sets entries to the given size.
    void		 resize(int size);

    PTR			 operator()(int idx) const;
    int			 entries() const;

    void		 set(int idx, PTR item);

    // Removes all instances of "item" from
    // this list.
    void		 removePtr(PTR item);

    // Returns the last item on this list and decreases
    // the length.
    PTR			 pop();

    // Returns the last element.
    // The index allows you to specify N elements from the end, where
    // 0 is the last element and 1 second last.
    PTR			 top(int idx = 0) const { return (*this)(entries()-1-idx); }

    // Returns the first item from this list and
    // removes it.
    PTR			 removeFirst();

    // Finds the given item, returns -1 if fails.
    int			 find(PTR item) const;

private:
    PTR			 *myList;
    int			  myEntries;
    int			  mySize;
};

// For crappy platforms:
#include "ptrlist.cpp"

#endif

