#!/bin/sh

#Temporary permission fix
if [ "`ls -l /home/user/.config/savepress | grep -o "root"`" == "root" ]; then
	chown user:users /home/user/.config/savepress
	dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
	run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress-editor permission-issue fixed!"
	exit
fi

if [ -f /etc/systemui/savepress.xml ]; then {
	echo "running savepress.."
	}
else {
	echo '<powerkeymenu path="/">
 <title>powerup_application_title</title>
 <po>osso-powerup-shutdown</po>

 <menuitem priority="200" name="Savepress is active" visible="on">
  <keyfile>/tmp/savepress</keyfile>
 </menuitem>

</powerkeymenu>' > /etc/systemui/savepress.xml
	killall systemui
	echo "wrote systemui-button.."
	echo "running savepress.."
	}
fi

echo " checking key.."

secs="`cat /home/user/.config/savepress | grep "vdelay" | sed 's/vdelay: //g' | sed 's/ //g'`"
for i in `seq $secs`; do {
	sleep 1
	if [ `hal-get-property --udi /org/freedesktop/Hal/devices/platform_kb_lock --key button.state.value` == false ]; then {
		echo "  not pressed.."
		exit
		}
	fi
	}
done

echo "  pressed.."

if [ -f /tmp/savepress ]; then {
	if [ "`cat /tmp/savepress-value | grep -o "bright:"`" != "" ]; then {
		echo "`cat /tmp/savepress-value | grep "bright" | sed 's/bright://g' | sed 's/ //g'`" > /sys/class/backlight/acx565akm/brightness
		}	
	fi
	dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
	echo "   deactivates.."
	run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress is disabled!"
	if [ "`cat /tmp/savepress-value | grep "lock"`" == "lock" ]; then {
		/usr/sbin/kernel-config load savepress-tmp
		rm /home/user/.kernel/savepress-tmp
		echo "    rm /home/user/.kernel/savepress-tmp"
		}
	else {
		/usr/sbin/kernel-config limits `cat /tmp/savepress-value | grep "min" | sed 's/min: //g'` `cat /tmp/savepress-value | grep "max" | sed 's/max: //g'`
		}
	fi
	rm /tmp/savepress
	echo "    rm /tmp/savpress"

	# restore settings
	if [ "`cat /tmp/savepress-value | grep "offline"`" != "" ]; then {
		dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:"normal"
		echo "    enabled cellular radio"
		}
	fi
	if [ "`cat /tmp/savepress-value | grep "fmt"`" != "" ]; then {
		/usr/bin/fmtx_client -p 1
		echo "    enabled fm transmitter"
		}
	fi
	if [ "`cat /tmp/savepress-value | grep "wlan-dis"`" != "" ]; then {
		modprobe wl12xx
		wl1251-cal
		stop wlancond
		start wlancond
		ifconfig wlan0 up
		dbus-send --system --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
		dbus-send --system --type=method_call --dest=com.nokia.icd /com/nokia/icd com.nokia.icd.connect string:"[ANY]" uint32:0
		echo "    started wlan"
		}
	fi
	if [ "`cat /tmp/savepress-value | grep "mode" | sed 's/mode: //g'`" != "" ]; then {
		dbus-send --system --type=method_call --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.set_selected_radio_access_technology byte:"`cat /tmp/savepress-value | grep "mode" | sed 's/mode: //g'`"
		echo "   disabled gsm-only"
		}
	fi
	rm /tmp/savepress-value
	echo "    rm /tmp/savepress-value"
	}
else {
	echo "  activating.."
	dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"unlocked"
	echo "on" > /tmp/savepress
	run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"savepress is activated!"
	echo "    created /tmp/savepress"

	# activate settings
	if [ "`cat /home/user/.config/savepress | grep "vwlan" | sed 's/vwlan: //g' | sed 's/ //g'`" == "True" ]; then {
		if [ -f /var/run/resolv.conf.wlan0 ]; then {
			dbus-send --system --dest=com.nokia.icd /com/nokia/icd_ui com.nokia.icd_ui.disconnect boolean:true
			ifconfig wlan0 0.0.0.0
			ifconfig wlan0 down
			rmmod wl12xx
			echo "wlan-dis" >> /tmp/savepress-value
			echo "    disabled wlan"
			}
		elif [ -f /var/run/resolv.conf.gprs ]; then {
			dbus-send --system --dest=com.nokia.icd /com/nokia/icd_ui com.nokia.icd_ui.disconnect boolean:true
			echo "    disconnected gprs"
			}
		fi
		}
	fi
	
	if [ "`cat /home/user/.config/savepress | grep "vblue:" | sed 's/vblue: //g' | sed 's/ //g'`" == "True" ]; then {
		dbus-send --system --type=method_call --dest=org.bluez $(dbus-send --system --print-reply --dest=org.bluez / org.bluez.Manager.ListAdapters | awk -F "\"" '/at/ {print $2}') org.bluez.Adapter.SetProperty string:Powered variant:boolean:false
		echo "    disconnected bluetooth"
		}
	fi

	if [ "`cat /home/user/.config/savepress | grep "vfmt:" | sed 's/vfmt: //g' | sed 's/ //g'`" == "True" ]; then {
		if [ `/usr/bin/fmtx_client | grep "state=" | sed 's/state=//g'` == "enabled" ]; then {
			/usr/bin/fmtx_client -p 0
			echo "fmt" >> /tmp/savepress-value
			echo "    disabled fm transmitter"
			}
		fi
		}
	fi

	if [ "`cat /home/user/.config/savepress | grep "voffline:" | sed 's/voffline: //g' | sed 's/ //g'`" == "True" ]; then {
		if [ "`dbus-send --print-reply --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.get_device_mode | grep -o normal`" == "normal" ]; then {
			dbus-send --system --dest=com.nokia.mce --type=method_call /com/nokia/mce/request com.nokia.mce.request.req_device_mode_change string:"offline"
			echo "offline" >> /tmp/savepress-value
			echo "    disabled cellular radio"
			}
		fi
		}
	else {
		if [ "`cat /home/user/.config/savepress | grep "v2g:" | sed 's/v2g: //g' | sed 's/ //g'`" == "True" ]; then {
			netmode="`dbus-send --system --type=method_call --print-reply --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.get_selected_radio_access_technology | awk '/b/ {print $2}'`"
			if [ "$netmode" != "1" ]; then {
				echo "mode: $netmode" >> /tmp/savepress-value
				dbus-send --system --type=method_call --dest=com.nokia.phone.net /com/nokia/phone/net Phone.Net.set_selected_radio_access_technology byte:1
				echo "    enabled gsm-only"
				}
			fi
			}
		fi
		}
	fi
	sleep 2

	if [ "`cat /home/user/.config/savepress | grep "vbright:" | sed 's/vbright: //g' | sed 's/ //g'`" == "True" ]; then {
		echo "bright: `cat /sys/class/backlight/acx565akm/brightness`" >> /tmp/savepress-value
		dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"locked"
		echo "3" > /sys/class/backlight/acx565akm/brightness
		echo "   display brightness set to 3"
		}	
	else {
		dbus-send --system --type=method_call --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_tklock_mode_change string:"locked"
		}
	fi

	if [ "`cat /home/user/.config/savepress | grep "vlock:" | sed 's/vlock: //g' | sed 's/ //g'`" == "True" ]; then {
		echo "lock" >> /tmp/savepress-value
		/usr/sbin/kernel-config save savepress-tmp
		/usr/sbin/kernel-config lock `cat /home/user/.config/savepress | grep "vmhz:" | sed 's/vmhz: //g' | sed 's/ //g'` `cat /home/user/.config/savepress | grep "vvolt:" | sed 's/vvolt: //g' | sed 's/ //g'` `cat /home/user/.config/savepress | grep "vdsp:" | sed 's/vdsp: //g' | sed 's/ //g'`
		}
	else {
		echo "`/usr/sbin/kernel-config show | grep "max" | sed 's/. frequency//g'`" >> /tmp/savepress-value
		echo "`/usr/sbin/kernel-config show | grep "min" | sed 's/. frequency//g'`" >> /tmp/savepress-value
		/usr/sbin/kernel-config limits `cat /home/user/.config/savepress | grep "vmin" | sed 's/vmin: //g' | sed 's/ //g'` `cat /home/user/.config/savepress | grep "vmax" | sed 's/vmax: //g' | sed 's/ //g'`
		}
	fi
	}
fi
echo "  done.."
