#!/usr/bin/python2.5
# versione 1.5
# ui di configurazione per savepu
# by m750 at smartphonetab.net

import sys
import osso
import os
import time

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from savecpu_ui import *


Global_Version = '2.20.15-1'
UI_Version = '1.5'

try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s


class About(QtGui.QMainWindow):

    def __init__(self, parent=None):

        QMainWindow.__init__(self,parent)
        self.parent = parent
        self.setWindowTitle("savecpu About")

        aboutScrollArea = QScrollArea(self)
        aboutScrollArea.setWidgetResizable(True)
        awidget = QWidget(aboutScrollArea)
        awidget.setMinimumSize(200,500)
        awidget.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )
        aboutScrollArea.setSizePolicy( QSizePolicy.Expanding, QSizePolicy.Expanding )

        aboutLayout = QVBoxLayout(awidget)

        aboutLabel = QLabel('''<center><b>savecpu</b> %s
               <br>Application for N900 with Titan's/Pali's kernel and active overclock.
               <br>It works in background, watching the temperature (no more through the
               <br><b>bq27200</b> module).
               <br>
               <br></center>With this interface it's possible to set:
               <br> - LED colors
               <br> - activation temperature
               <br> - control delay
               <br> - enable/disable check
               <br><center>by <b>Marco (m750 at smartphonetab.net)</b>
               <br></center>''' % Global_Version )
        aboutLayout.addWidget(aboutLabel)
        
        awidget.setLayout(aboutLayout)
        aboutScrollArea.setWidget(awidget)
        self.setCentralWidget(aboutScrollArea)
        self.show()        
      


class MyForm(QtGui.QMainWindow):

        global configurazione
        BASEDIR = '/opt/savecpu/'
        CONFFILE = 'savecpu.conf'
        configurazione = os.path.join(BASEDIR, CONFFILE)


        def __init__(self, parent=None):

                global colore_r , colore_g , colore_b, avvio, temperatura, temperatura_all, ritardo, check_v

                self.x=230
                self.y=50
                check_v = 0

                #build parent user interface
                QtGui.QWidget.__init__(self, parent)
                self.ui = Ui_widget()
                self.ui.setupUi(self)

                # menu
                #self.ui.menubar.setGeometry(QtCore.QRect(30, 0, 500, 21))
                #self.ui.actionAbout.setText("by m750 at maemomeego.net\nDowngrade overclock over a certain temperature")
                QtCore.QObject.connect(self.ui.actionQuit, QtCore.SIGNAL('triggered()'), QtGui.qApp, QtCore.SLOT('quit()'))
                QtCore.QObject.connect(self.ui.actionAbout, QtCore.SIGNAL('triggered()'), self.doAbout)


                colore_r = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/led_r/ {print $2}\'').read()
                colore_g = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/led_g/ {print $2}\'').read()
                colore_b = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/led_b/ {print $2}\'').read()

                temperatura_all = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/temp/ {print $2}\'').read()

                ritardo = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/delay/ {print $2}\'').read()

                avvio = os.popen('cat /opt/savecpu/savecpu.conf | awk \'/startup/ {print $2}\'').read()

                lungh = len(colore_r) 
                if lungh==0:
                	colore_r = '0'

                lungh = len(colore_g) 
                if lungh==0:
                	colore_g = '0'

                lungh = len(colore_b) 
                if lungh==0:
                	colore_b = '0'

                lungh = len(temperatura_all) 
                if lungh==0:
                	temperatura_all = '50'

                lungh = len(ritardo) 
                if lungh==0:
                	ritardo = '600'

                lungh = len(avvio) 
                if lungh==0:
                	avvio = '0'


                colore_r = int(colore_r.strip())
                colore_g = int(colore_g.strip())
                colore_b = int(colore_b.strip())

                if colore_r ==1:
                     self.ui.checkBox_lr.setChecked(True)
                else:
                     self.ui.checkBox_lr.setChecked(False)

                if colore_g ==1:
                     self.ui.checkBox_lg.setChecked(True)
                else:
                     self.ui.checkBox_lg.setChecked(False)

                if colore_b ==1:
                     self.ui.checkBox_lb.setChecked(True)
                else:
                     self.ui.checkBox_lb.setChecked(False)


                #connetto cambio stato check
                QtCore.QObject.connect(self.ui.checkBox_lr, QtCore.SIGNAL('stateChanged(int)'), self.stato_lr)
                QtCore.QObject.connect(self.ui.checkBox_lg, QtCore.SIGNAL('stateChanged(int)'), self.stato_lg)
                QtCore.QObject.connect(self.ui.checkBox_lb, QtCore.SIGNAL('stateChanged(int)'), self.stato_lb)

                # temperatura allarme

                temperatura_all = int(temperatura_all.strip())
                self.ui.horizontalSlider_temp.setProperty(_fromUtf8("value"), temperatura_all)
                self.ui.label_temperatura_valore.setText(QtGui.QApplication.translate("widget", str(temperatura_all), None, QtGui.QApplication.UnicodeUTF8))

                QtCore.QObject.connect(self.ui.horizontalSlider_temp, QtCore.SIGNAL('valueChanged(int)'), self.temperatura_cambia)



                # ritardo check
                ritardo = int(ritardo.strip())/60
                self.ui.horizontalSlider_intervallo.setProperty(_fromUtf8("value"), ritardo)
                self.ui.label_intervallo_valore.setText(QtGui.QApplication.translate("widget", str(ritardo), None, QtGui.QApplication.UnicodeUTF8))

                QtCore.QObject.connect(self.ui.horizontalSlider_intervallo, QtCore.SIGNAL('valueChanged(int)'), self.intervallo_cambia)


                avvio = int(avvio.strip())

                if avvio ==1:
                     self.ui.checkBox_enable.setChecked(True)
                else:
                     self.ui.checkBox_enable.setChecked(False)

                QtCore.QObject.connect(self.ui.checkBox_enable, QtCore.SIGNAL('stateChanged(int)'), self.stato_enable)

                # salva impostazioni
                QtCore.QObject.connect(self.ui.Button_salva, QtCore.SIGNAL("clicked()"), self.salva_impostazioni)

                self.paint = QtGui.QPainter()

  
        def paintEvent(self, e):

                global colore_r , colore_g , colore_b, enable, temperatura, check_v

                time.sleep(0.1)
                #temperatura = os.popen('cat /sys/class/power_supply/bq27200-0/temp').read()
                temperatura = os.popen('cat /sys/devices/platform/omap34xx_temp/temp1_input').read()
                # kernel v47
                #print temperatura
                #temperatura=temperatura.strip()
                #print temperatura
                #if len(temperatura) == 3 :
                #    temperatura = int(temperatura) / 10
                temperatura = int(temperatura) + 7

                temperatura=str(temperatura)    
                #print temperatura





                check = os.popen('ps -ef | grep /opt/savecpu/savecpu.sh | awk \'/start/ {print $7}\'').read()
                check=check.strip()

                #print check
                if str(check)=='start':
                      check_v=check_v + 1
                      if check_v>6:
                            check_v=6
                else:
                      check_v=check_v - 1
                if check_v>0:
                      self.ui.label_stato.setText(QtGui.QApplication.translate("widget",'ON', None, QtGui.QApplication.UnicodeUTF8))
                else:
                      self.ui.label_stato.setText(QtGui.QApplication.translate("widget",'OFF', None, QtGui.QApplication.UnicodeUTF8))
                      check_v=0

                self.ui.lcdNumber_temperatura.setProperty(_fromUtf8("intValue"), temperatura)
                self.paint.begin(self)
                self.paint.save()

                #self.x=230
                #self.y=50

                #riempimento
                self.paint.setRenderHint(QtGui.QPainter.Antialiasing)
 
                # senza questa riga non si aggiornava il colore!

                self.setBackgroundRole(QtGui.QPalette.Base)

                self.paint.setPen(QtGui.QColor(200,200,200))
                self.paint.setBrush(QtGui.QColor(100,100,100));
                self.paint.drawEllipse(self.x, self.y, 100, 100)
                self.paint.restore()

                # cerchio colore led
                self.paint.setBrush(QtGui.QColor(colore_r*255, colore_g*255, colore_b*255));
                self.paint.setPen(QtGui.QColor(200,200,200))

                self.paint.drawEllipse(self.x+5, self.y+5, 90, 90)
                self.paint.end()

#        def touchEvent(self, event):

#                self.touch=event.pressure()
#                print self.touch
#                event.accept()
                #update calls the paintEvent
#                self.update()

        def stato_lr(self):
                global colore_r
                if self.ui.checkBox_lr.isChecked():
			colore_r=1
                else:
			colore_r=0

        def stato_lg(self):
                global colore_g
                if self.ui.checkBox_lg.isChecked():
			colore_g=1
                else:
			colore_g=0

        def stato_lb(self):
                global colore_b
                if self.ui.checkBox_lb.isChecked():
			colore_b=1
                else:
			colore_b=0

        def stato_enable(self):
                global avvio
                if self.ui.checkBox_enable.isChecked():
			avvio=1
                else:
			avvio=0

        def temperatura_cambia(self,number):
               global temperatura_all
               temperatura_all=number 
               self.ui.label_temperatura_valore.setText(QtGui.QApplication.translate("widget", str(temperatura_all), None, QtGui.QApplication.UnicodeUTF8))

        def intervallo_cambia(self,number):
               global ritardo
               ritardo=number 
               self.ui.label_intervallo_valore.setText(QtGui.QApplication.translate("widget", str(ritardo), None, QtGui.QApplication.UnicodeUTF8))

        def salva_impostazioni(self):
               global configurazione, colore_r , colore_g , colore_b, avvio, temperatura, temperatura_all, ritardo
               self.ui.Button_salva.setEnabled(False)

               try:
                     check_kill = os.popen('ps -ef | grep /opt/savecpu/savecpu.sh | awk \'/start/ {print $1}\'').read()
                     os.system('kill -9 '+check_kill)
                     os.popen('sh /opt/savecpu/killsavecpu.sh &')
                     os.close

               except:
              	print "script non attivo"

               try:
                     scrivi_conf = open(configurazione,'w')
               except:
                     os.system('/bin/sh /opt/savecpu/createconf.sh &')
                     time.sleep(1)
                     scrivi_conf = open(configurazione,'w')


               scrivi_conf = open(configurazione,'w')

               testo1 = 'led_r' + " " + str(colore_r) + '\n'
               testo2 = 'led_g' + " " + str(colore_g) + '\n'
               testo3 = 'led_b' + " " + str(colore_b) + '\n'
               testo4 = 'temp' + " " + str(temperatura_all) + '\n'
               testo5 = 'startup' + " " + str(avvio) + '\n'
               testo6 = 'delay' + " " + str(ritardo*60) + '\n'

               scrivi_conf.write(testo1)
               scrivi_conf.write(testo2)
               scrivi_conf.write(testo3)
               scrivi_conf.write(testo4)
               scrivi_conf.write(testo5)
               scrivi_conf.write(testo6)

               scrivi_conf.close()

               if avvio ==1:
                   time.sleep(1)
                   os.system('exec /opt/savecpu/savecpu.sh start &')
                   #print 'avvio'
                   os.close

               self.ui.Button_salva.setEnabled(True)

        def doAbout(self):
        
             stackwindow=About(self)
             stackwindow.show()


if __name__ == "__main__":
        app = QtGui.QApplication(sys.argv)
        myapp = MyForm()
        myapp.show()
        os.close
        sys.exit(app.exec_())
