#include "sabconnector.h"
#include "settings.h"
#include <qdebug.h>
#include <QXmlStreamReader>
#include <QEventLoop>
#include <QFile>
#include <QDomDocument>

SabConnector::SabConnector()
{
    //*settingsobj = Settings();
    nam = new QNetworkAccessManager(this);
    connect(nam, SIGNAL(finished(QNetworkReply*)), this, SLOT(finishedStatus(QNetworkReply*)));
    settingsobj = new Settings();
}

void SabConnector::refreshDownloads()
{
    QString a = getUrl(QString("qstatus"));

    qDebug() << "url: "+a;
    QUrl url(a);
    /*QNetworkReply * reply =*/ nam->get(QNetworkRequest(url));
}

void SabConnector::refreshHistory()
{
    QString a = getUrl(QString("history"))+"&start=0&limit=10";
    qDebug() << "url: "+a;
    QUrl url(a);
    /*QNetworkReply * reply =*/ nam->get(QNetworkRequest(url));
}


int SabConnector::testConnection(QString servername, QString port, QString apikey = "")
{
    QString a = "http://"+servername+":"+port+"/api?mode=version";
    QNetworkAccessManager * testnam = new QNetworkAccessManager(this);
    qDebug() << "url: "+a;
    QUrl url(a);
    QNetworkReply * reply = testnam->get(QNetworkRequest(url));
    // execute an event loop to process the request (nearly-synchronous)
    QEventLoop eventLoop;
    // also dispose the event loop after the reply has arrived
    connect(testnam, SIGNAL(finished(QNetworkReply *)), &eventLoop, SLOT(quit()));
    eventLoop.exec();
    int retval = 0;
    if (reply->error() == QNetworkReply::NoError)
    {
        QByteArray bytes = reply->readAll();  // bytes
        QString antwoord(bytes); // string
        qDebug() << "-Testreply:\n"+antwoord;
        if(antwoord.count('.')==2)
            retval = 1;
        else
            emit errorOccured("Invalid hostname or port.");
    }
    delete reply;

    if(retval==1 && apikey!="") //als connectie succesvol, test apikey
    {
         a = "http://"+servername+":"+port+"/api?mode=qstatus&output=xml&apikey="+apikey;
         QUrl url(a);
         QNetworkReply * reply = testnam->get(QNetworkRequest(url));
         // execute an event loop to process the request (nearly-synchronous)
         QEventLoop eventLoop;
         // also dispose the event loop after the reply has arrived
         connect(testnam, SIGNAL(finished(QNetworkReply *)), &eventLoop, SLOT(quit()));
         eventLoop.exec();
         if (reply->error() == QNetworkReply::NoError)
         {
             QByteArray bytes = reply->readAll();  // bytes
             QString antwoord(bytes); // string
             QDomDocument doc("document");
             doc.setContent(antwoord);
             //qDebug() << "-Testreply:\n"+antwoord;

             QDomNodeList dnl = doc.elementsByTagName("error");
             if(dnl.length()==0)
                 retval = 2;
             else
             {
                 qDebug() << "-ERROR: \n"+ dnl.at(0).nodeValue();
                 emit errorOccured(dnl.at(0).nodeValue());
             }
         }
    }

    return retval;
}

void SabConnector::finishedStatus(QNetworkReply* reply)
{
    QByteArray bytes = reply->readAll();  // bytes

    QString data(bytes); // string
    qDebug() << "finishedStatus:\n"+data;
    QMap<QString,QMap<QString,QString > > downloads;
    if (reply->error() == QNetworkReply::NoError)
    {
        QXmlStreamReader xml(data);
        xml.readNext();
        while (!xml.atEnd()) {

            xml.readNext();

            if (xml.tokenType() == QXmlStreamReader::StartElement)
            {
                qDebug() << xml.name().toString();
                if(xml.name()=="mbleft" || xml.name()=="speed" || xml.name()=="state" || xml.name()=="status")
                {
                    emit updateLabelReady(xml.name().toString(), xml.readElementText());
                    qDebug() <<  "Emitted: "+xml.name().toString()+ " | "+xml.readElementText();
                } else if(xml.name()=="jobs") {
                    qDebug() <<  "Enter jobs";
                    xml.readNext();
                    while(xml.name() == "job" && xml.tokenType() == QXmlStreamReader::StartElement)
                    {
                        qDebug() <<  "New job";
                        QMap<QString,QString> download;
                        QString id;
                        qDebug() <<  "Enter job";
                        int i = 0;
                        while(!(xml.tokenType() == QXmlStreamReader::EndElement && xml.name() == "job"))
                        {
                            xml.readNext();
                            i++;
                            qDebug() <<  "Job reading: "+xml.name().toString();
                            if(xml.tokenType() == QXmlStreamReader::StartElement && xml.name()=="id") {
                                id = xml.readElementText();
                            } else if(xml.tokenType() == QXmlStreamReader::StartElement ) {
                                download.insert(xml.name().toString(),xml.readElementText());
                            }
                            if (i > 10)
                                break;
                        }
                        downloads.insert(id,download);
                        xml.readNext();
                        xml.readNext();
                        xml.readNext();
                        xml.readNext();
                        qDebug() <<  "End job";
                    }
                    qDebug() <<  "Leave jobs";
                    emit downloadListReady(downloads);
                } else if(xml.name()=="slots") {
                    qDebug() <<  "Enter slots";
                    xml.readNext();
                    while(xml.name() == "slot" && xml.tokenType() == QXmlStreamReader::StartElement)
                    {
                        qDebug() <<  "New slot";
                        QMap<QString,QString> download;
                        QString id;
                        qDebug() <<  "Enter slot";
                        int i = 0;
                        while(!(xml.tokenType() == QXmlStreamReader::EndElement && xml.name() == "slot"))
                        {
                            xml.readNext();
                            i++;
                            qDebug() <<  "slot reading: "+xml.name().toString();
                            if(xml.tokenType() == QXmlStreamReader::StartElement && xml.name()=="id") {
                                id = xml.readElementText();
                            } else if(xml.tokenType()==QXmlStreamReader::StartElement && xml.name()=="stage_log") {
                                qDebug() << "stage_log";
                                while(!(xml.tokenType() == QXmlStreamReader::EndElement && xml.name()=="stage_log"))
                                {
                                    xml.readNext();
                                }
                            } else if(xml.tokenType() == QXmlStreamReader::StartElement ) {
                                download.insert(xml.name().toString(),xml.readElementText());
                            }

                            if (i > 100)
                            {
                                qDebug() << "Too much slots";
                                break;
                            }
                        }
                        downloads.insert(id,download);
                        xml.readNext();
                        xml.readNext();
                        qDebug() <<  "End slot";
                    }
                    qDebug() <<  "Leave slots";
                    emit historyListReady(downloads);
                }
            }
        }

        /*QMapIterator<QString, QMap<QString,QString> > i(downloads);
        while (i.hasNext()) {
            i.next();
            QMap<QString,QString> download = i.value();
            qDebug() <<  "Hmm: "+download["filename"];
        }*/



        qDebug() <<  "Done with XML";
        if(xml.error())
        {
            qDebug() <<  "XML Error: " + xml.errorString();
            emit errorOccured(xml.errorString());
        }
    }
    else
    {
           qDebug() <<  "Connection error: " + reply->errorString();

    }

    //delete reply;
    qDebug() <<  "Done with func";
}

QString SabConnector::getUrl(QString mode)
{
    return QString (QString("http://").append(settingsobj->getAdress().append(":").append(QString::number(settingsobj->getPort())).append("/api?mode=").append(mode).append("&output=xml&apikey=").append(settingsobj->getAPIkey())));
}

QString SabConnector::getUrlNoXML(QString mode)
{
    return QString (QString("http://").append(settingsobj->getAdress().append(":").append(QString::number(settingsobj->getPort())).append("/api?mode=").append(mode).append("&apikey=").append(settingsobj->getAPIkey())));
}


void SabConnector::addNZB(QString filename)
{
    qDebug() << "addNZB "+filename;
    QString a = getUrl(QString("addfile"));
    QUrl url(a);
    qDebug() << "url: "+a;
    QNetworkRequest qnr(url);
    QByteArray qba;
    QFile f(filename);
    //qba.append("name=");
    //QString boundary("---------------------------7d934a10503cc");
    /*QString crlf(0x0d);
    crlf.append(0x0a);

    qba.append("--" + boundary + crlf + "Content-Disposition: form-data; name=\"nzbfile\"");
    qba.append("filename=\"file1.rar\"");
    qba.append(crlf + "Content-Type: Application/Octet" + crlf + crlf);
    qba.append(f.readAll());
    qba.append(crlf);*/

    /*QNetworkReply * reply =*/ nam->post(qnr,qba);
}
