#ifndef RSSFEED_H
#define RSSFEED_H

#include <QWidget>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QXmlStreamReader>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QLabel>
#include <QStackedLayout>

#include "marqueelabel.h"

class RSSFeed : public QWidget
{
    Q_OBJECT

    QNetworkAccessManager* netman;
    QXmlStreamReader xml;

    QString currentTag;
    QString currentLink;
    QString linkString;
    QString titleString;

    int connectionId;
    int i,f;

    QString mlText;
    QTreeWidget *treeWidget;
    QStackedLayout *mainlayout;
    QLabel *status;

    MarqueeLabel *ml;

public:
    RSSFeed(QString defaults, QWidget *parent);
    void fetch(QString siteUrl);

protected:
    void setAppearance();

public slots:
    void finished(QNetworkReply *);
    void AddLabel();
    void DelLabel();

private:
     int parseXml();

signals:
     void disableFetch();
     void enableFetch();
};

#endif // RSSFEED_H
