#include <QtGui>
#include <QtCore>
#include <QtNetwork>

#include "rssfeed.h"

RSSFeed::RSSFeed(QString defaults, QWidget *parent) : QWidget(parent)
{
    QTextCodec::setCodecForTr(QTextCodec::codecForName("utf-8"));
    netman = new QNetworkAccessManager(this);

    setAppearance();

    currentLink = tr("не доступно");
    setToolTip(currentLink);

    treeWidget = new QTreeWidget(this);
    treeWidget->setVisible(false);

    connect(this,SIGNAL(disableFetch()),parent,SLOT(DisableFetch()));
    connect(this,SIGNAL(enableFetch()),parent,SLOT(EnableFetch()));
   
    connect(netman, SIGNAL(finished(QNetworkReply*)),
	        this, SLOT(finished(QNetworkReply*)));    

    fetch(defaults);
}

void RSSFeed::setAppearance()
{
    setMaximumSize(QApplication::desktop()->width()-53,23);
    setMinimumSize(QApplication::desktop()->width()-53,23);

    mainlayout = new QStackedLayout();
    status = new QLabel("",this);

    ml = new MarqueeLabel(this);
    ml->setTextFormat(Qt::RichText);
    ml->setFixedSize(QApplication::desktop()->width()-53,23);
    QPalette p;
    p.setBrush(QPalette::WindowText, Qt::green);
    ml->setPalette(p);
    ml->setFont(QFont("Arial", 12, 12));
    mainlayout->insertWidget(0,status);
    mainlayout->insertWidget(1,ml);
    status->setAlignment(Qt::AlignCenter);
    ml->setAlignment(Qt::AlignCenter);
    mainlayout->setMargin(0);
    this->setLayout(mainlayout);
}

void RSSFeed::finished(QNetworkReply* reply)
{
    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();

    qDebug() << tr("ЗАГРУЗКА ЗАВЕРШЕНА") << statusCode;

    switch (statusCode)
    {
        case 200:                               // OK
        {
            // process reply

            xml.addData(reply->readAll());
            if (parseXml()==0)
            {
                mainlayout->setCurrentIndex(1);
                i=0; f=0;
                mlText="";
                AddLabel();
                ml->startTime();
            }
            emit enableFetch();
            break;
        }

        case 301:                               // redirect (Location: [URL])
        {
            qDebug() << tr("ПЕРЕНАПРАВЛЕНИЕ на ") << reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toString();
            fetch(reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toString());
            break;
        }

        case 302:                               // redirect (Location: [URL])
        {
            qDebug() << tr("ПЕРЕНАПРАВЛЕНИЕ на ") << reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toString();
            fetch(reply->attribute(QNetworkRequest::RedirectionTargetAttribute).toString());
            break;
        }

        case 400:                               // bad request
        {
            status->setText(tr("...HTTP ERROR: 400/Неправильный запрос..."));
            status->setStyleSheet("color: red;");
            mainlayout->setCurrentIndex(0);
            emit enableFetch();
            break;
        }

        case 403:                               // page is forbidden
        {
            status->setText(tr("...HTTP ERROR: 403/Доступ запрещен..."));
             status->setStyleSheet("color: red;");
            mainlayout->setCurrentIndex(0);
            emit enableFetch();
            break;
        }

        case 404:                               // not found
        {
            status->setText(tr("...HTTP ERROR: 404/Страница не найдена..."));
            status->setStyleSheet("color: red;");
            mainlayout->setCurrentIndex(0);
            emit enableFetch();
            break;
        }

        default:
       {
            status->setText(tr("...HTTP ERROR: Ответ невозможно распознать..."));
            status->setStyleSheet("color: red;");
            mainlayout->setCurrentIndex(0);
            emit enableFetch();
            break;
       }
   }
   reply->deleteLater();
}

void RSSFeed::fetch(QString siteUrl)
{
    //make changing currentSite forbidden, show message about loading
    emit disableFetch();
    status->setText(tr("...ИДЕТ ЗАГРУЗКА..."));
    status->setStyleSheet("color: orange;");
    mainlayout->setCurrentIndex(0);
    treeWidget->clear();
    xml.clear();

    QUrl url(siteUrl);

    QNetworkRequest request(url);
    netman->get(request);
}

int RSSFeed::parseXml()
{
    while (!xml.atEnd()) {
        xml.readNext();
        if (xml.isStartElement()) {
            if (xml.name() == "item")
                linkString = xml.attributes().value("rss:about").toString();
            currentTag = xml.name().toString();
        } else if (xml.isEndElement()) {
            if (xml.name() == "item") {
                QTreeWidgetItem *item = new QTreeWidgetItem;
                item->setText(0, titleString);
                item->setText(1, linkString);
                treeWidget->addTopLevelItem(item);
                titleString.clear();
                linkString.clear();
            }

        } else if (xml.isCharacters() && !xml.isWhitespace()) {
            if (currentTag == "title")
                titleString += xml.text().toString();
            else if (currentTag == "link")
                linkString += xml.text().toString();
        }
    }
    if (xml.error() && xml.error() != QXmlStreamReader::PrematureEndOfDocumentError) {
        qWarning() << tr("XML ERROR:") << xml.lineNumber() << ": " << xml.errorString();

        status->setText(tr("...XML ERROR..."));
        status->setStyleSheet("color: red;");
        mainlayout->setCurrentIndex(0);
        emit enableFetch();
        return 1;
    }
    return 0;
}

void RSSFeed::AddLabel()
{
    mlText+=QString("   ~   ") + treeWidget->topLevelItem(i)->text(0);
    ml->setText(mlText);
    currentLink = treeWidget->topLevelItem(i)->text(1);
    setToolTip(currentLink);
    i++;
    if (i==treeWidget->topLevelItemCount())
        i=0;
}

void RSSFeed::DelLabel()
{
    mlText = mlText.mid(treeWidget->topLevelItem(f)->text(0).length()+7,
       mlText.length()-treeWidget->topLevelItem(f)->text(0).length()-7);
    ml->setText(mlText);
    f++;
    if (f==treeWidget->topLevelItemCount())
        f=0;
    ml->setLength(treeWidget->topLevelItem(f)->text(0).length()+7);
}







