#ifndef RSSBAR_H
#define RSSBAR_H

#include <QWidget>
#include <QPushButton>
#include <QSystemTrayIcon>
#include <QMessageBox>

#include "rssfeed.h"

class RSSBar : public QWidget
 {
     Q_OBJECT

     QPushButton *menuButton;
     QPushButton *defButton;     
     QMenu *menu;

     QAction *changeFeed;
     QAction *quitAction;

     QString currentSite;
     RSSFeed *myFeed;

public:
     RSSBar(QWidget *parent = 0);

protected:
     void paintEvent(QPaintEvent *event);
     void createMenuButton();
     void createDefaultButton();
     void createLayout();
     void createMenu();
     void createActions();
     void setAppearance();

 public slots:
     void ChangeFeed();
     void ToDefault();
     void DisableFetch();
     void EnableFetch();

 };

#endif

// RSSBAR_H
