/*cc -shared rs-applet.c  -o librsapplet.so $(pkg-config  glib-2.0  gtk+-2.0 libosso --cflags --libs) -lrs */

/*
    This file belongs to rs (Remote security) package for Nokia N900
    Copyright (C) 2009  Pavan Patale <pavan.patale@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>

#include "rs-registry.h"
#include "rs-ui.h"

#define CONFIRM -5

static void prompt_access_mode(GtkWidget *parent);


static gboolean 
encrypt_write_to_gconf(const gchar *lock,
                       const gchar *unlock,
                       const gchar *passphrase
		   )
{
    if(rs_registry_set_passphrase(passphrase) && rs_registry_set_lockcmd(lock)
	&& rs_registry_set_unlockcmd(unlock)
       	&& rs_registry_set_remote_enabled(TRUE))
    {
        return TRUE;
    }
    return FALSE;
}



static void create_dialogs(GtkWidget *parent)
{
    gboolean registered = FALSE;
    gchar *lock = NULL;
    gchar *unlock = NULL;
    GString *passphrase = NULL;

    passphrase = g_string_new(NULL);

    lock = rs_ui_create_set_pw_dialog(parent, "Lock");
    unlock = rs_ui_create_set_pw_dialog(parent, "UnLock");

    if(lock && unlock)
    {
        if(rs_ui_create_confirmation_note(parent, "Enable Remote security ?", NULL, NULL) == CONFIRM)
	{
            g_string_append_printf(passphrase, "%s%s", lock, unlock);
	    if(encrypt_write_to_gconf(lock, unlock, passphrase->str))
	        registered = TRUE;
            g_string_free(passphrase, TRUE);
	}
    }
    if(!registered) {
        rs_ui_create_information_note(GTK_WIDGET(parent), "Pls register properly, start again");
    } else {
	prompt_access_mode(GTK_WIDGET(parent));
    }
    if(lock)
        g_free(lock);
    if(unlock)
        g_free(unlock);
}

static void prompt_access_mode(GtkWidget *parent)
{
    if(rs_ui_create_confirmation_note(parent, "Remote Access Mode?", "Active", "Passive") == CONFIRM)
        rs_registry_set_rs_choice(ACTIVE);
    else
        rs_registry_set_rs_choice(PASSIVE);
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
    gchar* passphrase = NULL;
    GtkWidget *parent = GTK_WIDGET(data);
    gint rs = 0;

    if(!rs_registry_init())
        return OSSO_ERROR;

    if(rs_registry_remote_enabled())
    {
        rs = rs_registry_get_rs_choice();
	if(rs == ACTIVE)
            rs_ui_create_information_note(parent, "Remote Security enabled in Active mode");
	else
	    rs_ui_create_information_note(parent, "Remote Security enabled in Passive mode");
	passphrase = rs_ui_create_get_pw_dialog (parent, "Previous LockUnLock");
	if(passphrase && rs_registry_compare_passphrase(passphrase))
	{
      	    if(rs_ui_create_confirmation_note(parent, "Remote Locking ?", "Change", "Disable") == CONFIRM)
	    {
                if(rs_ui_create_confirmation_note(parent, "Change Codes or Access Mode ?", "Codes", "Mode") == CONFIRM)
	            create_dialogs(parent);
		else
		    prompt_access_mode(parent);
	    }
	    else
		rs_registry_set_remote_enabled(FALSE);
	}
    } 
    else 
    {
        create_dialogs(parent);
    }

    return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
    /* ... save state ... */

    return OSSO_OK;
}


